/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.composite.part;

import de.uka.ipd.sdq.pcm.gmf.composite.part.Messages;
import de.uka.ipd.sdq.pcm.gmf.composite.part.PalladioComponentModelComposedStructureDiagramEditorPlugin;
import de.uka.ipd.sdq.pcm.gmf.composite.part.PalladioComponentModelCreationWizardPage;
import de.uka.ipd.sdq.pcm.gmf.composite.part.PalladioComponentModelDiagramEditorUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class PalladioComponentModelCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected PalladioComponentModelCreationWizardPage diagramModelFilePage;
    protected PalladioComponentModelCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.PalladioComponentModelCreationWizardTitle);
        this.setDefaultPageImageDescriptor(PalladioComponentModelComposedStructureDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewEntityWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new PalladioComponentModelCreationWizardPage("DiagramModelFile", this.getSelection(), "system_diagram");
        this.diagramModelFilePage.setTitle("Create CompositeModel Diagram");
        this.diagramModelFilePage.setDescription("Select file that will contain diagram model.");
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new PalladioComponentModelCreationWizardPage("DomainModelFile", this.getSelection(), "system");
        this.domainModelFilePage.setTitle("Create CompositeModel Diagram");
        this.domainModelFilePage.setDescription("Select file that will contain domain model.");
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                PalladioComponentModelCreationWizard.this.diagram = PalladioComponentModelDiagramEditorUtil.createDiagram(PalladioComponentModelCreationWizard.this.diagramModelFilePage.getURI(), PalladioComponentModelCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (PalladioComponentModelCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && PalladioComponentModelCreationWizard.this.diagram != null) {
                    try {
                        PalladioComponentModelDiagramEditorUtil.openDiagram(PalladioComponentModelCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)PalladioComponentModelCreationWizard.this.getContainer().getShell(), (String)Messages.PalladioComponentModelCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.PalladioComponentModelCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                PalladioComponentModelComposedStructureDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

