/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.templates;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

@Singleton
public class XtextTemplateStore
extends TemplateStore {
    private static final Logger log = Logger.getLogger(XtextTemplateStore.class);
    private final URL res;

    @Inject
    public XtextTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, @Named(value="languageName") String key, AbstractUIPlugin plugin) {
        super(registry, store, String.valueOf(key) + ".templates");
        this.res = plugin.getBundle().getEntry("templates/templates.xml");
        try {
            this.load();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void loadContributedTemplates() throws IOException {
        if (this.res == null) {
            return;
        }
        TemplateReaderWriter reader = new TemplateReaderWriter();
        InputStream openStream = null;
        try {
            openStream = this.res.openStream();
            try {
                TemplatePersistenceData[] read;
                TemplatePersistenceData[] templatePersistenceDataArray = read = reader.read(openStream, null);
                int n = read.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n2];
                    this.internalAdd(templatePersistenceData);
                    ++n2;
                }
            }
            finally {
                openStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected void handleException(IOException x) {
        log.error((Object)x.getMessage(), (Throwable)x);
    }
}

