/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.templates;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ui.common.editor.templates.XtextTemplateContextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XtextTemplateContextTypeRegistry
extends ContextTypeRegistry {
    @Inject
    public XtextTemplateContextTypeRegistry(IGrammarAccess grammarAccess, Provider<XtextTemplateContextType> ctxTypeProvider) {
        this.registerContextTypes(grammarAccess, ctxTypeProvider);
    }

    protected void registerContextTypes(IGrammarAccess grammarAccess, Provider<XtextTemplateContextType> ctxTypeProvider) {
        List parserRules = GrammarUtil.allParserRules((Grammar)grammarAccess.getGrammar());
        for (ParserRule parserRule : parserRules) {
            XtextTemplateContextType type = (XtextTemplateContextType)((Object)ctxTypeProvider.get());
            type.setName(parserRule.getName());
            type.setId(this.getId(parserRule));
            this.addContextType(type);
            List keywords = EcoreUtil2.getAllContentsOfType((EObject)parserRule, Keyword.class);
            for (Keyword keyword : keywords) {
                String value = this.getId(keyword);
                if (value == null) continue;
                type = (XtextTemplateContextType)((Object)ctxTypeProvider.get());
                type.setName("Keyword '" + keyword.getValue() + "'");
                type.setId(value);
                this.addContextType(type);
            }
        }
    }

    public String getId(Keyword k) {
        return String.valueOf(GrammarUtil.getGrammar((EObject)k).getName()) + ".kw_" + k.getValue();
    }

    public String getId(ParserRule parserRule) {
        return String.valueOf(GrammarUtil.getGrammar((EObject)parserRule).getName()) + "." + parserRule.getName();
    }
}

