/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.templates;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.common.editor.templates.AbstractTemplateProposalProvider;
import org.eclipse.xtext.ui.common.editor.templates.IFollowElementCalculatorForTemplates;
import org.eclipse.xtext.ui.common.editor.templates.XtextTemplateContextTypeRegistry;
import org.eclipse.xtext.ui.common.internal.Activator;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.IFollowElementCalculator;
import org.eclipse.xtext.ui.core.editor.contentassist.ITemplateAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultTemplateProposalProvider
extends AbstractTemplateProposalProvider {
    private TemplateStore templateStore;
    private XtextTemplateContextTypeRegistry registry;
    private Image image;
    @Inject
    private IFollowElementCalculatorForTemplates followElementCalculator;

    @Inject
    public DefaultTemplateProposalProvider(TemplateStore templateStore, XtextTemplateContextTypeRegistry registry) {
        this.templateStore = templateStore;
        this.registry = registry;
    }

    @Override
    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Template[] templates;
        TemplateContextType contextType = templateContext.getContextType();
        Template[] templateArray = templates = this.templateStore.getTemplates(contextType.getId());
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (!acceptor.canAcceptMoreTemplates()) {
                return;
            }
            if (this.validate(template, templateContext)) {
                acceptor.accept(this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template)));
            }
            ++n2;
        }
    }

    @Override
    protected TemplateContextType[] getContextTypes(ContentAssistContext context) {
        LinkedHashSet<TemplateContextType> result = new LinkedHashSet<TemplateContextType>();
        FollowElementAcceptor acceptor = this.createFollowElementAcceptor(result);
        acceptor.addRootElementIfNecessary(context);
        this.followElementCalculator.calculateValidElements(context.getRootNode(), context.getLastCompleteNode(), context.getReplaceRegion().getOffset(), acceptor);
        return result.toArray(new TemplateContextType[result.size()]);
    }

    private FollowElementAcceptor createFollowElementAcceptor(Collection<TemplateContextType> result) {
        return new FollowElementAcceptor(result);
    }

    public Image getImage(Template template) {
        if (this.image == null) {
            ImageDescriptor imageDescriptor = Activator.getImageDescriptor("icons/defaultoutlinenode.gif");
            this.image = imageDescriptor.createImage();
        }
        return this.image;
    }

    public int getRelevance(Template template) {
        return 90;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FollowElementAcceptor
    implements IFollowElementCalculator.IFollowElementAcceptor {
        protected final Collection<TemplateContextType> result;

        protected FollowElementAcceptor(Collection<TemplateContextType> result) {
            this.result = result;
        }

        protected void addRootElementIfNecessary(ContentAssistContext context) {
            if (context.getRootNode().getOffset() >= context.getReplaceRegion().getOffset() && context.getRootNode().getGrammarElement() instanceof ParserRule) {
                this.addContextType((ParserRule)context.getRootNode().getGrammarElement());
            }
        }

        public void accept(AbstractElement element) {
            if (element instanceof RuleCall) {
                this.addContextType((RuleCall)element);
            } else if (element instanceof Keyword) {
                this.addContextType((Keyword)element);
            }
        }

        protected void addContextType(RuleCall call) {
            if (call.getRule() instanceof ParserRule) {
                this.addContextType((ParserRule)call.getRule());
            }
        }

        protected void addContextType(Keyword keyword) {
            this.addContextType(DefaultTemplateProposalProvider.this.registry.getId(keyword));
        }

        protected void addContextType(ParserRule rule) {
            this.addContextType(DefaultTemplateProposalProvider.this.registry.getId(rule));
        }

        protected void addContextType(String id) {
            TemplateContextType contextType = DefaultTemplateProposalProvider.this.registry.getContextType(id);
            if (contextType != null) {
                this.result.add(contextType);
            }
        }
    }
}

