/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopedElement;
import org.eclipse.xtext.ui.common.editor.templates.AbstractTemplateVariableResolver;
import org.eclipse.xtext.ui.common.editor.templates.XtextTemplateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferenceTemplateVariableResolver
extends AbstractTemplateVariableResolver {
    public CrossReferenceTemplateVariableResolver() {
        super("CrossReference", "TemplateVariableResolver for CrossReferences");
    }

    @Override
    public List<String> resolveValues(TemplateVariable variable, XtextTemplateContext castedContext) {
        String abbreviatedCrossReference = (String)variable.getVariableType().getParams().iterator().next();
        String[] classReferencePair = abbreviatedCrossReference.split("\\.");
        EReference reference = this.getReference(classReferencePair[0], classReferencePair[1], this.getGrammar(castedContext));
        IScope scope = castedContext.getScopeProvider().getScope(castedContext.getContentAssistContext().getCurrentModel(), reference);
        Iterable linkingCandidates = scope.getAllContents();
        ArrayList<String> names = new ArrayList<String>();
        for (IScopedElement scopedElement : linkingCandidates) {
            names.add(scopedElement.name());
        }
        return names;
    }

    private EReference getReference(String eClassName, String eReferenceName, Grammar grammar) {
        EClass eClass = (EClass)this.getEClassifierForGrammar(eClassName, grammar);
        if (eClass != null) {
            return (EReference)eClass.getEStructuralFeature(eReferenceName);
        }
        return null;
    }
}

