/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.syntaxcoloring;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.xtext.ui.common.editor.preferencepage.IScopedPreferenceStoreAccessor;
import org.eclipse.xtext.ui.common.editor.preferencepage.PreferenceStoreAccessor;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.EditorUtils;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ILexicalHighlightingConfiguration;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ISemanticHighlightingConfiguration;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.core.editor.utils.TextStyle;
import org.eclipse.xtext.util.Strings;

@Singleton
public class TextAttributeProvider
implements ITextAttributeProvider,
IHighlightingConfigurationAcceptor,
IPropertyChangeListener {
    private final PreferenceStoreAccessor preferencesAccessor;
    private final HashMap<String, TextAttribute> attributes;
    private final ILexicalHighlightingConfiguration lexical;
    private final ISemanticHighlightingConfiguration semantic;

    @Inject
    public TextAttributeProvider(ILexicalHighlightingConfiguration lexical, ISemanticHighlightingConfiguration semantic, IScopedPreferenceStoreAccessor preferences, PreferenceStoreAccessor preferencesAccessor) {
        this.lexical = lexical;
        this.semantic = semantic;
        this.preferencesAccessor = preferencesAccessor;
        this.attributes = new HashMap();
        preferences.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.initialize();
    }

    private void initialize() {
        this.attributes.clear();
        this.lexical.configure(this);
        this.semantic.configure(this);
    }

    public TextAttribute getAttribute(String id) {
        return this.attributes.get(id);
    }

    public TextAttribute getMergedAttributes(String[] ids) {
        if (ids.length < 2) {
            throw new IllegalStateException();
        }
        String mergedIds = this.getMergedIds(ids);
        TextAttribute result = this.getAttribute(mergedIds);
        if (result == null) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                result = this.merge(result, this.getAttribute(id));
                ++n2;
            }
            this.attributes.put(mergedIds, result);
        }
        return result;
    }

    private TextAttribute merge(TextAttribute first, TextAttribute second) {
        Font font;
        Color bgColor;
        if (first == null) {
            return second;
        }
        int style = first.getStyle() | second.getStyle();
        Color fgColor = second.getForeground();
        if (fgColor == null) {
            fgColor = first.getForeground();
        }
        if ((bgColor = second.getBackground()) == null) {
            bgColor = first.getBackground();
        }
        if ((font = second.getFont()) == null) {
            font = first.getFont();
        }
        return new TextAttribute(fgColor, bgColor, style, font);
    }

    public String getMergedIds(String[] ids) {
        return "$$$Merged:" + Strings.concat((String)"/", Arrays.asList(ids)) + "$$$";
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.initialize();
    }

    public void acceptDefaultHighlighting(String id, String name, TextStyle style) {
        if (this.attributes.put(id, this.createTextAttribute(id, style)) != null) {
            throw new IllegalStateException("Id '" + id + "' has been used twice.");
        }
    }

    protected TextAttribute createTextAttribute(String id, TextStyle defaultTextStyle) {
        TextStyle textStyle = new TextStyle();
        this.preferencesAccessor.populateTextStyle(id, textStyle, defaultTextStyle);
        int style = textStyle.getStyle();
        Font fontFromFontData = EditorUtils.fontFromFontData(textStyle.getFontData());
        return new TextAttribute(EditorUtils.colorFromRGB(textStyle.getColor()), EditorUtils.colorFromRGB(textStyle.getBackgroundColor()), style, fontFromFontData);
    }
}

