/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.syntaxcoloring;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.xtext.ui.common.editor.preferencepage.PreferenceStoreAccessor;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ILexicalHighlightingConfiguration;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ISemanticHighlightingConfiguration;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.TokenTypeDefMasterDetailFieldEditor;
import org.eclipse.xtext.ui.core.editor.preferences.AbstractPreferencePage;
import org.eclipse.xtext.ui.core.editor.utils.TextStyle;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxColoringPreferencePage
extends AbstractPreferencePage
implements IHighlightingConfigurationAcceptor,
Comparator<Triple<String, String, TextStyle>> {
    private final List<Triple<String, String, TextStyle>> highlightings = new ArrayList<Triple<String, String, TextStyle>>();
    @Inject
    private PreferenceStoreAccessor preferenceStoreAccessor;

    protected String qualifiedName() {
        return PreferenceStoreAccessor.syntaxColorerTag(this.getLanguageName());
    }

    @Inject
    public void collectLexicalHighlightings(ILexicalHighlightingConfiguration configuration) {
        configuration.configure(this);
    }

    @Inject
    public void collectSemanticHighlightings(ISemanticHighlightingConfiguration configuration) {
        configuration.configure(this);
    }

    @Override
    public void acceptDefaultHighlighting(String id, String name, TextStyle style) {
        this.highlightings.add((Triple<String, String, TextStyle>)Tuples.create((Object)id, (Object)name, (Object)style));
    }

    protected void createFieldEditors() {
        this.refreshAttributes();
        this.addField((FieldEditor)new TokenTypeDefMasterDetailFieldEditor("tokenStyles", "Token Styles", this.getFieldEditorParent(), this.getPreferenceStore(), this.highlightings));
    }

    protected void refreshAttributes() {
        Collections.sort(this.highlightings, this);
        for (Triple<String, String, TextStyle> highlighting : this.highlightings) {
            this.preferenceStoreAccessor.populateTextStyle((String)highlighting.getFirst(), new TextStyle(), (TextStyle)highlighting.getThird());
        }
    }

    @Override
    public int compare(Triple<String, String, TextStyle> left, Triple<String, String, TextStyle> right) {
        return ((String)left.getSecond()).compareTo((String)right.getSecond());
    }
}

