/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.syntaxcoloring;

import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class EditorUtils {
    private static final Logger log = Logger.getLogger(EditorUtils.class);

    public static Font fontFromFontData(FontData[] fontDataArray) {
        if (fontDataArray != null && fontDataArray.length > 0) {
            String fontData = PreferenceConverter.getStoredRepresentation((FontData[])fontDataArray);
            if (!JFaceResources.getFontRegistry().hasValueFor(fontData)) {
                FontData[] fData = PreferenceConverter.basicGetFontData((String)fontData);
                JFaceResources.getFontRegistry().put(fontData, fData);
            }
            Font font = JFaceResources.getFontRegistry().get(fontData);
            return font;
        }
        return null;
    }

    public static Color colorFromString(String rgbString) {
        if (rgbString != null && rgbString.trim().length() > 0) {
            Color col = JFaceResources.getColorRegistry().get(rgbString);
            try {
                if (col == null) {
                    RGB rgb = StringConverter.asRGB((String)rgbString);
                    JFaceResources.getColorRegistry().put(rgbString, rgb);
                    col = JFaceResources.getColorRegistry().get(rgbString);
                }
            }
            catch (DataFormatException e) {
                log.error((Object)("Corrupt color value: " + rgbString), (Throwable)e);
            }
            return col;
        }
        return null;
    }

    public static Color colorFromRGB(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return EditorUtils.colorFromString(StringConverter.asString((RGB)rgb));
    }
}

