/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.preferencepage;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.ui.common.editor.preferencepage.IScopedPreferenceStoreAccessor;
import org.eclipse.xtext.ui.core.editor.utils.TextStyle;

public class PreferenceStoreAccessor {
    private final String PREFERENCE_TAG;
    private final IScopedPreferenceStoreAccessor scopedAccessor;

    @Inject
    public PreferenceStoreAccessor(@Named(value="languageName") String languageName, IScopedPreferenceStoreAccessor scopedAccessor) {
        this.scopedAccessor = scopedAccessor;
        this.PREFERENCE_TAG = String.valueOf(PreferenceStoreAccessor.tokenTypeTag(languageName)) + '.';
    }

    public void populateTextStyle(String id, TextStyle style, TextStyle defaults) {
        Object[] fontDataArray;
        RGB background;
        String colorKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenColorPreferenceKey(id);
        String backgroundKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenBackgroundColorPreferenceKey(id);
        String fontKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenFontPreferenceKey(id);
        String styleKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenStylePreferenceKey(id);
        IPreferenceStore editorsStore = EditorsUI.getPreferenceStore();
        RGB fontColorDefaultDefault = editorsStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? this.getDisplay().getSystemColor(24).getRGB() : PreferenceConverter.getColor((IPreferenceStore)editorsStore, (String)"AbstractTextEditor.Color.Foreground");
        RGB backgrounColorDefaultDefault = editorsStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? this.getDisplay().getSystemColor(25).getRGB() : PreferenceConverter.getColor((IPreferenceStore)editorsStore, (String)"AbstractTextEditor.Color.Background");
        Object[] fontDataDefaultDefault = JFaceResources.getTextFont().getFontData();
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        if (defaults.getColor() != null) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)colorKey, (RGB)defaults.getColor());
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)colorKey, (RGB)fontColorDefaultDefault);
        }
        if (defaults.getBackgroundColor() != null) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)backgroundKey, (RGB)defaults.getBackgroundColor());
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)backgroundKey, (RGB)backgrounColorDefaultDefault);
        }
        if (defaults.getFontData() != null) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)fontKey, (FontData[])defaults.getFontData());
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)fontKey, (FontData[])fontDataDefaultDefault);
        }
        preferenceStore.setDefault(styleKey, defaults.getStyle());
        RGB color = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)colorKey);
        if (!color.equals((Object)fontColorDefaultDefault)) {
            style.setColor(color);
        }
        if (!(background = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)backgroundKey)).equals((Object)backgrounColorDefaultDefault)) {
            style.setBackgroundColor(background);
        }
        if (!Arrays.equals(fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)preferenceStore, (String)fontKey), fontDataDefaultDefault)) {
            style.setFontData((FontData[])fontDataArray);
        }
        style.setStyle(preferenceStore.getInt(styleKey));
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return this.scopedAccessor.getStore();
    }

    private Device getDisplay() {
        Display display = Display.getCurrent();
        return display == null ? Display.getDefault() : display;
    }

    public static String getTokenColorPreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "color";
    }

    public static String getTokenBackgroundColorPreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "bgColor";
    }

    public static String getTokenFontPreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "font";
    }

    public static String getTokenStylePreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "style";
    }

    public static String syntaxColorerTag(String languageName) {
        return String.valueOf(languageName) + '.' + "syntaxColorer";
    }

    public static String tokenTypeTag(String languageName) {
        return String.valueOf(PreferenceStoreAccessor.syntaxColorerTag(languageName)) + '.' + "tokenStyles";
    }
}

