/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.outline.transformer;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.common.editor.outline.ITreeProvider;
import org.eclipse.xtext.ui.common.editor.outline.transformer.ISemanticModelTransformer;
import org.eclipse.xtext.ui.common.internal.Activator;
import org.eclipse.xtext.ui.core.editor.model.XtextDocument;

public class TransformingTreeProvider
extends LabelProvider
implements ITreeProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static final Logger logger = Logger.getLogger(TransformingTreeProvider.class);
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ContentOutlineNode outlineModel;
    @Inject
    private ISemanticModelTransformer semanticModelTransformer;

    public void dispose() {
        super.dispose();
        this.resourceManager.dispose();
        this.outlineModel = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(viewer instanceof TreeViewer));
        if (newInput instanceof XtextDocument) {
            XtextDocument document = (XtextDocument)newInput;
            this.semanticModelTransformer.setDocument(document);
            this.outlineModel = (ContentOutlineNode)document.readOnly((IUnitOfWork)new IUnitOfWork<ContentOutlineNode, XtextResource>(){

                public ContentOutlineNode exec(XtextResource resource) throws Exception {
                    if (resource == null || resource.getParseResult() == null || resource.getParseResult().getRootASTElement() == null) {
                        return this.createErrorNode();
                    }
                    EObject semanticModelRoot = resource.getParseResult().getRootASTElement();
                    return TransformingTreeProvider.this.transformSemanticModelToOutlineModel(semanticModelRoot);
                }

                private ContentOutlineNode createErrorNode() {
                    ContentOutlineNode errorNode = new ContentOutlineNode();
                    errorNode.setLabel("Error: No model available.");
                    return errorNode;
                }
            });
        }
    }

    private ContentOutlineNode transformSemanticModelToOutlineModel(EObject semanticModel) {
        return this.semanticModelTransformer.transformSemanticModel(semanticModel);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ContentOutlineNode) {
            ContentOutlineNode node = (ContentOutlineNode)parentElement;
            List<ContentOutlineNode> children = node.getChildren();
            return children.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ContentOutlineNode) {
            ContentOutlineNode node = (ContentOutlineNode)element;
            return node.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContentOutlineNode) {
            ContentOutlineNode node = (ContentOutlineNode)element;
            return node.getChildren().size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.outlineModel != null) {
            List<ContentOutlineNode> children = this.outlineModel.getChildren();
            return children.toArray();
        }
        return EMPTY_ARRAY;
    }

    public String getText(Object element) {
        if (element instanceof ContentOutlineNode) {
            ContentOutlineNode contentOutlineNode = (ContentOutlineNode)element;
            return contentOutlineNode.getLabel();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ContentOutlineNode) {
            ContentOutlineNode contentOutlineNode = (ContentOutlineNode)element;
            Image image = contentOutlineNode.getImage();
            if (image == null) {
                ImageDescriptor imageDescriptor = contentOutlineNode.getImageDescriptor();
                if (imageDescriptor == null) {
                    imageDescriptor = Activator.getImageDescriptor("icons/defaultoutlinenode.gif");
                }
                image = this.resourceManager.createImage(imageDescriptor);
                contentOutlineNode.setImage(image);
            }
            return image;
        }
        return super.getImage(element);
    }
}

