/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.outline.transformer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.concurrent.IEObjectHandle;
import org.eclipse.xtext.concurrent.IStateAccess;
import org.eclipse.xtext.ui.common.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.common.editor.outline.actions.ContentOutlineNodeAdapter;
import org.eclipse.xtext.ui.common.editor.outline.actions.ContentOutlineNodeAdapterFactory;
import org.eclipse.xtext.ui.common.editor.outline.transformer.AbstractSemanticModelTransformer;
import org.eclipse.xtext.ui.core.ILocationInFileProvider;
import org.eclipse.xtext.ui.core.editor.model.XtextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSemanticModelTransformer
extends AbstractSemanticModelTransformer {
    static final Logger logger = Logger.getLogger(DefaultSemanticModelTransformer.class);
    private ILocationInFileProvider locationProvider;
    private XtextDocument document;
    @Inject
    private Provider<ContentOutlineNode> outlineNodeProvider;

    @Inject
    public void setLocationProvider(ILocationInFileProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    @Override
    public boolean consumeSemanticNode(EObject semanticNode) {
        if (semanticNode != null) {
            String name = semanticNode.eClass().getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Consume semantic node type [" + name + "]?"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean consumeSemanticChildNodes(EObject semanticNode) {
        if (semanticNode != null) {
            String name = semanticNode.eClass().getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Consume semantic children of node type [" + name + "]?"));
            }
            return true;
        }
        return false;
    }

    protected ContentOutlineNode newOutlineNode(ContentOutlineNode parent, String label, Image image, Region location) {
        ContentOutlineNode result = (ContentOutlineNode)this.outlineNodeProvider.get();
        result.setLabel(label);
        if (image != null) {
            result.setImage(image);
        }
        result.setSelectionOffset(location.getOffset());
        result.setSelectionLength(location.getLength());
        if (parent != null) {
            parent.getChildren().add(result);
            result.setParent(parent);
        }
        return result;
    }

    protected ContentOutlineNode newOutlineNode(EObject semanticNode, ContentOutlineNode outlineParentNode) {
        Region location = this.locationProvider.getLocation(semanticNode);
        String label = this.getText(semanticNode);
        Image image = this.getImage(semanticNode);
        ContentOutlineNode outlineNode = this.newOutlineNode(outlineParentNode, label, image, location);
        outlineNode.setClazz(semanticNode.eClass());
        IEObjectHandle.DefaultImpl handle = new IEObjectHandle.DefaultImpl(semanticNode, (IStateAccess)this.document);
        outlineNode.setEObjectHandle((IEObjectHandle<EObject>)handle);
        ContentOutlineNodeAdapter outlineAdapter = (ContentOutlineNodeAdapter)ContentOutlineNodeAdapterFactory.INSTANCE.adapt((Notifier)semanticNode, ContentOutlineNode.class);
        outlineAdapter.setContentOutlineNode(outlineNode);
        return outlineNode;
    }

    @Override
    protected ContentOutlineNode createOutlineNode(EObject semanticNode, ContentOutlineNode outlineParentNode) {
        return this.newOutlineNode(semanticNode, outlineParentNode);
    }

    @Override
    public void setDocument(XtextDocument document) {
        this.document = document;
    }

    public void setOutlineNodeProvider(Provider<ContentOutlineNode> outlineNodeProvider) {
        this.outlineNodeProvider = outlineNodeProvider;
    }

    public Provider<ContentOutlineNode> getOutlineNodeProvider() {
        return this.outlineNodeProvider;
    }
}

