/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.outline.transformer;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.common.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.common.editor.outline.transformer.ISemanticModelTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSemanticModelTransformer
implements ISemanticModelTransformer {
    public static final String INVISIBLE_ROOT_NODE = "Invisible Root Node";
    public static final List<EObject> NO_CHILDREN = Collections.emptyList();
    public static final ContentOutlineNode HIDDEN_NODE = new ContentOutlineNode(){

        public String getLabel() {
            return "hidden node";
        }
    };
    protected ILabelProvider labelProvider;

    @Override
    public ContentOutlineNode transformSemanticModel(EObject semanticModel) {
        ContentOutlineNode outlineModel = new ContentOutlineNode();
        outlineModel.setLabel(INVISIBLE_ROOT_NODE);
        this.transformSemanticNode(semanticModel, outlineModel);
        return outlineModel;
    }

    public void transformSemanticNode(EObject semanticNode, ContentOutlineNode outlineParentNode) {
        ContentOutlineNode outlineNode = this.consumeSemanticNode(semanticNode) ? this.createOutlineNode(semanticNode, outlineParentNode) : outlineParentNode;
        if (outlineNode == HIDDEN_NODE) {
            outlineNode = outlineParentNode;
        }
        this.transformSemanticChildNodes(semanticNode, outlineNode);
    }

    private void transformSemanticChildNodes(EObject semanticNode, ContentOutlineNode outlineNode) {
        if (this.consumeSemanticChildNodes(semanticNode)) {
            List<EObject> list = this.getChildNodes(semanticNode);
            for (EObject semanticChildNode : list) {
                this.transformSemanticNode(semanticChildNode, outlineNode);
            }
        }
    }

    protected List<EObject> getChildNodes(EObject semanticNode) {
        return this.getChildren(semanticNode);
    }

    protected List<EObject> getChildren(EObject semanticNode) {
        return semanticNode.eContents();
    }

    protected abstract ContentOutlineNode createOutlineNode(EObject var1, ContentOutlineNode var2);

    protected abstract boolean consumeSemanticChildNodes(EObject var1);

    protected abstract boolean consumeSemanticNode(EObject var1);

    @Inject
    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public String getText(EObject object) {
        return this.labelProvider.getText((Object)object);
    }

    public Image getImage(EObject object) {
        return this.labelProvider.getImage((Object)object);
    }
}

