/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.outline.linking;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.outline.XtextContentOutlinePage;
import org.eclipse.xtext.ui.common.editor.outline.linking.AbstractSelectionChangedListener;

public final class EditorSelectionChangedListener
extends AbstractSelectionChangedListener {
    public EditorSelectionChangedListener(XtextContentOutlinePage outlinePage) {
        super(outlinePage);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.outlinePage.isLinkingEnabled() && !selection.isEmpty() && selection instanceof ITextSelection) {
            final ITextSelection textSel = (ITextSelection)selection;
            this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    IParseResult parseResult = resource.getParseResult();
                    Assert.isNotNull((Object)parseResult);
                    CompositeNode rootNode = parseResult.getRootNode();
                    int offset = textSel.getOffset();
                    AbstractNode node = ParseTreeUtil.getCurrentOrFollowingNodeByOffset((AbstractNode)rootNode, (int)offset);
                    EditorSelectionChangedListener.this.outlinePage.synchronizeOutlinePage(node);
                }
            });
        }
    }
}

