/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.outline.linking;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.xtext.ui.common.editor.outline.XtextContentOutlinePage;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.core.editor.model.XtextDocumentUtil;

public abstract class AbstractSelectionChangedListener
implements ISelectionChangedListener {
    protected final XtextContentOutlinePage outlinePage;

    public AbstractSelectionChangedListener(XtextContentOutlinePage outlinePage) {
        this.outlinePage = outlinePage;
    }

    public void install(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void uninstall(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public IXtextDocument getDocument() {
        return XtextDocumentUtil.get((Object)this.getSourceViewer());
    }

    protected ISourceViewer getSourceViewer() {
        Assert.isNotNull((Object)((Object)this.outlinePage));
        return this.outlinePage.getSourceViewer();
    }

    public XtextContentOutlinePage getOutlinePage() {
        return this.outlinePage;
    }
}

