/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.outline;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.common.editor.outline.ITreeProvider;
import org.eclipse.xtext.ui.common.editor.outline.actions.ContentOutlineNodeAdapter;
import org.eclipse.xtext.ui.common.editor.outline.actions.IActionBarContributor;
import org.eclipse.xtext.ui.common.editor.outline.actions.IContentOutlineNodeAdapterFactory;
import org.eclipse.xtext.ui.common.editor.outline.linking.EditorSelectionChangedListener;
import org.eclipse.xtext.ui.common.editor.outline.linking.LinkingHelper;
import org.eclipse.xtext.ui.common.editor.outline.linking.OutlineSelectionChangedListener;
import org.eclipse.xtext.ui.core.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.core.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.core.editor.XtextEditor;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.core.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.core.editor.model.XtextDocumentUtil;

public class XtextContentOutlinePage
extends ContentOutlinePage
implements ISourceViewerAware,
IXtextEditorAware {
    static final Logger logger = Logger.getLogger(XtextContentOutlinePage.class);
    @Inject
    private ITreeProvider provider;
    @Inject
    private IContentOutlineNodeAdapterFactory outlineNodeFactory;
    @Inject
    private IActionBarContributor actionbarContributor;
    private XtextEditor editor;
    private ISourceViewer sourceViewer;
    private OutlineSelectionChangedListener outlineSelectionChangedListener;
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private IXtextModelListener modelListener;
    private Menu contextMenu;
    private static final String contextMenuID = "xtextOutlineContextMenu";
    private ViewerSorter sorter = new TreePathViewerSorter();

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.configureViewer();
        this.configureContextMenu();
        this.configureProviders();
        this.configureDocument();
        this.registerToolbarActions(this.getSite().getActionBars());
    }

    private void configureViewer() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.setAutoExpandLevel(2);
        viewer.setUseHashlookup(false);
    }

    private void configureContextMenu() {
        MenuManager manager = new MenuManager(contextMenuID, contextMenuID);
        manager.setRemoveAllWhenShown(true);
        this.contextMenu = manager.createContextMenu((Control)this.getTreeViewer().getTree());
        this.getTreeViewer().getTree().setMenu(this.contextMenu);
        IPageSite site = this.getSite();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.outlineNodeFactory, ContentOutlineNode.class);
        site.registerContextMenu("org.eclipse.xtext.ui.common.outline", manager, (ISelectionProvider)this.getTreeViewer());
    }

    protected void configureProviders() {
        Assert.isNotNull((Object)this.provider, (String)"No ILazyTreeProvider available. Dependency injection broken?");
        this.getTreeViewer().setContentProvider((IContentProvider)this.provider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.provider);
    }

    private void configureDocument() {
        if (this.sourceViewer != null) {
            IDocument document = this.sourceViewer.getDocument();
            IXtextDocument xtextDocument = XtextDocumentUtil.get((Object)document);
            this.installModelListener();
            this.internalSetInput(xtextDocument, true);
        }
    }

    private void installModelListener() {
        if (this.sourceViewer != null) {
            IDocument document = this.sourceViewer.getDocument();
            IXtextDocument xtextDocument = XtextDocumentUtil.get((Object)document);
            if (this.modelListener == null) {
                this.modelListener = new IXtextModelListener(){

                    public void modelChanged(XtextResource resource) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Document has been changed. Triggering update of outline.");
                        }
                        XtextContentOutlinePage.this.refresh();
                    }
                };
            }
            xtextDocument.addModelListener(this.modelListener);
        }
    }

    private void uninstallModelListener() {
        IDocument document;
        IXtextDocument xtextDocument;
        if (this.sourceViewer != null && (xtextDocument = XtextDocumentUtil.get((Object)(document = this.sourceViewer.getDocument()))) != null) {
            xtextDocument.removeModelListener(this.modelListener);
        }
    }

    public IXtextDocument getDocument() {
        return XtextDocumentUtil.get((Object)this.getSourceViewer());
    }

    protected void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (this.actionbarContributor != null) {
            this.actionbarContributor.init(toolBarManager, this);
        }
    }

    public void dispose() {
        this.outlineSelectionChangedListener.uninstall((ISelectionProvider)this);
        this.outlineSelectionChangedListener = null;
        this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        this.editorSelectionChangedListener = null;
        this.uninstallModelListener();
        if (this.editor != null) {
            this.editor.outlinePageClosed();
            this.editor = null;
        }
        this.provider.dispose();
        this.provider = null;
        super.dispose();
    }

    private void runInSWTThread(Runnable runnable) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private void internalSetInput(IXtextDocument xtextDocument, boolean initial) {
        TreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            Object[] expandedElements = null;
            expandedElements = tree.getExpandedElements();
            tree.setInput((Object)xtextDocument);
            if (expandedElements != null && expandedElements.length > 0) {
                tree.setExpandedElements(expandedElements);
            }
        }
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
        this.getOutlineSelectionListener().install((ISelectionProvider)this);
        this.getEditorSelectionChangedListener().install(sourceViewer.getSelectionProvider());
    }

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    public XtextEditor getEditor() {
        return this.editor;
    }

    private OutlineSelectionChangedListener getOutlineSelectionListener() {
        if (this.outlineSelectionChangedListener == null) {
            this.outlineSelectionChangedListener = new OutlineSelectionChangedListener(this);
        }
        return this.outlineSelectionChangedListener;
    }

    private EditorSelectionChangedListener getEditorSelectionChangedListener() {
        if (this.editorSelectionChangedListener == null) {
            this.editorSelectionChangedListener = new EditorSelectionChangedListener(this);
        }
        return this.editorSelectionChangedListener;
    }

    public boolean isLinkingEnabled() {
        return LinkingHelper.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean enabled) {
        LinkingHelper.setLinkingEnabled(enabled);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection, reveal);
        }
    }

    public void synchronizeOutlinePage() {
        this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                int caretOffset = XtextContentOutlinePage.this.getSourceViewer().getTextWidget().getCaretOffset();
                IParseResult parseResult = resource.getParseResult();
                Assert.isNotNull((Object)parseResult);
                CompositeNode rootNode = parseResult.getRootNode();
                AbstractNode currentNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)caretOffset);
                XtextContentOutlinePage.this.synchronizeOutlinePage(currentNode);
            }
        });
    }

    private boolean shouldSynchronizeOutlinePage() {
        return this.isLinkingEnabled();
    }

    private ContentOutlineNode findMostSignificantOutlineNode(AbstractNode node) {
        CompositeNode compositeNode;
        EObject astElement;
        if (node != null && (astElement = NodeUtil.getASTElementForRootNode((CompositeNode)(compositeNode = node instanceof CompositeNode ? (CompositeNode)node : node.getParent()))) != null) {
            ContentOutlineNodeAdapter adapter = (ContentOutlineNodeAdapter)EcoreUtil.getAdapter((List)astElement.eAdapters(), ContentOutlineNode.class);
            if (adapter != null) {
                ContentOutlineNode contentOutlineNode = adapter.getContentOutlineNode();
                if (contentOutlineNode != null) {
                    return contentOutlineNode;
                }
            } else {
                CompositeNode parent = node.getParent();
                return this.findMostSignificantOutlineNode((AbstractNode)parent);
            }
        }
        return null;
    }

    public void synchronizeOutlinePage(AbstractNode node) {
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (this.shouldSynchronizeOutlinePage()) {
            ContentOutlineNode mostSignificantOutlineNode = this.findMostSignificantOutlineNode(node);
            if (mostSignificantOutlineNode != null) {
                selection = new StructuredSelection((Object)mostSignificantOutlineNode);
            }
            this.outlineSelectionChangedListener.uninstall((ISelectionProvider)this);
            this.setSelection((ISelection)selection, true);
            this.outlineSelectionChangedListener.install((ISelectionProvider)this);
        }
    }

    public void setSorted(boolean sorted) {
        if (this.getTreeViewer() != null) {
            if (sorted) {
                this.getTreeViewer().setSorter(this.sorter);
            } else {
                this.getTreeViewer().setSorter(null);
            }
        }
    }

    public void enableFilter(ViewerFilter filter) {
        if (this.getTreeViewer() != null) {
            ViewerFilter[] filters;
            ViewerFilter[] viewerFilterArray = filters = this.getTreeViewer().getFilters();
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n2];
                if (viewerFilter.equals(filter)) {
                    return;
                }
                ++n2;
            }
            this.getTreeViewer().addFilter(filter);
        }
    }

    public void disableFilter(ViewerFilter filter) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().removeFilter(filter);
        }
    }

    private void refresh() {
        this.runInSWTThread(new Runnable(){

            public void run() {
                TreeViewer tv = XtextContentOutlinePage.this.getTreeViewer();
                if (tv != null) {
                    IDocument document = XtextContentOutlinePage.this.sourceViewer.getDocument();
                    XtextContentOutlinePage.this.internalSetInput(XtextDocumentUtil.get((Object)document), false);
                    tv.refresh();
                }
            }
        });
    }
}

