/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.hyperlinking;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.ILocationInFileProvider;
import org.eclipse.xtext.ui.core.editor.ReadonlyArchiveStorage;
import org.eclipse.xtext.ui.core.editor.ReadonlyFileStorage;
import org.eclipse.xtext.ui.core.editor.ReadonlyStorage;
import org.eclipse.xtext.ui.core.editor.XtextEditor;
import org.eclipse.xtext.ui.core.editor.XtextReadonlyEditorInput;

public class OpenDeclarationAction
extends Action {
    private static final Logger logger = Logger.getLogger(OpenDeclarationAction.class);
    private final URI uri;
    private final ILocationInFileProvider locationProvider;

    public OpenDeclarationAction(URI uri, ILocationInFileProvider locationProvider) {
        this.uri = uri;
        this.locationProvider = locationProvider;
    }

    public void run() {
        this.doOpen(this.uri);
    }

    public URI getURI() {
        return this.uri;
    }

    public void doOpen(final URI uri) {
        IFile file = this.getContainingResourceSetFile(uri);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart openEditor = null;
        try {
            if (file != null) {
                openEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            } else if (uri.isArchive()) {
                XtextReadonlyEditorInput input = new XtextReadonlyEditorInput((ReadonlyStorage)new ReadonlyArchiveStorage(uri));
                openEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(uri.lastSegment()).getId());
            } else {
                URL url = FileLocator.toFileURL((URL)new URL(String.valueOf(uri.scheme()) + ":" + uri.devicePath()));
                URI urlAsUri = URI.createURI((String)url.toString());
                String path = urlAsUri.toFileString();
                if (path != null) {
                    File ioFile = new File(path);
                    XtextReadonlyEditorInput input = new XtextReadonlyEditorInput((ReadonlyStorage)new ReadonlyFileStorage(ioFile, uri));
                    openEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(uri.lastSegment()).getId());
                }
            }
        }
        catch (PartInitException partInitException) {
            logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), (Throwable)partInitException);
        }
        catch (IOException e) {
            logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), (Throwable)e);
        }
        if (openEditor != null && openEditor instanceof XtextEditor) {
            final XtextEditor edit = (XtextEditor)openEditor;
            if (uri.fragment() != null) {
                edit.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource resource) throws Exception {
                        EObject object = resource.getEObject(uri.fragment());
                        Region region = OpenDeclarationAction.this.locationProvider.getLocation(object);
                        edit.selectAndReveal(region.getOffset(), region.getLength());
                    }
                });
            }
        } else {
            boolean cfr_ignored_0 = openEditor instanceof ISelectionProvider;
        }
    }

    private IFile getContainingResourceSetFile(URI uri) {
        String path = null;
        if (uri.isPlatformResource()) {
            path = uri.toPlatformString(true);
        } else if (uri.isPlatformPlugin()) {
            path = uri.toPlatformString(true);
        } else if (uri.isFile()) {
            path = uri.toFileString();
        } else if (uri.isArchive()) {
            URI archiveUri = URI.createURI((String)uri.authority());
            String archive = null;
            archive = archiveUri.isFile() ? archiveUri.toFileString() : (archiveUri.isPlatformResource() ? archiveUri.toPlatformString(true) : archiveUri.toString());
            path = String.valueOf(uri.scheme()) + ":" + archive + uri.path();
        } else {
            path = uri.toString();
        }
        IFile result = null;
        if (uri.isPlatformResource()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        } else {
            IResource res;
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            if (result == null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && res instanceof IFile) {
                result = (IFile)res;
            }
        }
        return result;
    }
}

