/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.hyperlinking;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.hyperlinking.ActionBasedHyperlink;
import org.eclipse.xtext.ui.common.editor.hyperlinking.OpenDeclarationAction;
import org.eclipse.xtext.ui.core.ILocationInFileProvider;
import org.eclipse.xtext.util.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkHelper {
    private final ILinkingService linkingService;
    private final ILocationInFileProvider locationProvider;
    private final ILabelProvider labelProvider;

    @Inject
    public HyperlinkHelper(ILinkingService linkingService, ILocationInFileProvider locationProvider, ILabelProvider labelProvider) {
        this.linkingService = linkingService;
        this.locationProvider = locationProvider;
        this.labelProvider = labelProvider;
    }

    public ActionBasedHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        IParseResult parseResult = resource.getParseResult();
        Assert.isNotNull((Object)parseResult);
        AbstractNode abstractNode = ParseTreeUtil.getCurrentOrFollowingNodeByOffset((AbstractNode)parseResult.getRootNode(), (int)offset);
        Wrapper location = Wrapper.wrap((Object)new Region(abstractNode.getOffset(), abstractNode.getLength()));
        List<EObject> crossLinkedEObjects = this.findCrossLinkedEObject(abstractNode, (Wrapper<Region>)location);
        if (crossLinkedEObjects.isEmpty()) {
            return null;
        }
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        ArrayList<ActionBasedHyperlink> links = new ArrayList<ActionBasedHyperlink>();
        for (EObject crossReffed : crossLinkedEObjects) {
            if (!links.isEmpty() && !createMultipleHyperlinks) break;
            String label = this.labelProvider.getText((Object)crossReffed);
            URI uri = EcoreUtil.getURI((EObject)crossReffed);
            URI normalized = uriConverter.normalize(uri);
            links.add(new ActionBasedHyperlink(label, (Region)location.get(), new OpenDeclarationAction(normalized, this.locationProvider)));
        }
        return links.toArray(new ActionBasedHyperlink[links.size()]);
    }

    public OpenDeclarationAction getOpenDeclarationAction(XtextResource resource, int offset) {
        AbstractNode node = ParseTreeUtil.getCurrentOrFollowingNodeByOffset((AbstractNode)resource.getParseResult().getRootNode(), (int)offset);
        List<EObject> crossLinkedEObject = this.findCrossLinkedEObject(node, null);
        if (crossLinkedEObject.isEmpty()) {
            return null;
        }
        URI uri = EcoreUtil.getURI((EObject)crossLinkedEObject.get(0));
        URI normalized = resource.getResourceSet().getURIConverter().normalize(uri);
        return new OpenDeclarationAction(normalized, this.locationProvider);
    }

    protected List<EObject> findCrossLinkedEObject(AbstractNode node, Wrapper<Region> location) {
        AbstractNode nodeToCheck = node;
        while (nodeToCheck != null && !(nodeToCheck.getGrammarElement() instanceof Assignment)) {
            if (nodeToCheck.getGrammarElement() instanceof CrossReference) {
                EObject semanticModel = NodeUtil.getNearestSemanticObject((AbstractNode)nodeToCheck);
                EReference eReference = GrammarUtil.getReference((CrossReference)((CrossReference)nodeToCheck.getGrammarElement()), (EClass)semanticModel.eClass());
                try {
                    if (location != null) {
                        location.set((Object)new Region(nodeToCheck.getOffset(), nodeToCheck.getLength()));
                    }
                    return this.linkingService.getLinkedObjects(semanticModel, eReference, nodeToCheck);
                }
                catch (IllegalNodeException illegalNodeException) {
                    return Collections.emptyList();
                }
            }
            nodeToCheck = nodeToCheck.getParent();
        }
        return Collections.emptyList();
    }
}

