/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.hyperlinking;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.common.editor.hyperlinking.OpenDeclarationAction;
import org.eclipse.xtext.ui.core.editor.XtextEditor;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;

public class DefaultHyperlinkDetector
extends AbstractHandler
implements IHyperlinkDetector {
    private final HyperlinkHelper helper;

    @Inject
    public DefaultHyperlinkDetector(HyperlinkHelper helper) {
        this.helper = helper;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, final IRegion region, final boolean canShowMultipleHyperlinks) {
        return (IHyperlink[])((IXtextDocument)textViewer.getDocument()).readOnly((IUnitOfWork)new IUnitOfWork<IHyperlink[], XtextResource>(){

            public IHyperlink[] exec(XtextResource resource) throws Exception {
                return DefaultHyperlinkDetector.this.helper.createHyperlinksByOffset(resource, region.getOffset(), canShowMultipleHyperlinks);
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor activeEditor = (XtextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IXtextDocument document = activeEditor.getDocument();
        final int offset = ((StyledText)activeEditor.getAdapter(Control.class)).getCaretOffset();
        document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                OpenDeclarationAction action = DefaultHyperlinkDetector.this.helper.getOpenDeclarationAction(resource, offset);
                action.run();
            }
        });
        return this;
    }
}

