/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist.antlr.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.LookAheadTerminal;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.LookAheadTerminalRuleCall;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.LookaheadKeyword;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.ObservableXtextTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInternalContentAssistParser
extends Parser
implements ObservableXtextTokenStream.StreamListener,
ITokenDefProvider {
    private final List<EObject> grammarElements = new ArrayList<EObject>();
    private final List<EObject> localTrace = new ArrayList<EObject>();
    private int stackSize;
    private final Set<FollowElement> followElements = new LinkedHashSet<FollowElement>();
    private ObservableXtextTokenStream.StreamListener delegate;
    private List<TerminalRule> terminalRules;
    private boolean mismatch;

    public AbstractInternalContentAssistParser(TokenStream input) {
        super(input);
    }

    public void before(EObject grammarElement) {
        this.grammarElements.add(grammarElement);
        this.localTrace.add(grammarElement);
    }

    public void after(EObject grammarElement) {
        EObject foundGrammarElement = this.grammarElements.remove(this.grammarElements.size() - 1);
        if (grammarElement != foundGrammarElement) {
            throw new IllegalStateException("expected element: '" + grammarElement + "', but was: '" + foundGrammarElement + "'");
        }
    }

    public void recover(IntStream stream, RecognitionException ex) {
        this.removeUnexpectedElements();
        super.recover(stream, ex);
    }

    private void removeUnexpectedElements() {
        while (this.stackSize < this.grammarElements.size()) {
            this.grammarElements.remove(this.grammarElements.size() - 1);
        }
    }

    public void emitErrorMessage(String msg) {
    }

    protected abstract Grammar getGrammar();

    protected int keepStackSize() {
        int result = this.stackSize;
        this.stackSize = this.grammarElements.size();
        return result;
    }

    protected void restoreStackSize(int stackSize) {
        if (this.backtracking == 0) {
            this.removeUnexpectedElements();
            this.stackSize = stackSize;
        }
    }

    protected void selectEofStrategy() {
        this.delegate = this.mismatch ? new ObservableXtextTokenStream.StreamListener(){
            private boolean wasErrorRecovery = false;

            public void announceEof(int lookAhead) {
                AbstractElement current;
                boolean bl = this.wasErrorRecovery = this.wasErrorRecovery || AbstractInternalContentAssistParser.this.errorRecovery;
                if (!this.wasErrorRecovery && !AbstractInternalContentAssistParser.this.mismatch && (current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement()) != null) {
                    AbstractInternalContentAssistParser.this.followElements.add(AbstractInternalContentAssistParser.this.createFollowElement(current, lookAhead));
                }
            }

            public void announceConsume() {
                AbstractInternalContentAssistParser.this.announceConsume();
            }
        } : (!this.errorRecovery ? new ObservableXtextTokenStream.StreamListener(){

            public void announceEof(int lookAhead) {
                AbstractElement current;
                if (!AbstractInternalContentAssistParser.this.errorRecovery && !AbstractInternalContentAssistParser.this.mismatch && (current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement()) != null) {
                    AbstractInternalContentAssistParser.this.followElements.add(AbstractInternalContentAssistParser.this.createFollowElement(current, lookAhead));
                }
            }

            public void announceConsume() {
                AbstractInternalContentAssistParser.this.announceConsume();
            }
        } : new ObservableXtextTokenStream.StreamListener(){
            private AbstractElement lastAddedElement;

            public void announceEof(int lookAhead) {
                AbstractElement current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement();
                if (!(current == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                    AbstractInternalContentAssistParser.this.followElements.add(AbstractInternalContentAssistParser.this.createFollowElement(current, lookAhead));
                    this.lastAddedElement = current;
                }
            }

            public void announceConsume() {
                AbstractInternalContentAssistParser.this.announceConsume();
            }
        });
    }

    protected void mismatch(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        try {
            this.mismatch = true;
            super.mismatch(input, ttype, follow);
        }
        finally {
            this.mismatch = false;
        }
    }

    private AbstractElement getCurrentGrammarElement() {
        int i = this.grammarElements.size() - 1;
        while (i >= 0) {
            EObject result = this.grammarElements.get(this.grammarElements.size() - 1);
            if (result instanceof AbstractElement) {
                return (AbstractElement)result;
            }
            --i;
        }
        return null;
    }

    private FollowElement createFollowElement(AbstractElement current, int lookAhead) {
        FollowElement result = new FollowElement();
        result.setLookAhead(lookAhead);
        if (lookAhead != 1) {
            ArrayList lookAheadTerminals = Lists.newArrayListWithExpectedSize((int)(lookAhead - 1));
            int i = 1;
            while (i < lookAhead) {
                Token token = this.input.LT(i);
                if (token == Token.EOF_TOKEN) {
                    result.setLookAhead(i);
                    break;
                }
                LookAheadTerminal lookAheadTerminal = this.createLookAheadTerminal(token);
                lookAheadTerminals.add(lookAheadTerminal);
                ++i;
            }
            if (!lookAheadTerminals.isEmpty()) {
                result.setLookAheadTerminals(lookAheadTerminals);
            }
        }
        result.setGrammarElement(current);
        result.setTrace(Lists.newArrayList((Iterator)Iterators.filter(this.grammarElements.iterator(), AbstractElement.class)));
        result.setLocalTrace(Lists.newArrayList((Iterator)Iterators.filter(this.localTrace.iterator(), AbstractElement.class)));
        return result;
    }

    public LookAheadTerminal createLookAheadTerminal(Token token) {
        Grammar grammar = this.getGrammar();
        String tokenName = this.getTokenNames()[token.getType()];
        if (tokenName.charAt(0) == '\'') {
            LookaheadKeyword result = new LookaheadKeyword();
            result.setKeyword(tokenName.substring(1, tokenName.length() - 1));
            result.setToken(token);
            return result;
        }
        LookAheadTerminalRuleCall result = new LookAheadTerminalRuleCall();
        result.setToken(token);
        String ruleName = tokenName.substring(5);
        if (this.terminalRules == null) {
            this.terminalRules = GrammarUtil.allTerminalRules((Grammar)grammar);
        }
        for (TerminalRule rule : this.terminalRules) {
            if (!rule.getName().equalsIgnoreCase(ruleName)) continue;
            result.setRule(rule);
            return result;
        }
        throw new IllegalArgumentException("tokenType " + token.getType() + " seems to be invalid.");
    }

    @Override
    public void announceEof(int lookAhead) {
        if (this.delegate == null) {
            this.selectEofStrategy();
        }
        if (this.grammarElements.isEmpty() || this.delegate == null) {
            return;
        }
        this.delegate.announceEof(lookAhead);
    }

    @Override
    public void announceConsume() {
        this.localTrace.clear();
    }

    public Set<FollowElement> getFollowElements() {
        return this.followElements;
    }

    public Map<Integer, String> getTokenDefMap() {
        String[] names = this.getTokenNames();
        HashMap result = Maps.newHashMapWithExpectedSize((int)(names.length - 4));
        int i = 4;
        while (i < names.length) {
            result.put(i, this.getValueForTokenName(names[i]));
            ++i;
        }
        return result;
    }

    protected String getValueForTokenName(String tokenName) {
        return tokenName;
    }

    public List<EObject> getGrammarElements() {
        return this.grammarElements;
    }

    public List<EObject> getLocalTrace() {
        return this.localTrace;
    }
}

