/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist.antlr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.parsetree.util.ParsetreeSwitch;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.contentassist.AbstractContentAssistContextFactory;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.IContentAssistParser;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.IFollowElementCalculator;
import org.eclipse.xtext.ui.core.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.XtextSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserBasedContentAssistContextFactory
extends AbstractContentAssistContextFactory {
    @Inject
    private IContentAssistParser parser;
    @Inject
    private Provider<ContentAssistContext> contentAssistContextProvider;
    @Inject
    private PrefixMatcher matcher;

    public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
        try {
            Collection<FollowElement> followElements;
            String completeInput;
            String prefix;
            AbstractNode currentNode;
            CompositeNode rootNode;
            AbstractNode lastCompleteNode;
            IParseResult parseResult = resource.getParseResult();
            if (parseResult == null) {
                throw new NullPointerException("parseResult is null");
            }
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            int completionOffset = offset;
            if (selection.getOffset() + selection.getLength() == offset) {
                completionOffset = selection.getOffset();
            }
            if ((lastCompleteNode = (AbstractNode)new LeafNodeFinder(completionOffset, true).doSwitch((EObject)(rootNode = parseResult.getRootNode()))) == null) {
                lastCompleteNode = rootNode;
            }
            if ((currentNode = (AbstractNode)new LeafNodeFinder(completionOffset, false).doSwitch((EObject)rootNode)) == null) {
                currentNode = lastCompleteNode;
            }
            AbstractNode lastVisibleNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)completionOffset);
            EObject currentModel = NodeUtil.getNearestSemanticObject((AbstractNode)lastVisibleNode);
            ArrayList result = Lists.newArrayList();
            AbstractNode datatypeNode = this.getContainingDatatypeRuleNode(lastCompleteNode);
            if (datatypeNode != lastCompleteNode) {
                prefix = this.getPrefix(datatypeNode, completionOffset);
                completeInput = viewer.getDocument().get(0, datatypeNode.getOffset());
                followElements = this.parser.getFollowElements(completeInput);
                this.createContexts(viewer, parseResult, completionOffset, rootNode, datatypeNode, datatypeNode, result, prefix, currentModel, followElements);
            }
            if (datatypeNode == lastCompleteNode && completionOffset != lastCompleteNode.getOffset()) {
                prefix = this.getPrefix(lastCompleteNode, completionOffset);
                completeInput = viewer.getDocument().get(0, lastCompleteNode.getOffset());
                AbstractNode previousNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)lastCompleteNode.getOffset());
                EObject previousModel = NodeUtil.getNearestSemanticObject((AbstractNode)previousNode);
                AbstractNode currentDatatypeNode = this.getContainingDatatypeRuleNode(currentNode);
                Collection<FollowElement> followElements2 = this.parser.getFollowElements(completeInput);
                this.createContexts(viewer, parseResult, completionOffset, rootNode, previousNode, currentDatatypeNode, result, prefix, previousModel, followElements2);
            }
            if (!(lastCompleteNode instanceof LeafNode && lastCompleteNode.getGrammarElement() == null || lastCompleteNode instanceof LeafNode && ((LeafNode)lastCompleteNode).isHidden())) {
                prefix = "";
                completeInput = viewer.getDocument().get(0, completionOffset);
                followElements = this.parser.getFollowElements(completeInput);
                this.createContexts(viewer, parseResult, completionOffset, rootNode, lastCompleteNode, currentNode, result, prefix, currentModel, followElements);
            }
            return result.toArray(new ContentAssistContext[result.size()]);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void createContexts(ITextViewer viewer, IParseResult parseResult, int completionOffset, CompositeNode rootNode, AbstractNode lastCompleteNode, AbstractNode currentNode, List<ContentAssistContext> result, String prefix, EObject previousModel, Collection<FollowElement> followElements) {
        Multimap<EObject, FollowElement> contextMap = this.computeCurrentModel(previousModel, lastCompleteNode, followElements);
        for (Map.Entry entry : contextMap.asMap().entrySet()) {
            ContentAssistContext context = this.createContext(viewer, completionOffset, parseResult, rootNode, lastCompleteNode, (EObject)entry.getKey(), currentNode, prefix);
            this.computeFollowElements((Collection)entry.getValue(), context);
            result.add(context);
        }
    }

    private Multimap<EObject, FollowElement> computeCurrentModel(EObject currentModel, AbstractNode lastCompleteNode, Collection<FollowElement> followElements) {
        ArrayListMultimap result = Multimaps.newArrayListMultimap();
        NodeAdapter adapter = NodeUtil.getNodeAdapter((EObject)currentModel);
        if (adapter == null || adapter.getParserNode() == null) {
            result.putAll((Object)currentModel, followElements);
            return result;
        }
        CompositeNode currentParserNode = adapter.getParserNode();
        EObject currentGrammarElement = currentParserNode.getGrammarElement();
        AbstractRule currentRule = this.getRule(currentGrammarElement);
        for (FollowElement element : followElements) {
            AbstractElement grammarElement = element.getGrammarElement();
            if (!element.getLocalTrace().isEmpty()) {
                grammarElement = element.getLocalTrace().get(0);
            }
            EObject loopGrammarElement = currentGrammarElement;
            AbstractRule rule = currentRule;
            CompositeNode loopParserNode = currentParserNode;
            EObject loopLastGrammarElement = lastCompleteNode.getGrammarElement();
            while (!this.canBeCalledAfter(rule, loopLastGrammarElement, (EObject)grammarElement) && loopParserNode.getParent() != null) {
                loopLastGrammarElement = loopParserNode.getGrammarElement();
                loopParserNode = loopParserNode.getParent();
                while (loopParserNode.getGrammarElement() == null && loopParserNode.getParent() != null) {
                    loopParserNode = loopParserNode.getParent();
                }
                loopGrammarElement = loopParserNode.getGrammarElement();
                rule = this.getRule(loopGrammarElement);
            }
            EObject context = NodeUtil.getNearestSemanticObject((AbstractNode)loopParserNode);
            result.put((Object)context, (Object)element);
        }
        return result;
    }

    private boolean canBeCalledAfter(AbstractRule rule, final EObject previousGrammarElement, final EObject nextGrammarElement) {
        return (Boolean)new XtextSwitch<Boolean>(){
            private Set<AbstractRule> visiting = new HashSet<AbstractRule>();
            private EObject grammarElement;
            private Boolean result;
            {
                this.grammarElement = eObject;
                this.result = Boolean.FALSE;
            }

            public Boolean caseAbstractRule(AbstractRule object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (!this.visiting.add(object)) {
                    return false;
                }
                Boolean result = (Boolean)this.doSwitch((EObject)object.getAlternatives());
                this.visiting.remove(object);
                return result;
            }

            private boolean checkFurther(EObject object) {
                if (object == this.grammarElement) {
                    if (this.grammarElement == previousGrammarElement) {
                        this.grammarElement = nextGrammarElement;
                        return true;
                    }
                    this.result = Boolean.TRUE;
                    return false;
                }
                return true;
            }

            public Boolean caseTerminalRule(TerminalRule object) {
                this.checkFurther((EObject)object);
                return this.result;
            }

            public Boolean caseGroup(Group object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                for (AbstractElement token : object.getTokens()) {
                    if (!((Boolean)this.doSwitch((EObject)token)).booleanValue()) continue;
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    for (AbstractElement token : object.getTokens()) {
                        if (!((Boolean)this.doSwitch((EObject)token)).booleanValue()) continue;
                        return true;
                    }
                }
                return false;
            }

            public Boolean caseAlternatives(Alternatives object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                for (AbstractElement group : object.getGroups()) {
                    if (!((Boolean)this.doSwitch((EObject)group)).booleanValue()) continue;
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    for (AbstractElement group : object.getGroups()) {
                        if (!((Boolean)this.doSwitch((EObject)group)).booleanValue()) continue;
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseAbstractElement(AbstractElement object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object) && !this.checkFurther((EObject)object)) {
                    return this.result;
                }
                return Boolean.FALSE;
            }

            public Boolean caseAssignment(Assignment object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseCrossReference(CrossReference object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseRuleCall(RuleCall object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    if (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                return (Boolean)this.doSwitch((EObject)object.getLiteral());
            }
        }.doSwitch((EObject)rule);
    }

    private AbstractRule getRule(EObject currentGrammarElement) {
        AbstractRule rule = null;
        if (currentGrammarElement instanceof RuleCall) {
            rule = ((RuleCall)currentGrammarElement).getRule();
        }
        if (currentGrammarElement instanceof AbstractRule) {
            rule = (AbstractRule)currentGrammarElement;
        }
        if (currentGrammarElement instanceof Action) {
            rule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)currentGrammarElement, AbstractRule.class);
        }
        if (rule == null) {
            throw new IllegalStateException();
        }
        return rule;
    }

    private void computeFollowElements(Collection<FollowElement> followElements, final ContentAssistContext result) {
        FollowElementCalculator calculator = new FollowElementCalculator();
        calculator.acceptor = new IFollowElementCalculator.IFollowElementAcceptor(){

            public void accept(AbstractElement element) {
                ParserRule rule = GrammarUtil.containingParserRule((EObject)element);
                if (rule == null || !GrammarUtil.isDatatypeRule((ParserRule)rule)) {
                    result.accept(element);
                }
            }
        };
        for (FollowElement element : followElements) {
            this.computeFollowElements(calculator, element);
        }
    }

    private void computeFollowElements(FollowElementCalculator calculator, FollowElement element) {
        if (element.getLookAhead() <= 1) {
            Assignment ass = (Assignment)EcoreUtil2.getContainerOfType((EObject)element.getGrammarElement(), Assignment.class);
            if (ass != null) {
                calculator.doSwitch((EObject)ass);
            } else {
                calculator.doSwitch((EObject)element.getGrammarElement());
                ParserRule rule = (ParserRule)EcoreUtil2.getContainerOfType((EObject)element.getGrammarElement(), ParserRule.class);
                if (rule != null && GrammarUtil.isDatatypeRule((ParserRule)rule)) {
                    int i = element.getLocalTrace().size() - 1;
                    while (i >= 0) {
                        AbstractElement grammarElement = element.getLocalTrace().get(i);
                        if (grammarElement instanceof Assignment) {
                            calculator.doSwitch((EObject)grammarElement);
                            return;
                        }
                        --i;
                    }
                }
            }
            return;
        }
        Collection<FollowElement> followElements = this.parser.getFollowElements(element);
        for (FollowElement newElement : followElements) {
            this.computeFollowElements(calculator, newElement);
        }
    }

    public AbstractNode getContainingDatatypeRuleNode(AbstractNode node) {
        AbstractNode result = node;
        EObject grammarElement = result.getGrammarElement();
        if (grammarElement != null) {
            ParserRule parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            while (parserRule != null && GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
                result = result.getParent();
                grammarElement = result.getGrammarElement();
                parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            }
        }
        return result;
    }

    public ContentAssistContext createContext(ITextViewer viewer, int offset, IParseResult parseResult, CompositeNode rootNode, AbstractNode lastCompleteNode, EObject currentModel, AbstractNode currentNode, String prefix) {
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        ContentAssistContext context = (ContentAssistContext)this.contentAssistContextProvider.get();
        context.setRootNode(rootNode);
        context.setLastCompleteNode(lastCompleteNode);
        context.setCurrentNode(currentNode);
        context.setRootModel(parseResult.getRootASTElement());
        context.setCurrentModel(currentModel);
        context.setOffset(offset);
        context.setViewer(viewer);
        context.setPrefix(prefix);
        int regionLength = prefix.length();
        if (selection.getLength() > 0) {
            regionLength += selection.getLength();
        }
        Region region = new Region(offset - prefix.length(), regionLength);
        context.setReplaceRegion(region);
        context.setSelectedText(selection.getText());
        context.setMatcher(this.matcher);
        return context;
    }

    public String getPrefix(AbstractNode prefixNode, int offset) {
        if (prefixNode instanceof LeafNode) {
            if (((LeafNode)prefixNode).isHidden()) {
                return "";
            }
            return this.getNodeText(prefixNode, offset);
        }
        StringBuilder result = new StringBuilder(prefixNode.getTotalLength());
        this.doComputePrefix((CompositeNode)prefixNode, result, offset);
        return result.toString();
    }

    public String getNodeText(AbstractNode currentNode, int offset) {
        String text;
        int startOffset = currentNode.getOffset();
        int length = offset - startOffset;
        String result = length > (text = ((LeafNode)currentNode).getText()).length() ? text : text.substring(0, length);
        return result;
    }

    public boolean doComputePrefix(CompositeNode node, StringBuilder result, int offset) {
        ArrayList<LeafNode> hiddens = new ArrayList<LeafNode>(2);
        for (AbstractNode child : node.getChildren()) {
            if (child instanceof CompositeNode) {
                if (this.doComputePrefix((CompositeNode)child, result, offset)) continue;
                return false;
            }
            LeafNode leaf = (LeafNode)child;
            if (leaf.getOffset() > offset) {
                return false;
            }
            if (leaf.isHidden()) {
                if (result.length() == 0) continue;
                hiddens.add((LeafNode)child);
                continue;
            }
            Iterator iter = hiddens.iterator();
            while (iter.hasNext()) {
                result.append(((LeafNode)iter.next()).getText());
            }
            hiddens.clear();
            result.append(this.getNodeText((AbstractNode)leaf, offset));
            if (leaf.getOffset() + leaf.getLength() <= offset) continue;
            return false;
        }
        return true;
    }

    public void setParser(IContentAssistParser parser) {
        this.parser = parser;
    }

    public IContentAssistParser getParser() {
        return this.parser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FollowElementCalculator
    extends XtextSwitch<Boolean> {
        protected IFollowElementCalculator.IFollowElementAcceptor acceptor;

        public Boolean caseAlternatives(Alternatives object) {
            boolean more = false;
            for (AbstractElement element : object.getGroups()) {
                boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false || more;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseGroup(Group object) {
            boolean more = true;
            for (AbstractElement element : object.getTokens()) {
                boolean bl = more = more && (Boolean)this.doSwitch((EObject)element) != false;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseAction(Action object) {
            return true;
        }

        public Boolean caseAssignment(Assignment object) {
            this.acceptor.accept((AbstractElement)object);
            if (!((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue() && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseCrossReference(CrossReference object) {
            return Boolean.FALSE;
        }

        public Boolean caseParserRule(ParserRule object) {
            if (GrammarUtil.isDatatypeRule((ParserRule)object)) {
                return Boolean.FALSE;
            }
            return (Boolean)this.doSwitch((EObject)object.getAlternatives());
        }

        public Boolean caseEnumRule(EnumRule object) {
            return (Boolean)this.doSwitch((EObject)object.getAlternatives());
        }

        public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
            return (Boolean)this.doSwitch((EObject)object.getLiteral());
        }

        public Boolean caseRuleCall(RuleCall object) {
            this.acceptor.accept((AbstractElement)object);
            if (!((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue() && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseTerminalRule(TerminalRule object) {
            return Boolean.FALSE;
        }

        public Boolean caseKeyword(Keyword object) {
            this.acceptor.accept((AbstractElement)object);
            return this.isOptional((AbstractElement)object);
        }

        public boolean isOptional(AbstractElement element) {
            return GrammarUtil.isOptionalCardinality((AbstractElement)element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LeafNodeFinder
    extends ParsetreeSwitch<LeafNode> {
        private final int offset;
        private final boolean leading;

        public LeafNodeFinder(int offset, boolean leading) {
            this.offset = offset;
            this.leading = leading;
        }

        public LeafNode caseCompositeNode(CompositeNode object) {
            block4: {
                block3: {
                    if (!this.leading) break block3;
                    if (object.getTotalOffset() >= this.offset || object.getTotalLength() + object.getTotalOffset() < this.offset) break block4;
                    for (AbstractNode node : object.getChildren()) {
                        LeafNode result = (LeafNode)this.doSwitch((EObject)node);
                        if (result == null) continue;
                        return result;
                    }
                    break block4;
                }
                if (object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
                    for (AbstractNode node : object.getChildren()) {
                        LeafNode result = (LeafNode)this.doSwitch((EObject)node);
                        if (result == null) continue;
                        return result;
                    }
                }
            }
            return null;
        }

        public LeafNode caseLeafNode(LeafNode object) {
            if (this.leading ? object.getTotalOffset() < this.offset && object.getTotalLength() + object.getTotalOffset() >= this.offset : object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
                return object;
            }
            return null;
        }
    }
}

