/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist.antlr;

import com.google.inject.Inject;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.ui.common.editor.contentassist.ProposalConflictHelper;

public class AntlrProposalConflictHelper
extends ProposalConflictHelper {
    @Inject
    private Lexer proposalLexer;
    @Inject
    private Lexer lastCompleteLexer;
    @Inject
    private Lexer combinedLexer;

    public boolean existsConflict(String lastCompleteText, String proposal) {
        this.initLexer(lastCompleteText, proposal);
        if (!this.equalTokenSequence(this.lastCompleteLexer, this.combinedLexer)) {
            return true;
        }
        if (!this.equalTokenSequence(this.proposalLexer, this.combinedLexer)) {
            return true;
        }
        Token lastToken = this.proposalLexer.nextToken();
        return !lastToken.equals(Token.EOF_TOKEN);
    }

    protected boolean equalTokenSequence(Lexer first, Lexer second) {
        Token token = null;
        while (!(token = first.nextToken()).equals(Token.EOF_TOKEN)) {
            Token otherToken = second.nextToken();
            if (otherToken.equals(Token.EOF_TOKEN)) {
                return false;
            }
            if (token.getText().equals(otherToken.getText())) continue;
            return false;
        }
        return true;
    }

    protected void initLexer(String lastCompleteText, String proposal) {
        String combinedText = lastCompleteText.concat(proposal);
        this.initLexer(combinedText, this.combinedLexer);
        this.initLexer(lastCompleteText, this.lastCompleteLexer);
        this.initLexer(proposal, this.proposalLexer);
    }

    protected void initLexer(String text, Lexer lexer) {
        ANTLRStringStream stream = new ANTLRStringStream(text);
        lexer.setCharStream((CharStream)stream);
    }

    public Lexer getProposalLexer() {
        return this.proposalLexer;
    }

    public void setProposalLexer(Lexer proposalLexer) {
        this.proposalLexer = proposalLexer;
    }

    public Lexer getCombinedLexer() {
        return this.combinedLexer;
    }

    public void setCombinedLexer(Lexer combinedLexer) {
        this.combinedLexer = combinedLexer;
    }

    public void setLastCompleteLexer(Lexer lastCompleteLexer) {
        this.lastCompleteLexer = lastCompleteLexer;
    }

    public Lexer getLastCompleteLexer() {
        return this.lastCompleteLexer;
    }
}

