/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.ui.core.editor.contentassist.IFollowElementCalculator;
import org.eclipse.xtext.util.XtextSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFollowElementCalculator
implements IFollowElementCalculator {
    public void calculateValidElements(CompositeNode rootNode, AbstractNode lastCompleteNode, int offset, IFollowElementCalculator.IFollowElementAcceptor acceptor) {
        Set<AbstractElement> nextValidElementSet = this.getValidElementSet(rootNode, lastCompleteNode, offset);
        if (nextValidElementSet != null && !nextValidElementSet.isEmpty()) {
            NullSafeElementAcceptor nullSafeAcceptor = new NullSafeElementAcceptor(acceptor);
            FirstSetCalculator elementSwitch = this.createFirstSetCalculator(nullSafeAcceptor);
            for (AbstractElement element : nextValidElementSet) {
                elementSwitch.doSwitch((EObject)element);
            }
        }
    }

    protected FirstSetCalculator createFirstSetCalculator(IFollowElementCalculator.IFollowElementAcceptor acceptor) {
        return new FirstSetCalculator(acceptor);
    }

    public Set<AbstractElement> getValidElementSet(CompositeNode rootNode, AbstractNode lastCompleteNode, int offset) {
        return ParseTreeUtil.getElementSetValidFromOffset((CompositeNode)rootNode, (AbstractNode)lastCompleteNode, (int)offset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirstSetCalculator
    extends XtextSwitch<FirstSetCalculator> {
        protected final IFollowElementCalculator.IFollowElementAcceptor acceptor;

        public FirstSetCalculator(IFollowElementCalculator.IFollowElementAcceptor acceptor) {
            this.acceptor = acceptor;
        }

        public FirstSetCalculator caseAlternatives(Alternatives alternatives) {
            for (AbstractElement alternativeElement : alternatives.getGroups()) {
                this.doSwitch((EObject)alternativeElement);
            }
            return this;
        }

        public FirstSetCalculator caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
            this.doSwitch((EObject)object.getLiteral());
            this.acceptor.accept((AbstractElement)object);
            return this;
        }

        public FirstSetCalculator caseGroup(Group group) {
            for (AbstractElement token : group.getTokens()) {
                this.doSwitch((EObject)token);
                if (this.isOptional(token)) continue;
                return this;
            }
            return this;
        }

        public FirstSetCalculator caseAssignment(Assignment assignment) {
            this.acceptor.accept((AbstractElement)assignment);
            this.doSwitch((EObject)assignment.getTerminal());
            return this;
        }

        public FirstSetCalculator caseRuleCall(RuleCall ruleCall) {
            this.doSwitch((EObject)ruleCall.getRule());
            return this;
        }

        public FirstSetCalculator caseAbstractRule(AbstractRule object) {
            return this;
        }

        public FirstSetCalculator caseParserRule(ParserRule object) {
            this.doSwitch((EObject)object.getAlternatives());
            return this;
        }

        public FirstSetCalculator caseEnumRule(EnumRule object) {
            this.doSwitch((EObject)object.getAlternatives());
            return this;
        }

        public FirstSetCalculator caseAbstractElement(AbstractElement object) {
            return this;
        }

        public FirstSetCalculator caseKeyword(Keyword object) {
            this.acceptor.accept((AbstractElement)object);
            return this;
        }

        public boolean isOptional(AbstractElement element) {
            return element instanceof Action || GrammarUtil.isOptionalCardinality((AbstractElement)element);
        }
    }

    public static class NullSafeElementAcceptor
    implements IFollowElementCalculator.IFollowElementAcceptor {
        private final IFollowElementCalculator.IFollowElementAcceptor decorated;

        public NullSafeElementAcceptor(IFollowElementCalculator.IFollowElementAcceptor decorated) {
            this.decorated = decorated;
        }

        public void accept(AbstractElement element) {
            if (element != null) {
                this.decorated.accept(element);
            }
        }
    }
}

