/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.IFollowElementCalculator;
import org.eclipse.xtext.ui.core.editor.contentassist.PrefixMatcher;

public class DefaultContentAssistContextFactory
implements ContentAssistContext.Factory {
    @Inject
    private IFollowElementCalculator followElementCalculator;
    @Inject
    private Provider<ContentAssistContext> contentAssistContextProvider;
    @Inject
    private PrefixMatcher matcher;

    public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
        ArrayList<ContentAssistContext> result = new ArrayList<ContentAssistContext>(2);
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            throw new NullPointerException("parseResult is null");
        }
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        int fixedOffset = offset;
        if (selection.getOffset() + selection.getLength() == offset) {
            fixedOffset = selection.getOffset();
        }
        CompositeNode rootNode = parseResult.getRootNode();
        AbstractNode lastCompleteNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)fixedOffset);
        lastCompleteNode = this.getContainingDatatypeRuleNode(lastCompleteNode);
        EObject currentModel = NodeUtil.getNearestSemanticObject((AbstractNode)lastCompleteNode);
        AbstractNode currentNode = ParseTreeUtil.getCurrentOrFollowingNodeByOffset((AbstractNode)rootNode, (int)fixedOffset);
        currentNode = this.getContainingDatatypeRuleNode(currentNode);
        if (lastCompleteNode.getOffset() + lastCompleteNode.getLength() == fixedOffset) {
            AbstractNode precedingLastCompleteNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)Math.max(0, lastCompleteNode.getOffset()));
            String prefix = this.getPrefix(lastCompleteNode, fixedOffset);
            result.add(this.createContext(viewer, fixedOffset, parseResult, rootNode, precedingLastCompleteNode, currentModel, lastCompleteNode, prefix));
            if (lastCompleteNode.getGrammarElement() != null && (lastCompleteNode.getGrammarElement() instanceof Keyword || lastCompleteNode.getGrammarElement() instanceof CrossReference || lastCompleteNode.getGrammarElement() instanceof RuleCall && ((RuleCall)lastCompleteNode.getGrammarElement()).getRule() instanceof TerminalRule)) {
                result.add(this.createContext(viewer, fixedOffset, parseResult, rootNode, lastCompleteNode, currentModel, currentNode, ""));
            }
        } else if (lastCompleteNode == currentNode) {
            AbstractNode precedingLastCompleteNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)Math.max(0, lastCompleteNode.getOffset()));
            String prefix = this.getPrefix(currentNode, fixedOffset);
            result.add(this.createContext(viewer, fixedOffset, parseResult, rootNode, precedingLastCompleteNode, currentModel, currentNode, prefix));
        } else {
            String prefix = this.getPrefix(currentNode, fixedOffset);
            result.add(this.createContext(viewer, fixedOffset, parseResult, rootNode, lastCompleteNode, currentModel, currentNode, prefix));
        }
        return result.toArray(new ContentAssistContext[result.size()]);
    }

    public AbstractNode getContainingDatatypeRuleNode(AbstractNode node) {
        AbstractNode result = node;
        EObject grammarElement = result.getGrammarElement();
        if (grammarElement != null) {
            ParserRule parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            while (parserRule != null && GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
                result = result.getParent();
                grammarElement = result.getGrammarElement();
                parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            }
        }
        return result;
    }

    public ContentAssistContext createContext(ITextViewer viewer, int offset, IParseResult parseResult, CompositeNode rootNode, AbstractNode lastCompleteNode, EObject currentModel, AbstractNode currentNode, String prefix) {
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        ContentAssistContext context = (ContentAssistContext)this.contentAssistContextProvider.get();
        context.setRootNode(rootNode);
        context.setLastCompleteNode(lastCompleteNode);
        context.setCurrentNode(currentNode);
        context.setRootModel(parseResult.getRootASTElement());
        context.setCurrentModel(currentModel);
        context.setOffset(offset);
        context.setViewer(viewer);
        context.setPrefix(prefix);
        int regionLength = prefix.length();
        if (selection.getLength() > 0) {
            regionLength += selection.getLength();
        }
        Region region = new Region(offset - prefix.length(), regionLength);
        context.setReplaceRegion(region);
        context.setSelectedText(selection.getText());
        this.followElementCalculator.calculateValidElements(rootNode, lastCompleteNode, offset, (IFollowElementCalculator.IFollowElementAcceptor)context);
        context.setMatcher(this.matcher);
        return context;
    }

    public String getPrefix(AbstractNode prefixNode, int offset) {
        if (prefixNode instanceof LeafNode) {
            if (((LeafNode)prefixNode).isHidden()) {
                return "";
            }
            return this.getNodeText(prefixNode, offset);
        }
        StringBuilder result = new StringBuilder(prefixNode.getTotalLength());
        this.doComputePrefix((CompositeNode)prefixNode, result, offset);
        return result.toString();
    }

    public String getNodeText(AbstractNode currentNode, int offset) {
        String text;
        int startOffset = currentNode.getOffset();
        int length = offset - startOffset;
        String result = length > (text = ((LeafNode)currentNode).getText()).length() ? text : text.substring(0, length);
        return result;
    }

    public boolean doComputePrefix(CompositeNode node, StringBuilder result, int offset) {
        ArrayList<LeafNode> hiddens = new ArrayList<LeafNode>(2);
        for (AbstractNode child : node.getChildren()) {
            if (child instanceof CompositeNode) {
                if (this.doComputePrefix((CompositeNode)child, result, offset)) continue;
                return false;
            }
            LeafNode leaf = (LeafNode)child;
            if (leaf.getOffset() > offset) {
                return false;
            }
            if (leaf.isHidden()) {
                if (result.length() == 0) continue;
                hiddens.add((LeafNode)child);
                continue;
            }
            Iterator iter = hiddens.iterator();
            while (iter.hasNext()) {
                result.append(((LeafNode)iter.next()).getText());
            }
            hiddens.clear();
            result.append(this.getNodeText((AbstractNode)leaf, offset));
            if (leaf.getOffset() + leaf.getLength() <= offset) continue;
            return false;
        }
        return true;
    }
}

