/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.core.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableCompletionProposal
implements Comparable<ConfigurableCompletionProposal>,
ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension4 {
    private static final Logger log = Logger.getLogger(ConfigurableCompletionProposal.class);
    private String displayString;
    private String replacementString;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private String additionalProposalInfo;
    private boolean autoInsertable = true;
    private int selectionLength = 0;
    private int selectionStart;
    private boolean linkedMode;
    private ITextViewer viewer;
    private char[] exitChars;
    private PrefixMatcher matcher;
    private int replaceContextLength;
    private int priority;
    private Point rememberedSelection;

    public ConfigurableCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public ConfigurableCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.selectionStart = replacementOffset + cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.getReplacementOffset(), this.getReplacementLength(), this.getReplacementString());
            if (this.linkedMode) {
                this.setUpLinkedMode(document);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.getSelectionStart(), this.getSelectionLength());
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableCompletionProposal)) {
            return false;
        }
        String otherDisplayString = ((ConfigurableCompletionProposal)obj).getDisplayString();
        return Strings.equal((String)otherDisplayString, (String)this.getDisplayString());
    }

    public int hashCode() {
        String displayString = this.getDisplayString();
        return displayString != null ? displayString.hashCode() : 31;
    }

    public boolean isAutoInsertable() {
        return this.autoInsertable;
    }

    public void setAutoInsertable(boolean autoInsertable) {
        this.autoInsertable = autoInsertable;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.replacementOffset = replacementOffset;
    }

    public void setReplacementLength(int replacementLength) {
        this.replacementLength = replacementLength;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.contextInformation = contextInformation;
    }

    public void setAdditionalProposalInfo(String additionalProposalInfo) {
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public void setSelectionLength(int selectionLength) {
        this.selectionLength = selectionLength;
    }

    public void setSelectionStart(int selectionStart) {
        this.selectionStart = selectionStart;
    }

    public void setSimpleLinkedMode(ITextViewer viewer, char ... exitChars) {
        this.linkedMode = true;
        this.viewer = viewer;
        this.exitChars = exitChars;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        boolean replaceRight;
        this.setReplacementLength(offset - this.getReplacementOffset() + viewer.getSelectedRange().y);
        boolean bl = replaceRight = (stateMask & 0x40000) != 0;
        if (replaceRight) {
            this.setReplacementLength(this.getReplaceContextLength());
        }
        this.apply(viewer.getDocument());
    }

    private void updateSelection(ITextViewer viewer) {
        this.rememberedSelection = viewer.getSelectedRange();
        int offset = this.rememberedSelection.x;
        int length = this.getReplaceContextLength() - (offset - this.getReplacementOffset());
        viewer.setSelectedRange(offset, length);
    }

    private void restoreSelection(ITextViewer viewer) {
        if (this.rememberedSelection != null) {
            viewer.setSelectedRange(this.rememberedSelection.x, this.rememberedSelection.y);
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (smartToggle) {
            this.updateSelection(viewer);
        } else {
            this.restoreSelection(viewer);
            this.rememberedSelection = null;
        }
    }

    public void unselected(ITextViewer viewer) {
        this.restoreSelection(viewer);
        this.rememberedSelection = null;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (event != null) {
            int oldReplaceContextLength = this.getReplaceContextLength();
            int diff = event.getText().length() - event.getLength();
            this.setReplaceContextLength(oldReplaceContextLength + diff);
        }
        try {
            String prefix = document.get(this.replacementOffset, offset - this.replacementOffset);
            return this.matcher.isCandidateMatchingPrefix(this.replacementString, prefix);
        }
        catch (BadLocationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void setMatcher(PrefixMatcher matcher) {
        this.matcher = matcher;
    }

    public PrefixMatcher getMatcher() {
        return this.matcher;
    }

    public void setReplaceContextLength(int replaceContextLength) {
        this.replaceContextLength = replaceContextLength;
    }

    public int getReplaceContextLength() {
        return this.replaceContextLength;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ConfigurableCompletionProposal other) {
        if (this.priority < other.getPriority()) {
            return 1;
        }
        if (this.priority > other.getPriority()) {
            return -1;
        }
        return this.getDisplayString().compareTo(other.getDisplayString());
    }

    protected void setUpLinkedMode(IDocument document) {
        try {
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, this.getSelectionStart(), this.getSelectionLength(), -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            LinkedModeUI ui = new LinkedModeUI(model, this.viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(this.exitChars));
            ui.setExitPosition(this.viewer, this.getCursorPosition() + this.getReplacementOffset(), 0, Integer.MAX_VALUE);
            ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            ui.enter();
        }
        catch (BadLocationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private final char[] exitCharacters;

        public ExitPolicy(char[] exitCharacter) {
            this.exitCharacters = exitCharacter;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == '\u0000') {
                return null;
            }
            char[] cArray = this.exitCharacters;
            int n = this.exitCharacters.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (event.character == c) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                ++n2;
            }
            switch (event.character) {
                case '\r': {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }
    }
}

