/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.IScopedElement;
import org.eclipse.xtext.ui.common.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.common.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBasedContentProposalProvider
extends AbstractContentProposalProvider {
    private static final Logger logger = Logger.getLogger(AbstractJavaBasedContentProposalProvider.class);
    @Inject
    private IScopeProvider scopeProvider;
    private final Map<String, PolymorphicDispatcher<Void>> dispatchers = new HashMap<String, PolymorphicDispatcher<Void>>();

    protected AbstractJavaBasedContentProposalProvider() {
    }

    @Override
    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("completeKeyword '" + keyword.getValue() + "' for model '" + contentAssistContext.getCurrentModel() + "' and prefix '" + contentAssistContext.getPrefix() + "'"));
        }
        ICompletionProposal proposal = this.createCompletionProposal((EObject)keyword, keyword.getValue(), contentAssistContext);
        this.adjustPriority(proposal, contentAssistContext.getPrefix(), this.getKeywordPriority());
        acceptor.accept(proposal);
    }

    public void adjustPriority(ICompletionProposal proposal, String prefix, int priority) {
        if (proposal == null || !(proposal instanceof ConfigurableCompletionProposal)) {
            return;
        }
        ConfigurableCompletionProposal castedProposal = (ConfigurableCompletionProposal)proposal;
        if (castedProposal.getPriority() != this.getDefaultPriority()) {
            return;
        }
        int adjustedPriority = priority;
        if (!Strings.isEmpty((String)prefix)) {
            adjustedPriority = castedProposal.getReplacementString().equals(prefix) ? (int)((double)adjustedPriority * this.getSameTextMultiplier()) : (adjustedPriority *= this.getProposalWithPrefixMultiplier());
        }
        castedProposal.setPriority(adjustedPriority);
    }

    @Override
    public void completeRuleCall(RuleCall ruleCall, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("completeRuleCall '" + ruleCall.getRule().getName() + "' cardinality '" + ruleCall.getCardinality() + "' for model '" + contentAssistContext.getCurrentModel() + "' and prefix '" + contentAssistContext.getPrefix() + "'"));
        }
        AbstractRule calledRule = ruleCall.getRule();
        String methodName = "complete_" + calledRule.getName();
        this.invokeMethod(methodName, acceptor, contentAssistContext.getCurrentModel(), ruleCall, contentAssistContext);
    }

    @Override
    public void completeAssignment(Assignment assignment, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        ParserRule parserRule = GrammarUtil.containingParserRule((EObject)assignment);
        String methodName = "complete" + Strings.toFirstUpper((String)parserRule.getName()) + "_" + Strings.toFirstUpper((String)assignment.getFeature());
        this.invokeMethod(methodName, acceptor, contentAssistContext.getCurrentModel(), assignment, contentAssistContext);
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, (Predicate<IScopedElement>)Predicates.alwaysTrue());
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Function<IScopedElement, ICompletionProposal> proposalFactory) {
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, (Predicate<IScopedElement>)Predicates.alwaysTrue(), proposalFactory);
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IScopedElement> filter) {
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        if (!GrammarUtil.isDatatypeRule((ParserRule)containingParserRule)) {
            EClass eClass = (EClass)containingParserRule.getType().getClassifier();
            EReference ref = GrammarUtil.getReference((CrossReference)crossReference, (EClass)eClass);
            this.lookupCrossReference(crossReference, ref, contentAssistContext, acceptor, filter);
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IScopedElement> filter, Function<IScopedElement, ICompletionProposal> proposalFactory) {
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        if (!GrammarUtil.isDatatypeRule((ParserRule)containingParserRule)) {
            EClass eClass = (EClass)containingParserRule.getType().getClassifier();
            EReference ref = GrammarUtil.getReference((CrossReference)crossReference, (EClass)eClass);
            this.lookupCrossReference((EObject)crossReference, ref, acceptor, filter, proposalFactory);
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, EReference reference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IScopedElement> filter) {
        String ruleName = null;
        if (crossReference.getTerminal() instanceof RuleCall) {
            ruleName = ((RuleCall)crossReference.getTerminal()).getRule().getName();
        }
        this.lookupCrossReference(contentAssistContext.getCurrentModel(), reference, acceptor, filter, this.getProposalFactory(ruleName, contentAssistContext));
    }

    protected void lookupCrossReference(EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IScopedElement> filter, Function<IScopedElement, ICompletionProposal> proposalFactory) {
        IScope scope = this.getScopeProvider().getScope(model, reference);
        Iterable candidates = scope.getAllContents();
        for (IScopedElement candidate : candidates) {
            if (!acceptor.canAcceptMoreProposals()) {
                return;
            }
            if (!filter.apply((Object)candidate)) continue;
            acceptor.accept((ICompletionProposal)proposalFactory.apply((Object)candidate));
        }
    }

    protected Function<IScopedElement, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        return new DefaultProposalCreator(contentAssistContext, ruleName);
    }

    protected void invokeMethod(String methodName, ICompletionProposalAcceptor acceptor, Object ... params) {
        PolymorphicDispatcher<Void> dispatcher = this.dispatchers.get(methodName);
        if (dispatcher == null) {
            PolymorphicDispatcher.ErrorHandler errorHandler = PolymorphicDispatcher.NullErrorHandler.get();
            dispatcher = new PolymorphicDispatcher<Void>(methodName, params.length + 1, params.length + 1, Collections.singletonList(this), errorHandler){

                public Class<?> getDefaultClass(int paramIndex) {
                    if (paramIndex == 0) {
                        return EObject.class;
                    }
                    return super.getDefaultClass(paramIndex);
                }
            };
            this.dispatchers.put(methodName, dispatcher);
        }
        Object[] paramAsArray = new Object[params.length + 1];
        System.arraycopy(params, 0, paramAsArray, 0, params.length);
        paramAsArray[params.length] = acceptor;
        dispatcher.invoke(paramAsArray);
    }

    public void setScopeProvider(IScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultProposalCreator
    implements Function<IScopedElement, ICompletionProposal> {
        private final ContentAssistContext contentAssistContext;
        private final String ruleName;

        protected DefaultProposalCreator(ContentAssistContext contentAssistContext, String ruleName) {
            this.contentAssistContext = contentAssistContext;
            this.ruleName = ruleName;
        }

        public ICompletionProposal apply(IScopedElement candidate) {
            ICompletionProposal result = null;
            if (this.ruleName != null) {
                String proposal = AbstractJavaBasedContentProposalProvider.this.getValueConverter().toString((Object)AbstractJavaBasedContentProposalProvider.this.getDisplayString(candidate), this.ruleName);
                result = AbstractJavaBasedContentProposalProvider.this.createCompletionProposal(candidate.element(), proposal, AbstractJavaBasedContentProposalProvider.this.getDisplayString(candidate), this.contentAssistContext);
            } else {
                result = AbstractJavaBasedContentProposalProvider.this.createCompletionProposal(candidate, this.contentAssistContext);
            }
            AbstractJavaBasedContentProposalProvider.this.adjustPriority(result, this.contentAssistContext.getPrefix(), AbstractJavaBasedContentProposalProvider.this.getCrossReferencePriority());
            return result;
        }
    }
}

