/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.common.editor.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.scoping.IScopedElement;
import org.eclipse.xtext.ui.common.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.common.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.core.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.util.XtextSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentProposalProvider
implements IContentProposalProvider {
    private int crossReferencePriority = 500;
    private int keywordPriority = 300;
    private int defaultPriority = 400;
    private int proposalWithPrefixMultiplier = 2;
    private double sameTextMultiplier = 0.75;
    @Inject
    protected ILabelProvider labelProvider;
    @Inject
    private IValueConverterService valueConverter;
    @Inject
    private IProposalConflictHelper conflictHelper;

    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        NullSafeCompletionProposalAcceptor nullSafe = new NullSafeCompletionProposalAcceptor(acceptor);
        DefaultContentAssistProcessorSwitch selector = new DefaultContentAssistProcessorSwitch(context, (ICompletionProposalAcceptor)nullSafe);
        for (AbstractElement element : context.getFirstSetGrammarElements()) {
            selector.doSwitch((EObject)element);
        }
    }

    public abstract void completeKeyword(Keyword var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public abstract void completeRuleCall(RuleCall var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public abstract void completeAssignment(Assignment var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public DefaultContentAssistProcessorSwitch createSelector(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        return new DefaultContentAssistProcessorSwitch(context, acceptor);
    }

    public ICompletionProposalAcceptor filter(ICompletionProposalAcceptor acceptor, Predicate<ICompletionProposal> filter) {
        return new FilteringCompletionProposalAcceptor(acceptor, (Predicate<ICompletionProposal>)Predicates.and((Predicate)Predicates.notNull(), filter));
    }

    public ICompletionProposalAcceptor modify(ICompletionProposalAcceptor acceptor, Function<ICompletionProposal, ICompletionProposal> modifier) {
        return new ModifyingCompletionProposalAcceptor(acceptor, modifier);
    }

    protected ICompletionProposal createCompletionProposal(IScopedElement element, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(element.element(), element.name(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(EObject element, String proposal, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, this.getDisplayString(element, proposal), this.getImage(element), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(EObject element, String proposal, String displayString, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, this.getImage(element), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(IScopedElement element, String prefix, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(element.element(), element.name(), this.getDisplayString(element), prefix, contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(EObject element, String proposal, String displayString, String prefix, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, this.getImage(element), prefix, contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, proposal, null, this.getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, proposal, image, this.getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, String displayString, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, image, this.getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, String displayString, Image image, String prefix, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, image, this.getDefaultPriority(), prefix, contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, String displayString, Image image, int priority, String prefix, ContentAssistContext context) {
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        return this.createCompletionProposal(proposal, displayString, image, priority, replacementOffset, replacementLength, prefix, context);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, String displayString, Image image, int priority, int replacementOffset, int replacementLength, String prefix, ContentAssistContext context) {
        if (this.isValidProposal(proposal, prefix, context)) {
            return this.doCreateProposal(proposal, displayString, image, priority, replacementOffset, replacementLength, context);
        }
        return null;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (!context.getMatcher().isCandidateMatchingPrefix(proposal, prefix)) {
            return false;
        }
        return !this.conflictHelper.existsConflict(proposal, context);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, String displayString, Image image, int priority, int replacementOffset, int replacementLength, ContentAssistContext context) {
        ConfigurableCompletionProposal result = new ConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, proposal.length(), image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        int replaceContextLength = context.getCurrentNode().getLength() - (replacementOffset - context.getCurrentNode().getOffset());
        result.setReplaceContextLength(replaceContextLength);
        return result;
    }

    protected String getDisplayString(IScopedElement candidate) {
        return candidate.name();
    }

    protected String getDisplayString(EObject element, String proposal) {
        return proposal;
    }

    public void setValueConverter(IValueConverterService valueConverter) {
        this.valueConverter = valueConverter;
    }

    public IValueConverterService getValueConverter() {
        return this.valueConverter;
    }

    protected Image getImage(EObject eObject) {
        return this.labelProvider.getImage((Object)eObject);
    }

    public void setConflictHelper(IProposalConflictHelper conflictHelper) {
        this.conflictHelper = conflictHelper;
    }

    public IProposalConflictHelper getConflictHelper() {
        return this.conflictHelper;
    }

    public void setCrossReferencePriority(int crossReferencePriority) {
        this.crossReferencePriority = crossReferencePriority;
    }

    public int getCrossReferencePriority() {
        return this.crossReferencePriority;
    }

    public void setKeywordPriority(int keywordPriority) {
        this.keywordPriority = keywordPriority;
    }

    public int getKeywordPriority() {
        return this.keywordPriority;
    }

    public void setDefaultPriority(int defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setProposalWithPrefixMultiplier(int proposalWithPrefixMultiplier) {
        this.proposalWithPrefixMultiplier = proposalWithPrefixMultiplier;
    }

    public int getProposalWithPrefixMultiplier() {
        return this.proposalWithPrefixMultiplier;
    }

    public void setSameTextMultiplier(double sameTextMultiplier) {
        this.sameTextMultiplier = sameTextMultiplier;
    }

    public double getSameTextMultiplier() {
        return this.sameTextMultiplier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultContentAssistProcessorSwitch
    extends XtextSwitch<Boolean> {
        private final ContentAssistContext context;
        private final ICompletionProposalAcceptor acceptor;

        public DefaultContentAssistProcessorSwitch(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            this.context = context;
            this.acceptor = acceptor;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }

        public Boolean caseKeyword(Keyword object) {
            AbstractContentProposalProvider.this.completeKeyword(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseRuleCall(RuleCall object) {
            AbstractContentProposalProvider.this.completeRuleCall(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseAssignment(Assignment object) {
            AbstractContentProposalProvider.this.completeAssignment(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilteringCompletionProposalAcceptor
    extends ICompletionProposalAcceptor.Delegate {
        private final Predicate<ICompletionProposal> filter;

        public FilteringCompletionProposalAcceptor(ICompletionProposalAcceptor delegate, Predicate<ICompletionProposal> filter) {
            this.filter = filter;
            this.setDelegate(delegate);
        }

        public void accept(ICompletionProposal proposal) {
            if (this.filter.apply((Object)proposal)) {
                super.accept(proposal);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModifyingCompletionProposalAcceptor
    extends ICompletionProposalAcceptor.Delegate {
        private final Function<ICompletionProposal, ICompletionProposal> modifier;

        public ModifyingCompletionProposalAcceptor(ICompletionProposalAcceptor delegate, Function<ICompletionProposal, ICompletionProposal> modifier) {
            this.modifier = modifier;
            this.setDelegate(delegate);
        }

        public void accept(ICompletionProposal proposal) {
            if (proposal != null) {
                super.accept((ICompletionProposal)this.modifier.apply((Object)proposal));
            }
        }
    }

    public static class NullSafeCompletionProposalAcceptor
    extends ICompletionProposalAcceptor.Delegate {
        public NullSafeCompletionProposalAcceptor(ICompletionProposalAcceptor delegate) {
            this.setDelegate(delegate);
        }

        public void accept(ICompletionProposal proposal) {
            if (proposal != null) {
                super.accept(proposal);
            }
        }
    }
}

