/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.ExperimentAndDAO;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

class ExperimentsAdapter
implements ISelectionChangedListener {
    private TreeViewer myChildTree;
    private Action myDeleteAction;
    private Action myRenameAction;

    public ExperimentsAdapter(TreeViewer childTree) {
        assert (childTree != null);
        this.myChildTree = childTree;
        this.createActions();
        this.myChildTree.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void addNavigationActions(IMenuManager manager) {
        if (this.getSelectedExperiments().size() < 1) {
            return;
        }
        if (this.getCurrentSelection().size() == 1) {
            manager.add((IAction)this.myRenameAction);
        }
        manager.add((IAction)this.myDeleteAction);
    }

    public void addNavigationActions(IToolBarManager toolbar) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNavigationButtons();
    }

    private void createActions() {
        this.myRenameAction = new RenameAction();
        this.myDeleteAction = new DeleteAction();
    }

    private void updateNavigationButtons() {
    }

    private IStructuredSelection getCurrentSelection() {
        if (!(this.myChildTree.getSelection() instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)this.myChildTree.getSelection();
    }

    private List<Experiment> getSelectedExperiments() {
        LinkedList<Experiment> experiments = new LinkedList<Experiment>();
        if (!(this.myChildTree.getSelection() instanceof IStructuredSelection)) {
            return experiments;
        }
        IStructuredSelection selection = (IStructuredSelection)this.myChildTree.getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof ExperimentAndDAO)) continue;
            experiments.add(((ExperimentAndDAO)selectedObject).getExperiment());
        }
        return experiments;
    }

    private List<ExperimentAndDAO> getSelectedExperimentAndDAOs() {
        LinkedList<ExperimentAndDAO> exAndDAOs = new LinkedList<ExperimentAndDAO>();
        if (!(this.myChildTree.getSelection() instanceof IStructuredSelection)) {
            return exAndDAOs;
        }
        IStructuredSelection selection = (IStructuredSelection)this.myChildTree.getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof ExperimentAndDAO)) continue;
            exAndDAOs.add((ExperimentAndDAO)selectedObject);
        }
        return exAndDAOs;
    }

    private class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setText("Delete");
            this.setToolTipText("Delete Experiment");
            this.setEnabled(true);
        }

        public void run() {
            List exAndDAOs = ExperimentsAdapter.this.getSelectedExperimentAndDAOs();
            for (ExperimentAndDAO toDel : exAndDAOs) {
                IExperimentDAO dao = toDel.getDatasource().createExperimentDAO();
                dao.removeExperiment(toDel.getExperiment(), true);
                ExperimentsAdapter.this.myChildTree.remove((Object)toDel);
            }
        }
    }

    private class RenameAction
    extends Action {
        public RenameAction() {
            this.setText("Rename");
            this.setToolTipText("Rename Experiment");
            this.setEnabled(true);
        }

        public void run() {
            if (ExperimentsAdapter.this.getCurrentSelection().size() != 1) {
                return;
            }
            List expAndDAOs = ExperimentsAdapter.this.getSelectedExperimentAndDAOs();
            if (expAndDAOs.isEmpty()) {
                return;
            }
            Experiment experiment = ((ExperimentAndDAO)expAndDAOs.get(0)).getExperiment();
            InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Rename experiment", "Enter the new experiment name!", experiment.getExperimentName(), (IInputValidator)new NameValidator());
            if (dlg.open() == 0) {
                experiment.setExperimentName(dlg.getValue());
                ExperimentsAdapter.this.myChildTree.refresh();
            }
        }

        private class NameValidator
        implements IInputValidator {
            private NameValidator() {
            }

            public String isValid(String newText) {
                if (newText == "") {
                    return "Please enter a name!";
                }
                return null;
            }
        }
    }
}

