/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters;

import de.uka.ipd.sdq.sensorframework.filter.IFilteredCollectionFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters.FiltersPropertySection;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters.FiltersTabLabelProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class FiltersTabCellModifier
implements ICellModifier {
    private FiltersPropertySection section;
    private List<String> columnNames;

    public FiltersTabCellModifier(FiltersPropertySection section) {
        this.section = section;
        this.columnNames = Arrays.asList(FiltersPropertySection.columnNames);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return new FiltersTabLabelProvider().getColumnText(element, this.columnNames.indexOf(property));
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnNames.indexOf(property);
        TableItem item = (TableItem)element;
        IFilteredCollectionFactory factory = (IFilteredCollectionFactory)item.getData();
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.setFilteringParameter(factory, ((String)value).trim());
            }
        }
    }

    private void setFilteringParameter(IFilteredCollectionFactory factory, String input) {
        try {
            Properties properties = factory.getProperties();
            String desc = properties.propertyNames().nextElement().toString();
            properties.put(desc, factory.convertToType(input));
            this.section.refresh();
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Parameter conversion Error ", (String)"The entered parameter is not of the type Number!");
        }
    }

    private Shell getShell() {
        return VisualisationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

