/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.general;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.analysisinstance.impl.AnalysisInstanceManager;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.main.MainFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import org.apache.log4j.Logger;

public class AnalysisManager {
    private static final Logger logger = Logger.getLogger(AnalysisManager.class);
    private IDialogManager dialogManager;
    private IPreparationManager preparationManager;
    private IAnalysisInstanceManager analysisInstanceManager;
    private IWizardManager wizardManager;
    private IMainEditor mainEditor;
    private MaintainabilityAnalysisModel analysisModel;

    public AnalysisManager(MaintainabilityAnalysisModel analysisModel, IArchitectureModelProvider provider, IDialogManager dialogManager, IWizardManager wizardManager, IMainEditor mainEditor) {
        this.analysisModel = analysisModel;
        this.dialogManager = dialogManager;
        this.wizardManager = wizardManager;
        this.mainEditor = mainEditor;
        this.preparationManager = new PreparationManager(this.analysisModel, provider, this.dialogManager, this.mainEditor);
        this.analysisInstanceManager = new AnalysisInstanceManager(this.analysisModel, this.dialogManager, this.wizardManager, this.mainEditor);
    }

    public IPreparationManager getPreparationManager() {
        return this.preparationManager;
    }

    public IAnalysisInstanceManager getAnalysisInstanceManager() {
        return this.analysisInstanceManager;
    }

    private void createNewAnalysisModel() {
        this.analysisModel = MainFactory.eINSTANCE.createMaintainabilityAnalysisModel();
    }

    public MaintainabilityAnalysisModel getAnalysisModel() {
        return this.analysisModel;
    }

    public void setAnalysisModel(MaintainabilityAnalysisModel analysisModel) {
        this.analysisModel = analysisModel;
    }
}

