/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.architecturemodel.impl;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.architecturemodel.impl.BackboneModelLoader;
import de.fzi.kamp.service.architecturemodel.impl.CompositeComponentCollectorSwitch;
import de.fzi.kamp.service.architecturemodel.impl.MapKeyForSAMMOperationImplementationProxy;
import de.fzi.kamp.service.architecturemodel.impl.SAMMProxyMap;
import de.fzi.kamp.service.architecturemodel.impl.TransportInterfaceInformationContainer;
import de.fzi.kamp.service.architecturemodel.impl.switches.SAMMProxyCreationSwitch;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractDatatype;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractOperationImplementation;
import de.fzi.maintainabilitymodel.architecturemodel.ArchitecturemodelFactory;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMDatatypeProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfacePortProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationImplementationProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationProxy;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.swt.widgets.Shell;

public class SAMMArchitectureModelProvider
implements IArchitectureModelProvider {
    private static final Logger logger = Logger.getLogger(SAMMArchitectureModelProvider.class);
    private Map<NamedEntity, AbstractModelElement> proxies;
    private MaintainabilityAnalysisModel analysisModel;
    private IMainEditor mainEditor;
    private Map<AbstractArchitectureModel, IQModel> architectureModelToIQModelMap;
    private Map<IQModel, AbstractArchitectureModel> iQModelToArchitectureModelMap;

    public SAMMArchitectureModelProvider(ResourceSet resourceSet, MaintainabilityAnalysisModel analysisModel, IMainEditor mainEditor) {
        this.analysisModel = analysisModel;
        this.mainEditor = mainEditor;
        this.loadArchitectureModels(resourceSet, mainEditor.getMainEditorShell());
        if (this.proxies == null) {
            this.proxies = new SAMMProxyMap();
        }
        this.buildProxyMapAfterLoading();
    }

    @Override
    public List<AbstractArchitectureModel> getArchitectureModels() {
        return this.analysisModel.getArchitecturemodels();
    }

    public AbstractModelElement getSAMMProxyElement(NamedEntity sammElement) {
        if (sammElement == null) {
            return null;
        }
        AbstractModelElement proxy = null;
        if (this.proxies.containsKey(sammElement)) {
            return this.proxies.get(sammElement);
        }
        proxy = (AbstractModelElement)new SAMMProxyCreationSwitch().doSwitch((EObject)sammElement);
        proxy.setName(sammElement.getName());
        if (this.analysisModel != null) {
            ((AbstractArchitectureModel)this.analysisModel.getArchitecturemodels().get(0)).getModelelements().add((Object)proxy);
        }
        this.proxies.put(sammElement, proxy);
        return proxy;
    }

    public SAMMOperationImplementationProxy getSAMMOperationImplementationProxy(AbstractInterfacePort abstractInterfacePort, Operation operation) {
        if (abstractInterfacePort == null) {
            return null;
        }
        InterfacePort interfacePort = null;
        MapKeyForSAMMOperationImplementationProxy operationImplementationProxyKey = null;
        SAMMOperationImplementationProxy opImplProxy = null;
        if (interfacePort instanceof SAMMInterfacePortProxy) {
            interfacePort = ((SAMMInterfacePortProxy)interfacePort).getInterfaceport();
            operationImplementationProxyKey = new MapKeyForSAMMOperationImplementationProxy();
            operationImplementationProxyKey.setPort(interfacePort);
            operationImplementationProxyKey.setOperation(operation);
            MapKeyForSAMMOperationImplementationProxy originalKey = this.operationImplementationKeyAlreadyExists(operationImplementationProxyKey);
            if (originalKey != null) {
                return (SAMMOperationImplementationProxy)this.proxies.get(originalKey);
            }
            opImplProxy = ArchitecturemodelFactory.eINSTANCE.createSAMMOperationImplementationProxy();
            opImplProxy.setInterfacePort(interfacePort);
            opImplProxy.setOperation(operation);
            this.proxies.put(operationImplementationProxyKey, (AbstractModelElement)opImplProxy);
        }
        return opImplProxy;
    }

    private MapKeyForSAMMOperationImplementationProxy operationImplementationKeyAlreadyExists(MapKeyForSAMMOperationImplementationProxy operationImplementationProxyKey) {
        for (NamedEntity key : this.proxies.keySet()) {
            if (!operationImplementationProxyKey.equals(key)) continue;
            return (MapKeyForSAMMOperationImplementationProxy)key;
        }
        return null;
    }

    private void buildProxyMapAfterLoading() {
        for (AbstractArchitectureModel architectureModel : this.analysisModel.getArchitecturemodels()) {
            TreeIterator iter = EcoreUtil.getAllContents((EObject)architectureModel, (boolean)true);
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (eObject == null || !(eObject instanceof AbstractModelElement)) continue;
                ComponentType sammModelElement = null;
                if (eObject instanceof SAMMComponentProxy) {
                    sammModelElement = ((SAMMComponentProxy)eObject).getComponenttype();
                } else if (eObject instanceof SAMMInterfacePortProxy) {
                    sammModelElement = ((SAMMInterfacePortProxy)eObject).getInterfaceport();
                } else if (eObject instanceof SAMMInterfaceProxy) {
                    sammModelElement = ((SAMMInterfaceProxy)eObject).getInterface();
                } else if (eObject instanceof SAMMOperationProxy) {
                    sammModelElement = ((SAMMOperationProxy)eObject).getOperation();
                } else if (eObject instanceof SAMMDatatypeProxy) {
                    sammModelElement = ((SAMMDatatypeProxy)eObject).getType();
                }
                if (sammModelElement == null) continue;
                this.proxies.put((NamedEntity)sammModelElement, (AbstractModelElement)eObject);
            }
        }
    }

    @Override
    public List<AbstractArchitectureModel> loadArchitectureModels(ResourceSet resourceSet, Shell shell) {
        EList alreadyExistingArchitectureModels = this.analysisModel.getArchitecturemodels();
        this.architectureModelToIQModelMap = new HashMap<AbstractArchitectureModel, IQModel>();
        this.iQModelToArchitectureModelMap = new HashMap<IQModel, AbstractArchitectureModel>();
        BackboneModelLoader backboneModelLoader = new BackboneModelLoader(this.mainEditor);
        List<IQModel> newModelList = backboneModelLoader.loadArchitectureModelsFromBackbone();
        for (IQModel model : newModelList) {
            String projectName = model.getCorrespondingResource().getProject().getName();
            String samPath = model.getCorrespondingResource().getProjectRelativePath().toString();
            URI samUri = URI.createPlatformResourceURI((String)(String.valueOf(projectName) + "/" + samPath), (boolean)true);
            ServiceArchitectureModel sammModel = SAMMArchitectureModelProvider.loadSAMMModelsFromURI(resourceSet, samUri);
            IQModel repositoryModel = BackboneModelLoader.retrieveRepositoryIQModelForIQModel(model);
            String repPath = repositoryModel.getCorrespondingResource().getProjectRelativePath().toString();
            URI repURI = URI.createPlatformResourceURI((String)(String.valueOf(projectName) + "/" + repPath), (boolean)true);
            Repository repository = SAMMArchitectureModelProvider.loadSAMMRepositoryFromURI(resourceSet, repURI);
            SAMMArchitectureModelProxy alreadyExistingProxy = this.proxyForArchitectureModelAlreadyExists(sammModel);
            if (sammModel != null && alreadyExistingProxy == null) {
                SAMMArchitectureModelProxy samProxy = ArchitecturemodelFactory.eINSTANCE.createSAMMArchitectureModelProxy();
                samProxy.setServicearchitecturemodel(sammModel);
                samProxy.setRepository(repository);
                samProxy.setName(BackboneModelLoader.calculateNameIdentifierForIQModel(model));
                if (this.analysisModel != null) {
                    this.analysisModel.getArchitecturemodels().add((Object)samProxy);
                }
                this.architectureModelToIQModelMap.put((AbstractArchitectureModel)samProxy, model);
                this.iQModelToArchitectureModelMap.put(model, (AbstractArchitectureModel)samProxy);
                continue;
            }
            this.architectureModelToIQModelMap.put((AbstractArchitectureModel)alreadyExistingProxy, model);
            this.iQModelToArchitectureModelMap.put(model, (AbstractArchitectureModel)alreadyExistingProxy);
        }
        return alreadyExistingArchitectureModels;
    }

    private SAMMArchitectureModelProxy proxyForArchitectureModelAlreadyExists(ServiceArchitectureModel sammModel) {
        for (AbstractArchitectureModel proxy : this.analysisModel.getArchitecturemodels()) {
            if (!(proxy instanceof SAMMArchitectureModelProxy) || !((SAMMArchitectureModelProxy)proxy).getServicearchitecturemodel().equals(sammModel)) continue;
            return (SAMMArchitectureModelProxy)proxy;
        }
        return null;
    }

    @Override
    public List<AbstractModelElement> getComponents(AbstractArchitectureModel architectureModel) {
        LinkedList<CompositeComponent> rawComponentList = new LinkedList<CompositeComponent>();
        LinkedList<AbstractModelElement> componentProxyList = new LinkedList<AbstractModelElement>();
        Repository repository = null;
        if (architectureModel instanceof SAMMArchitectureModelProxy) {
            repository = ((SAMMArchitectureModelProxy)architectureModel).getRepository();
        }
        CompositeComponentCollectorSwitch gettingComponentsSwitch = new CompositeComponentCollectorSwitch(rawComponentList);
        if (repository != null) {
            TreeIterator itr = repository.eAllContents();
            while (itr.hasNext()) {
                EObject next = (EObject)itr.next();
                gettingComponentsSwitch.doSwitch(next);
            }
            for (CompositeComponent compositeComponent : rawComponentList) {
                componentProxyList.add(this.getSAMMProxyElement((NamedEntity)compositeComponent));
                this.createSubcomponentInstances(compositeComponent, componentProxyList);
            }
        }
        return componentProxyList;
    }

    private void createSubcomponentInstances(CompositeComponent compositeComponent, List<AbstractModelElement> componentProxyList) {
        for (SubcomponentInstance subCompInstance : compositeComponent.getSubcomponents()) {
            if (subCompInstance.getRealizedBy() instanceof CompositeComponent) {
                this.createSubcomponentInstances((CompositeComponent)subCompInstance.getRealizedBy(), componentProxyList);
                continue;
            }
            componentProxyList.add(this.getSAMMProxyElement((NamedEntity)compositeComponent));
        }
    }

    @Override
    public List<TransportInterfaceInformationContainer> getInterfaces(AbstractArchitectureModel architectureModel) {
        LinkedList<TransportInterfaceInformationContainer> interfaceList = new LinkedList<TransportInterfaceInformationContainer>();
        Repository repository = null;
        if (architectureModel instanceof SAMMArchitectureModelProxy) {
            ((SAMMArchitectureModelProxy)architectureModel).getServicearchitecturemodel();
            repository = ((SAMMArchitectureModelProxy)architectureModel).getRepository();
        }
        if (repository != null) {
            TreeIterator itr = repository.eAllContents();
            while (itr.hasNext()) {
                EObject obj = (EObject)itr.next();
                if (!(obj instanceof PrimitiveComponent)) continue;
                ComponentType compType = (ComponentType)obj;
                this.createOrUpdateTransportContainerForInterfacePortList((List<InterfacePort>)compType.getProvided(), interfaceList, compType);
                this.createOrUpdateTransportContainerForInterfacePortList((List<InterfacePort>)compType.getRequired(), interfaceList, compType);
            }
        }
        return interfaceList;
    }

    private void createOrUpdateTransportContainerForInterfacePortList(List<InterfacePort> interfacePortList, List<TransportInterfaceInformationContainer> interfaceList, ComponentType compType) {
        if (compType instanceof CompositeComponent) {
            return;
        }
        for (InterfacePort port : interfacePortList) {
            TransportInterfaceInformationContainer containerForCurrentInterfacePort = SAMMArchitectureModelProvider.isAlreadyAdded(interfaceList, (AbstractInterface)this.getSAMMProxyElement((NamedEntity)port.getInterfaceType()));
            if (containerForCurrentInterfacePort == null) {
                containerForCurrentInterfacePort = new TransportInterfaceInformationContainer((AbstractInterface)this.getSAMMProxyElement((NamedEntity)port.getInterfaceType()), (AbstractComponent)this.getSAMMProxyElement((NamedEntity)compType));
                interfaceList.add(containerForCurrentInterfacePort);
            }
            containerForCurrentInterfacePort.getInterfacePorts().add((AbstractInterfacePort)this.getSAMMProxyElement((NamedEntity)port));
        }
    }

    @Override
    public List<AbstractDatatype> getDatatypes(AbstractArchitectureModel architectureModel) {
        List<TransportInterfaceInformationContainer> interfaceList = this.getInterfaces(architectureModel);
        LinkedList<AbstractDatatype> datatypes = new LinkedList<AbstractDatatype>();
        for (TransportInterfaceInformationContainer interfaceInformationContainer : interfaceList) {
            if (interfaceInformationContainer.getIface() == null) continue;
            this.getDataTypesFromInterface(interfaceInformationContainer.getIface(), datatypes);
        }
        return datatypes;
    }

    private void getDataTypesFromInterface(AbstractInterface iface, List<AbstractDatatype> datatypes) {
        EList operations = ((SAMMInterfaceProxy)iface).getInterface().getSignatures();
        for (Operation operation : operations) {
            if (operation.getInput() != null) {
                this.getDatatypesFromMessageType(operation.getInput(), datatypes);
            }
            if (operation.getOutput() == null) continue;
            this.getDatatypesFromMessageType(operation.getOutput(), datatypes);
        }
    }

    private void getDatatypesFromMessageType(MessageType messageType, List<AbstractDatatype> datatypes) {
        for (Parameter parameter : messageType.getParameters()) {
            AbstractDatatype proxy;
            if (parameter.getType() == null || datatypes.contains(proxy = (AbstractDatatype)this.getSAMMProxyElement((NamedEntity)parameter.getType()))) continue;
            datatypes.add(proxy);
        }
    }

    private static ServiceArchitectureModel loadSAMMModelsFromURI(ResourceSet resourceSet, URI resourceURI) {
        Resource resource = SAMMArchitectureModelProvider.loadResource(resourceSet, resourceURI);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof ServiceArchitectureModel) {
            EcoreUtil.resolveAll((EObject)((EObject)resource.getContents().get(0)));
            return (ServiceArchitectureModel)resource.getContents().get(0);
        }
        return null;
    }

    private static Repository loadSAMMRepositoryFromURI(ResourceSet resourceSet, URI resourceURI) {
        Resource resource = SAMMArchitectureModelProvider.loadResource(resourceSet, resourceURI);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Repository) {
            EcoreUtil.resolveAll((EObject)((EObject)resource.getContents().get(0)));
            return (Repository)resource.getContents().get(0);
        }
        return null;
    }

    private static Resource loadResource(ResourceSet resourceSet, URI resourceURI) {
        Resource resource = null;
        Map loadOptions = resourceSet.getLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        resource = resourceSet.getResource(resourceURI, true);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        return resource;
    }

    private static TransportInterfaceInformationContainer isAlreadyAdded(List<TransportInterfaceInformationContainer> interfaceList, AbstractInterface currentInterface) {
        for (TransportInterfaceInformationContainer iface : interfaceList) {
            if (!iface.getIface().getId().equals(currentInterface.getId())) continue;
            return iface;
        }
        return null;
    }

    @Override
    public List<AbstractInterfacePort> getProvidedInterfacePorts(AbstractComponent componenttype) {
        ArrayList<AbstractInterfacePort> result = new ArrayList<AbstractInterfacePort>();
        if (componenttype instanceof SAMMComponentProxy) {
            ComponentType component = ((SAMMComponentProxy)componenttype).getComponenttype();
            for (InterfacePort port : component.getProvided()) {
                result.add((AbstractInterfacePort)this.getSAMMProxyElement((NamedEntity)port));
            }
        }
        return result;
    }

    @Override
    public List<AbstractInterfacePort> getRequiredInterfacePorts(AbstractComponent componenttype) {
        ArrayList<AbstractInterfacePort> result = new ArrayList<AbstractInterfacePort>();
        if (componenttype instanceof SAMMComponentProxy) {
            ComponentType component = ((SAMMComponentProxy)componenttype).getComponenttype();
            for (InterfacePort port : component.getRequired()) {
                result.add((AbstractInterfacePort)this.getSAMMProxyElement((NamedEntity)port));
            }
        }
        return result;
    }

    @Override
    public List<AbstractOperationImplementation> getOperationImplementations(AbstractInterfacePort interfacePort) {
        InterfacePort sammInterfacePort;
        ArrayList<AbstractOperationImplementation> result = new ArrayList<AbstractOperationImplementation>();
        if (interfacePort instanceof SAMMInterfacePortProxy && (sammInterfacePort = ((SAMMInterfacePortProxy)interfacePort).getInterfaceport()) != null && sammInterfacePort.getInterfaceType() != null) {
            for (Operation operation : sammInterfacePort.getInterfaceType().getSignatures()) {
                result.add((AbstractOperationImplementation)this.getSAMMOperationImplementationProxy(interfacePort, operation));
            }
        }
        return result;
    }

    @Override
    public List<AbstractDatatype> getDataTypesOfInterface(AbstractInterface referencedInterface) {
        ArrayList<AbstractDatatype> result = new ArrayList<AbstractDatatype>();
        this.getDataTypesFromInterface(referencedInterface, result);
        return result;
    }

    @Override
    public List<AbstractArchitectureModel> getAllParentModels(AbstractArchitectureModel selectedModel) {
        LinkedList<AbstractArchitectureModel> parentArchitectureModelList = new LinkedList<AbstractArchitectureModel>();
        IQModel correspondingIQModel = this.architectureModelToIQModelMap.get(selectedModel);
        if (correspondingIQModel != null) {
            IQElement correspondingIQElement = correspondingIQModel.getAlternative().getParent();
            if (correspondingIQElement instanceof IQRepository) {
                this.createZeroModel();
            } else if (correspondingIQElement instanceof IQAlternative) {
                parentArchitectureModelList.add(this.iQModelToArchitectureModelMap.get((IQAlternative)correspondingIQElement));
                this.getAllParentModels(this.iQModelToArchitectureModelMap.get(correspondingIQElement.getParent()));
            }
        }
        return parentArchitectureModelList;
    }

    private AbstractArchitectureModel createZeroModel() {
        return null;
    }

    public AbstractModelElement getProxy(NamedEntity key) {
        if (this.proxies.containsKey(key)) {
            return this.proxies.get(key);
        }
        return null;
    }

    @Override
    public void assignComponentNestingToContainerStructure(CompositeComponentSelectionContainer compositeComponentSelectionContainer, CompositeTaskDerivationContainer workplanContainer) {
    }
}

