/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.architecturemodel.impl;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;

public class BackboneModelLoader {
    private static final Logger logger = Logger.getLogger(BackboneModelLoader.class);
    private IMainEditor mainEditor;

    public BackboneModelLoader(IMainEditor mainEditor) {
        this.mainEditor = mainEditor;
    }

    public List<IQModel> loadArchitectureModelsFromBackbone() {
        List<IQAlternative> alternatives = this.retrieveAlternatives();
        List<IQModel> samModels = this.retrieveSAMModels(alternatives);
        return samModels;
    }

    private List<IQAlternative> retrieveAlternatives() {
        ArrayList<IQAlternative> alternatives = new ArrayList<IQAlternative>();
        IQApplicationModel applicationModel = QImpressApplicationModelManager.getManager().getQAppModel();
        this.retrieveAlternativesFromApplicationModel(alternatives, applicationModel);
        return alternatives;
    }

    private void retrieveAlternativesFromApplicationModel(List<IQAlternative> alternatives, IQApplicationModel applicationModel) {
        IProject iproject = this.mainEditor.getParentprojectOfKampFile();
        IQProject parentProject = applicationModel.getQProject(iproject);
        if (parentProject != null) {
            this.retrieveAlternativesFromProject(alternatives, parentProject);
        }
    }

    private void retrieveAlternativesFromProject(List<IQAlternative> alternatives, IQProject project) {
        try {
            IQAlternative[] alternativesArray = project.getRepository().listAllAlternatives();
            this.addAlternativesToList(alternatives, alternativesArray);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private void addAlternativesToList(List<IQAlternative> alternatives, IQAlternative[] alternativesArray) {
        IQAlternative[] iQAlternativeArray = alternativesArray;
        int n = alternativesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQAlternative alternative = iQAlternativeArray[n2];
            alternatives.add(alternative);
            ++n2;
        }
    }

    private List<IQModel> retrieveSAMModels(List<IQAlternative> alternatives) {
        ArrayList<IQModel> samModels = new ArrayList<IQModel>();
        for (IQAlternative alternative : alternatives) {
            IQModel samModel = null;
            samModel = this.tryToGetSAMModelFromAlternative(alternative);
            if (samModel == null) continue;
            samModels.add(samModel);
        }
        return samModels;
    }

    public static IQModel retrieveRepositoryIQModelForIQModel(IQModel iqmodel) {
        try {
            return iqmodel.getAlternative().getModel("samm_repository");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IQModel tryToGetSAMModelFromAlternative(IQAlternative alternative) {
        IQModel samModel = null;
        try {
            samModel = alternative.getModel("samm_servicearchitecturemodel");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return samModel;
    }

    public static IQModel findIQModelForAlternativeName(String alternativeName, IMainEditor mainEditor) {
        BackboneModelLoader backboneModelLoader = new BackboneModelLoader(mainEditor);
        List<IQModel> newModelList = backboneModelLoader.loadArchitectureModelsFromBackbone();
        for (IQModel model : newModelList) {
            String modelName = BackboneModelLoader.calculateNameIdentifierForIQModel(model);
            if (!modelName.equals(alternativeName)) continue;
            return model;
        }
        return null;
    }

    public static String calculateNameIdentifierForIQModel(IQModel model) {
        return BackboneModelLoader.calculateNameIdentifierForIQAlternative(model.getAlternative());
    }

    public static String calculateNameIdentifierForIQAlternative(IQAlternative alternative) {
        String alternativeName = alternative.getInfo().getDescription();
        String projectName = alternative.getRepository().getQProject().getProject().getName();
        String modelName = String.valueOf(projectName) + "/" + alternativeName;
        return modelName;
    }

    public static ArchitecturalAlternative lookupArchitecturalAlternativeForIQModel(IQModel model, List<ArchitecturalAlternative> architectureAlternatives) {
        return BackboneModelLoader.lookupArchitecturalAlternativeForIQAlternative(model.getAlternative(), architectureAlternatives);
    }

    public static ArchitecturalAlternative lookupArchitecturalAlternativeForIQAlternative(IQAlternative iqAlternative, List<ArchitecturalAlternative> architectureAlternatives) {
        for (ArchitecturalAlternative architectureAlternative : architectureAlternatives) {
            if (!architectureAlternative.getName().equals(BackboneModelLoader.calculateNameIdentifierForIQAlternative(iqAlternative))) continue;
            return architectureAlternative;
        }
        return null;
    }
}

