/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.service.analysisinstance.impl;

import de.fzi.kamp.derivation.IArchitectureModelResolver;
import de.fzi.kamp.derivation.IContainerFactory;
import de.fzi.kamp.derivation.IWorkplanBuilderResolver;
import de.fzi.kamp.derivation.WorkplanDerivationJob;
import de.fzi.kamp.service.analysisinstance.AnalysisAlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.architecturemodel.impl.BackboneModelLoader;
import de.fzi.kamp.service.commands.AddAnalysisInstanceCommand;
import de.fzi.kamp.service.commands.RemoveAnalysisInstanceCommand;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.ContainerFactory;
import de.fzi.kamp.service.workplanmanagement.IWorkPlanManager;
import de.fzi.kamp.service.workplanmanagement.NewWorkplanBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkPlanManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MainFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.ide.backbone.core.model.IQModel;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.MultiPageEditorPart;

public class AnalysisInstanceManager
implements IAnalysisInstanceManager {
    private static final Logger logger = Logger.getLogger(AnalysisInstanceManager.class);
    private MaintainabilityAnalysisModel analysisModel;
    private IDialogManager dialogManager;
    private IWizardManager wizardManager;
    private IMainEditor mainEditor;
    private IWorkPlanManager workplanManager;

    public AnalysisInstanceManager(MaintainabilityAnalysisModel analysisModel, IDialogManager dialogManager, IWizardManager wizardManager, IMainEditor mainEditor) {
        this.analysisModel = analysisModel;
        this.dialogManager = dialogManager;
        this.wizardManager = wizardManager;
        this.mainEditor = mainEditor;
    }

    @Override
    public void addAnalysisInstance(AnalysisManager analysisManager) {
        if (analysisManager.getAnalysisModel().getChangerequests().isEmpty()) {
            this.wizardManager.showErrorMessage("Please first define at least one change scenario!", this.mainEditor.getMainEditorShell());
            return;
        }
        AnalysisAlternativeAndChangeRequestTuple result = ((AnalysisInstanceManager)analysisManager.getAnalysisInstanceManager()).getDialogManager().showSelectArchitectureAlternativeAndChangeRequestDialog(analysisManager.getAnalysisModel());
        if (result != null) {
            AddAnalysisInstanceCommand command = new AddAnalysisInstanceCommand(result, analysisManager);
            this.mainEditor.handleCommand((Command)command);
        }
    }

    public EffortAnalysisInstance createAnalysisInstance(ArchitecturalAlternative sourceArchitectureAlternative, ChangeRequest changeRequest, AnalysisManager analysisManager, ArchitecturalAlternative targetArchitectureAlternative) {
        EffortAnalysisInstance analysisInstance = MainFactory.eINSTANCE.createEffortAnalysisInstance();
        if (targetArchitectureAlternative != null) {
            analysisInstance.setTargetArchitecturalAlternative(targetArchitectureAlternative);
        } else {
            logger.error((Object)"Target Alternative was null!");
        }
        if (sourceArchitectureAlternative != null) {
            analysisInstance.setSourceArchitecturalAlternative(sourceArchitectureAlternative);
        }
        analysisInstance.setChangerequest(changeRequest);
        this.analysisModel.getAnalysisinstances().add((Object)analysisInstance);
        if (this.workplanManager == null) {
            this.workplanManager = new WorkPlanManager(this.dialogManager, analysisInstance);
        }
        this.createWorkplanRoot(analysisInstance);
        return analysisInstance;
    }

    @Override
    public List<EffortAnalysisInstance> getAnalysisInstances() {
        return this.analysisModel.getAnalysisinstances();
    }

    @Override
    public void removeAnalysisInstance(EffortAnalysisInstance analysisInstance, TableItem item) {
        RemoveAnalysisInstanceCommand command = new RemoveAnalysisInstanceCommand(this, analysisInstance, item);
        this.mainEditor.handleCommand((Command)command);
    }

    @Override
    public boolean isEnabledDeriveWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance) {
        return analysisInstance.getWorkplan() == null || analysisInstance.getWorkplan().getCompositetaskderivationcontainer().isEmpty() || ((CompositeTaskDerivationContainer)analysisInstance.getWorkplan().getCompositetaskderivationcontainer().get(0)).getTopLevelActivityContainer().isEmpty();
    }

    @Override
    public void deriveWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance, IMainEditor editor) {
        if (analysisInstance.getChangerequest().isAutomaticDerivation()) {
            logger.info((Object)"Run Workplan Derivation Job");
            this.createAndRunWorkplanDerivationJob(analysisInstance, editor);
        } else {
            logger.info((Object)"Run Workplan Derivation Wizard");
            this.runDerivationWizard(analysisInstance, editor);
        }
    }

    private void runDerivationWizard(EffortAnalysisInstance analysisInstance, IMainEditor editor) {
        this.wizardManager.showAddCompositeActivityWizard(analysisInstance, ((MultiPageEditorPart)editor).getSite().getShell(), editor, editor.getArchitectureModelProvider());
    }

    private void createAndRunWorkplanDerivationJob(EffortAnalysisInstance analysisInstance, IMainEditor editor) {
        if (analysisInstance.getSourceArchitecturalAlternative() == null) {
            MessageBox messageBox = new MessageBox(editor.getMainEditorShell(), 288);
            messageBox.setMessage("Source Architecture Alternative was null: Try to open KAMP Editor from Project Explorer and recreate AnalysisInstance!");
            messageBox.open();
            return;
        }
        IQModel sourceIQModel = BackboneModelLoader.findIQModelForAlternativeName(analysisInstance.getSourceArchitecturalAlternative().getName(), editor);
        IQModel targetIQModel = BackboneModelLoader.findIQModelForAlternativeName(analysisInstance.getTargetArchitecturalAlternative().getName(), editor);
        WorkplanDerivationJob job = new WorkplanDerivationJob(sourceIQModel.getAlternative(), targetIQModel.getAlternative(), analysisInstance, (IArchitectureModelResolver)editor.getArchitectureModelProvider(), (IContainerFactory)new ContainerFactory(), (IWorkplanBuilderResolver)new NewWorkplanBuilder(this.mainEditor));
        try {
            job.execute(null);
        }
        catch (JobFailedException e) {
            e.printStackTrace();
        }
        catch (UserCanceledException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEnabledEditWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance) {
        return analysisInstance.getWorkplan() != null;
    }

    @Override
    public void editWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance, IMainEditor editor) {
        if (analysisInstance.getWorkplan() != null) {
            editor.showWorkplanChanges(analysisInstance.getWorkplan(), false);
        }
    }

    @Override
    public boolean isEnabledCalculateWorkComplexityForAnalysisInstance(EffortAnalysisInstance analysisInstance) {
        return analysisInstance.getWorkplan() != null;
    }

    @Override
    public void calculateWorkComplexityForAnalysisInstance(EffortAnalysisInstance analysisInstance) {
    }

    @Override
    public boolean isEnabledStartEffortEstimationInterview(EffortAnalysisInstance analysisInstance) {
        return analysisInstance.getWorkplan() != null && !analysisInstance.getWorkplan().getTasks().isEmpty();
    }

    @Override
    public void startEffortEstimationInterview(EffortAnalysisInstance analysisInstance) {
    }

    @Override
    public boolean isEnabledEditEffortEstimates(EffortAnalysisInstance analysisInstance) {
        return analysisInstance.getWorkplan() != null && !analysisInstance.getWorkplan().getTasks().isEmpty();
    }

    @Override
    public void editEffortEstimates(EffortAnalysisInstance analysisInstance, IMainEditor editor) {
        if (analysisInstance.getWorkplan() != null) {
            editor.showWorkplanChanges(analysisInstance.getWorkplan(), true);
        }
    }

    @Override
    public boolean isEnabledShowResultSummary(EffortAnalysisInstance analysisInstance) {
        return analysisInstance.getWorkplan() != null && !analysisInstance.getWorkplan().getTasks().isEmpty();
    }

    @Override
    public void showResultSummary(EffortAnalysisInstance instance) {
    }

    public MaintainabilityAnalysisModel getAnalysisModel() {
        return this.analysisModel;
    }

    public IDialogManager getDialogManager() {
        return this.dialogManager;
    }

    public IWizardManager getWizardManager() {
        return this.wizardManager;
    }

    public IWorkPlanManager getWorkplanManager() {
        return this.workplanManager;
    }

    private void createWorkplanRoot(EffortAnalysisInstance analysisInstance) {
        Workplan workplan = analysisInstance.getWorkplan();
        if (workplan == null) {
            workplan = WorkplanFactory.eINSTANCE.createWorkplan();
            analysisInstance.setWorkplan(workplan);
        }
        CompositeTaskDerivationContainer compositeTaskContainer = SelectioncontainerFactoryImpl.eINSTANCE.createCompositeTaskDerivationContainer();
        CompositeTask workplanActivity = WorkplanFactory.eINSTANCE.createCompositeTask();
        compositeTaskContainer.setActivity((Activity)workplanActivity);
        workplanActivity.setSelectioncontainer((AbstractContainer)compositeTaskContainer);
        TaskRationale workplanRootTaskTationale = this.createTaskRationale();
        workplanActivity.setTaskrationale(workplanRootTaskTationale);
        workplan.getCompositetaskderivationcontainer().add((Object)compositeTaskContainer);
        workplan.getTasks().add((Object)workplanActivity);
    }

    private TaskRationale createTaskRationale() {
        TaskRationale rationale = WorkplanFactory.eINSTANCE.createTaskRationale();
        rationale.setDescription("");
        rationale.setKeyword("Complete Workplan");
        return rationale;
    }
}

