/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class DDCreator
extends MatchingTask {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    private String classpath;

    public void execute() throws BuildException {
        if (this.descriptorDirectory == null || !this.descriptorDirectory.isDirectory()) {
            throw new BuildException("descriptors directory " + this.descriptorDirectory + " is not valid");
        }
        if (this.generatedFilesDirectory == null || !this.generatedFilesDirectory.isDirectory()) {
            throw new BuildException("dest directory " + this.generatedFilesDirectory + " is not valid");
        }
        String args = this.descriptorDirectory + " " + this.generatedFilesDirectory;
        DirectoryScanner ds = super.getDirectoryScanner(this.descriptorDirectory);
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            args = args + " " + files[i];
        }
        String systemClassPath = System.getProperty("java.class.path");
        String execClassPath = FileUtils.translatePath((String)(systemClassPath + ":" + this.classpath));
        Java ddCreatorTask = new Java((Task)this);
        ddCreatorTask.setFork(true);
        ddCreatorTask.setClassname("org.apache.tools.ant.taskdefs.optional.ejb.DDCreatorHelper");
        Commandline.Argument arguments = ddCreatorTask.createArg();
        arguments.setLine(args);
        ddCreatorTask.setClasspath(new Path(this.getProject(), execClassPath));
        if (ddCreatorTask.executeJava() != 0) {
            throw new BuildException("Execution of ddcreator helper failed");
        }
    }

    public void setDescriptors(String dirName) {
        this.descriptorDirectory = new File(dirName);
    }

    public void setDest(String dirName) {
        this.generatedFilesDirectory = new File(dirName);
    }

    public void setClasspath(String s) {
        this.classpath = FileUtils.translatePath((String)s);
    }
}

