/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.filter;

import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractMeasurementsCollection
extends AbstractCollection<Measurement> {
    protected Collection<Measurement> originalMeasurements = null;
    private ArrayList<Measurement> filteredItems = null;

    public AbstractMeasurementsCollection() {
    }

    public AbstractMeasurementsCollection(Collection<Measurement> originalMeasurements) {
        this.originalMeasurements = originalMeasurements;
    }

    @Override
    public Iterator<Measurement> iterator() {
        if (this.filteredItems == null) {
            this.filteredItems = new ArrayList();
            this.applyFilter(this.filteredItems);
        }
        return new Iterator<Measurement>(){
            Iterator<Measurement> it;
            int currentOriginal;
            int alreadyReturned;
            {
                this.it = AbstractMeasurementsCollection.this.originalMeasurements.iterator();
                this.currentOriginal = 0;
                this.alreadyReturned = 0;
            }

            @Override
            public boolean hasNext() {
                return this.currentOriginal < AbstractMeasurementsCollection.this.originalMeasurements.size() && this.alreadyReturned < AbstractMeasurementsCollection.this.size();
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            @Override
            public Measurement next() {
                Measurement next;
                block3: {
                    block2: {
                        if (!true) break block2;
                        next = this.it.next();
                        if (!AbstractMeasurementsCollection.this.filteredItems.contains(next)) break block3;
                    }
                    do {
                        ++this.currentOriginal;
                        next = this.it.next();
                    } while (AbstractMeasurementsCollection.this.filteredItems.contains(next));
                }
                ++this.currentOriginal;
                ++this.alreadyReturned;
                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected abstract void applyFilter(Collection<Measurement> var1);

    @Override
    public int size() {
        if (this.filteredItems == null) {
            this.filteredItems = new ArrayList();
            this.applyFilter(this.filteredItems);
        }
        return this.originalMeasurements.size() - this.filteredItems.size();
    }

    public Collection<Measurement> getOriginalMeasurements() throws InstantiationException {
        if (this.originalMeasurements == null) {
            throw new InstantiationException("No original measurements saved!");
        }
        return this.originalMeasurements;
    }

    public void resetFilteredItems() {
        this.filteredItems = null;
    }
}

