/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.util;

import de.uka.ipd.sdq.probfunction.math.IContinuousSample;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.util.Line;
import flanagan.complex.Complex;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MathTools {
    public static final double EPSILON_ERROR = 1.0E-5;

    public static double gcd(List<Double> numbers) {
        if (numbers.size() < 1) {
            throw new IllegalArgumentException("number of digit must be greater than 0");
        }
        if (numbers.size() < 2) {
            return numbers.get(0);
        }
        double gcd = MathTools.gcd(numbers.get(0), numbers.get(1));
        int i = 2;
        while (i < numbers.size()) {
            gcd = MathTools.gcd(gcd, numbers.get(i));
            ++i;
        }
        return gcd;
    }

    /*
     * Unable to fully structure code
     */
    public static double gcd(double x, double y) {
        if (x == 0.0) {
            return y;
        }
        if (y == 0.0) {
            return x;
        }
        if (Math.abs(x % y) < 1.0E-5) {
            return y;
        }
        if (!(Math.abs(y % x) < 1.0E-5)) ** GOTO lbl13
        return x;
lbl-1000:
        // 1 sources

        {
            if (x > y) {
                x -= y;
                continue;
            }
            y -= x;
lbl13:
            // 3 sources

            ** while (Math.abs((double)(x - y)) > 1.0E-5)
        }
lbl14:
        // 1 sources

        return x;
    }

    public static List<Double> transformComplexToDouble(List<Complex> values) {
        ArrayList<Double> resultList = new ArrayList<Double>();
        for (Complex complex : values) {
            resultList.add(complex.getReal());
        }
        return resultList;
    }

    public static List<Complex> transformDoubleToComplex(List<Double> values) {
        ArrayList<Complex> resultList = new ArrayList<Complex>();
        for (Double d : values) {
            resultList.add(new Complex(d.doubleValue()));
        }
        return resultList;
    }

    public static boolean equalsDouble(double d1, double d2) {
        boolean result = false;
        result = d1 == Double.NaN && d2 == Double.NaN ? true : Math.abs(d1 - d2) < 1.0E-5;
        return result;
    }

    public static boolean equalsComplex(Complex z1, Complex z2) {
        boolean result = false;
        result = z1.isNaN() && z2.isNaN() ? true : MathTools.equalsDouble(z1.getReal(), z2.getReal()) && MathTools.equalsDouble(z1.getImag(), z2.getImag());
        return result;
    }

    public static double sumOfCountinuousSamples(List<IContinuousSample> list) {
        double sum = 0.0;
        for (IContinuousSample s : list) {
            sum += s.getProbability().doubleValue();
        }
        return sum;
    }

    public static double sumOfSamples(List<ISample> list) {
        double sum = 0.0;
        for (ISample s : list) {
            System.out.println(sum += s.getProbability());
        }
        return sum;
    }

    public static double sumOfDoubles(List<Double> list) {
        double sum = 0.0;
        for (Double d : list) {
            sum += d.doubleValue();
        }
        return sum;
    }

    public static List<Double> computeCumulativeProbabilities(List<Double> probabilityList) {
        ArrayList<Double> resultList = new ArrayList<Double>(probabilityList.size());
        if (probabilityList == null || probabilityList.size() == 0) {
            throw new IllegalArgumentException("ProbabilityList is empty or null!");
        }
        double prob = 0.0;
        for (Double d : probabilityList) {
            resultList.add(prob += d.doubleValue());
        }
        return resultList;
    }

    public static HashMap<Double, Line> computeLines(List<IContinuousSample> samples, List<Double> intervals) {
        HashMap<Double, Line> lines = new HashMap<Double, Line>();
        lines.put(intervals.get(0), new Line(0.0, 0.0, samples.get(0).getValue(), samples.get(0).getProbability()));
        int i = 1;
        while (i < intervals.size()) {
            double x1 = samples.get(i - 1).getValue();
            double y1 = intervals.get(i - 1);
            double x2 = samples.get(i).getValue();
            double y2 = intervals.get(i);
            if (y1 != y2) {
                lines.put(intervals.get(i), new Line(x1, y1, x2, y2));
            }
            ++i;
        }
        return lines;
    }

    public static Comparator<IContinuousSample> getContinuousSampleComparator() {
        Comparator<IContinuousSample> comp = new Comparator<IContinuousSample>(){

            @Override
            public int compare(IContinuousSample o1, IContinuousSample o2) {
                return Double.valueOf(o1.getValue()).compareTo(o2.getValue());
            }
        };
        return comp;
    }

    public static Comparator<ISample> getSampleComparator() {
        Comparator<ISample> sComparator = new Comparator<ISample>(){

            @Override
            public int compare(ISample o1, ISample o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        };
        return sComparator;
    }

    public static String asString(double val) {
        double rVal = (double)Math.round(val * 10000.0) / 10000.0;
        return Double.toString(rVal);
    }

    public static BigDecimal over(int n, int k) {
        return MathTools.factorial(n).divide(MathTools.factorial(k).multiply(MathTools.factorial(n - k)));
    }

    public static BigDecimal over(int n, int[] nList) {
        BigDecimal numerator = MathTools.factorial(n);
        BigDecimal denominator = BigDecimal.ONE;
        int[] nArray = nList;
        int n2 = nList.length;
        int n3 = 0;
        while (n3 < n2) {
            int ni = nArray[n3];
            denominator = denominator.multiply(MathTools.factorial(ni));
            ++n3;
        }
        return numerator.divide(denominator);
    }

    public static BigDecimal computeJointProbability(BigDecimal[] probList, int[] nList) {
        assert (nList.length == probList.length);
        BigDecimal result = BigDecimal.ONE;
        int i = 0;
        while (i < nList.length) {
            result = result.multiply(probList[i].pow(nList[i]));
            ++i;
        }
        return result;
    }

    public static BigDecimal factorial(long n) {
        if (n < 0L) {
            return null;
        }
        if (n == 0L) {
            return BigDecimal.ONE;
        }
        BigDecimal fac = BigDecimal.ONE;
        long i = 1L;
        while (i <= n) {
            fac = fac.multiply(new BigDecimal(i));
            ++i;
        }
        return fac;
    }

    public static boolean isNumeric(Object value) {
        return value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof Float;
    }

    public static List<Complex> transformSampleToComplex(List<ISample> samples) {
        ArrayList<Complex> resultList = new ArrayList<Complex>();
        for (ISample s : samples) {
            resultList.add(new Complex(s.getProbability(), MathTools.convertToDouble(s.getValue())));
        }
        return resultList;
    }

    public static double convertToDouble(Object value) {
        double r = 0.0;
        if (value instanceof Double) {
            r = (Double)value;
        } else if (value instanceof Integer) {
            r = ((Integer)value).doubleValue();
        } else if (value instanceof Boolean) {
            r = (Boolean)value != false ? 1.0 : 0.0;
        } else if (value instanceof Float) {
            r = ((Float)value).doubleValue();
        }
        return r;
    }

    public static double round(double value, double precision) {
        long factor = (long)(1.0 / precision);
        long temp = Math.round(value *= (double)factor);
        return (double)temp / (double)factor;
    }

    public static boolean lessOrEqual(double d1, double d2) {
        return d1 <= d2 + 1.0E-5;
    }

    public static boolean less(double d1, double d2) {
        return d1 < d2 && !MathTools.equalsDouble(d1, d2);
    }
}

