/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.impl;

import de.uka.ipd.sdq.probfunction.math.IBoxedPDF;
import de.uka.ipd.sdq.probfunction.math.IContinuousSample;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.DoubleSampleException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInFrequencyDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityDensityFunctionImpl;
import de.uka.ipd.sdq.probfunction.math.util.Line;
import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BoxedPDFImpl
extends ProbabilityDensityFunctionImpl
implements IBoxedPDF {
    private List<IContinuousSample> samples;
    private List<Double> partedIntervals = null;
    private HashMap<Double, Line> lines = null;

    protected BoxedPDFImpl(IUnit unit) {
        this(unit, new DefaultRandomGenerator());
    }

    protected BoxedPDFImpl(IUnit unit, IRandomGenerator generator) {
        super(unit, false);
        this.randomGenerator = generator;
        this.samples = new ArrayList<IContinuousSample>();
    }

    @Override
    public IProbabilityDensityFunction add(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        ISamplePDF sPDF = pfFactory.transformToSamplePDF(this);
        return sPDF.add(pdf);
    }

    @Override
    public IProbabilityDensityFunction mult(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        ISamplePDF sPDF = pfFactory.transformToSamplePDF(this);
        return sPDF.mult(pdf);
    }

    @Override
    public IProbabilityDensityFunction scale(double scalar) {
        ArrayList<IContinuousSample> list = new ArrayList<IContinuousSample>();
        for (IContinuousSample s : this.samples) {
            list.add(pfFactory.createContinuousSample(s.getValue(), s.getProbability() * scalar));
        }
        IBoxedPDF result = null;
        try {
            result = pfFactory.createBoxedPDF(list, this.getUnit());
        }
        catch (DoubleSampleException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public List<IContinuousSample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    public List<Double> getValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (IContinuousSample cs : this.samples) {
            values.add(cs.getValue());
        }
        return values;
    }

    public List<Double> getProbabilities() {
        ArrayList<Double> probs = new ArrayList<Double>();
        for (IContinuousSample cs : this.samples) {
            probs.add(cs.getProbability());
        }
        return probs;
    }

    public void setSamples(List<IContinuousSample> samples) throws DoubleSampleException {
        if (this.containsDuplicateSamples(samples)) {
            throw new DoubleSampleException("found duplicate sample values (not probabilities)");
        }
        Collections.sort(samples, MathTools.getContinuousSampleComparator());
        this.samples = samples;
        this.initDrawSampleDataStructures();
    }

    @Override
    public IProbabilityDensityFunction div(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        ISamplePDF sPDF = pfFactory.transformToSamplePDF(this);
        return sPDF.div(pdf);
    }

    private void initDrawSampleDataStructures() {
        this.initPartedIntervals();
        this.initPartedLines();
    }

    private void initPartedIntervals() {
        this.partedIntervals = MathTools.computeCumulativeProbabilities(this.getProbabilities());
    }

    private void initPartedLines() {
        this.lines = MathTools.computeLines(this.samples, this.partedIntervals);
    }

    @Override
    public double drawSample() {
        double random = this.randomGenerator.random();
        for (Double currentInterval : this.partedIntervals) {
            if (!(random < currentInterval)) continue;
            return this.lines.get(currentInterval).getX(random);
        }
        throw new RuntimeException("No interval found for probability. This should never happen!");
    }

    @Override
    public IProbabilityDensityFunction getFourierTransform() throws FunctionNotInTimeDomainException {
        if (!this.isInTimeDomain()) {
            throw new FunctionNotInTimeDomainException();
        }
        ISamplePDF sPDF = null;
        try {
            sPDF = pfFactory.transformToSamplePDF(this);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return sPDF.getFourierTransform();
    }

    @Override
    public IProbabilityDensityFunction getInverseFourierTransform() throws FunctionNotInFrequencyDomainException {
        if (this.isInTimeDomain()) {
            throw new FunctionNotInFrequencyDomainException();
        }
        ISamplePDF sPDF = null;
        try {
            sPDF = pfFactory.transformToSamplePDF(this);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return sPDF.getInverseFourierTransform();
    }

    @Override
    public double getLowerDomainBorder() {
        return 0.0;
    }

    @Override
    public IProbabilityDensityFunction sub(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        ISamplePDF sPDF = pfFactory.transformToSamplePDF(this);
        return sPDF.sub(pdf);
    }

    @Override
    public double getArithmeticMeanValue() throws DomainNotNumbersException {
        List<IContinuousSample> list = this.getSamples();
        double mean = 0.0;
        double previousValue = 0.0;
        for (IContinuousSample continuousSample : list) {
            double number = (continuousSample.getValue() + previousValue) / 2.0;
            mean += number * continuousSample.getProbability();
            previousValue = continuousSample.getValue();
        }
        return mean;
    }

    @Override
    public Object getMedian() throws UnorderedDomainException {
        if (!this.hasOrderedDomain()) {
            throw new UnorderedDomainException();
        }
        if (this.samples.size() % 2 != 0) {
            int i = (int)Math.floor((double)this.samples.size() / 2.0);
            return this.samples.get(i).getValue();
        }
        int i1 = (int)Math.round((double)this.samples.size() / 2.0);
        return (this.samples.get(i1).getValue() + this.samples.get(i1 - 1).getValue()) / 2.0;
    }

    @Override
    public Object getPercentile(int p) throws IndexOutOfBoundsException, UnorderedDomainException {
        if (p < 0 || p > 100) {
            throw new IndexOutOfBoundsException();
        }
        int rank = (int)Math.round((double)p * ((double)this.samples.size() - 1.0) / 100.0);
        return this.samples.get(rank).getProbability();
    }

    @Override
    public boolean isInFrequencyDomain() {
        return false;
    }

    @Override
    public boolean isInTimeDomain() {
        return true;
    }

    @Override
    public double getProbabilitySum() {
        double sum = 0.0;
        for (IContinuousSample sample : this.samples) {
            sum += sample.getProbability().doubleValue();
        }
        return sum;
    }

    private boolean containsDuplicateSamples(List<IContinuousSample> samples) {
        HashSet<Double> set = new HashSet<Double>();
        for (IContinuousSample s : samples) {
            set.add(s.getValue());
        }
        return set.size() != samples.size();
    }

    @Override
    public void checkConstrains() throws InvalidSampleValueException, UnitNameNotSetException, UnitNotSetException, ProbabilitySumNotOneException {
        if (!MathTools.equalsDouble(this.getProbabilitySum(), 1.0)) {
            throw new ProbabilitySumNotOneException();
        }
        double value = 0.0;
        for (IContinuousSample s : this.samples) {
            if (s == null || s.getValue() < 0.0 || s.getProbability() < 0.0 || s.getProbability() > 1.0) {
                throw new InvalidSampleValueException();
            }
            if (s.getValue() < value) {
                throw new InvalidSampleValueException();
            }
            value = s.getValue();
        }
    }

    @Override
    public IProbabilityDensityFunction getCumulativeFunction() {
        List<Double> cumulativeProbabilities = MathTools.computeCumulativeProbabilities(this.getProbabilities());
        ArrayList<IContinuousSample> cdfSamples = new ArrayList<IContinuousSample>();
        int i = 0;
        while (i < cumulativeProbabilities.size()) {
            double value = this.samples.get(i).getValue();
            double cumulativeProb = cumulativeProbabilities.get(i);
            IContinuousSample sample = pfFactory.createContinuousSample(value, cumulativeProb);
            cdfSamples.add(sample);
            ++i;
        }
        IBoxedPDF bpdf = null;
        try {
            bpdf = pfFactory.createBoxedPDF(cdfSamples, this.getUnit());
        }
        catch (DoubleSampleException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return bpdf;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IBoxedPDF) {
            IBoxedPDF pdf = (IBoxedPDF)obj;
            if (pdf.getSamples().size() != this.samples.size()) {
                return false;
            }
            Iterator<IContinuousSample> iter = pdf.getSamples().iterator();
            for (IContinuousSample s : this.samples) {
                if (s.equals(iter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public double probabilisticEquals(IProbabilityDensityFunction pdf) {
        return 0.0;
    }

    @Override
    public double greaterThan(IProbabilityDensityFunction pdf) {
        return 0.0;
    }

    @Override
    public double lessThan(IProbabilityDensityFunction pdf) {
        return 0.0;
    }

    @Override
    public IProbabilityDensityFunction stretchDomain(double scalar) {
        ArrayList<IContinuousSample> newSamples = new ArrayList<IContinuousSample>();
        if (scalar != 0.0) {
            for (IContinuousSample oldSample : this.samples) {
                newSamples.add(pfFactory.createContinuousSample(oldSample.getValue() * scalar, oldSample.getProbability()));
            }
        } else {
            throw new RuntimeException("Error: Stretching the domain of PDF " + this.toString() + " with factor 0 is undefined. Please change your models so that no PDf is multiplied by 0.");
        }
        IBoxedPDF result = null;
        try {
            result = pfFactory.createBoxedPDF(newSamples, this.getUnit());
        }
        catch (DoubleSampleException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public IProbabilityDensityFunction shiftDomain(double scalar) throws DomainNotNumbersException {
        if (scalar == 0.0) {
            return this;
        }
        ArrayList<IContinuousSample> newSamples = new ArrayList<IContinuousSample>();
        if (this.samples.get(0).getProbability() != 0.0) {
            newSamples.add(pfFactory.createContinuousSample(scalar, 0.0));
        }
        for (IContinuousSample oldSample : this.samples) {
            newSamples.add(pfFactory.createContinuousSample(oldSample.getValue() + scalar, oldSample.getProbability()));
        }
        IBoxedPDF result = null;
        try {
            result = pfFactory.createBoxedPDF(newSamples, this.getUnit());
        }
        catch (DoubleSampleException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "samples: ";
        boolean isFirst = true;
        for (IContinuousSample ics : this.samples) {
            if (isFirst) {
                isFirst = false;
            } else {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "(" + ics.getValue() + ", " + ics.getProbability() + ")";
        }
        return result;
    }
}

