/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.composite.diagram.custom.figures;

import eu.qimpress.ide.editors.gmf.composite.diagram.custom.figures.AbstractBorderFigure;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class SinkEventFigure
extends AbstractBorderFigure {
    private static final int DEFAULT_POSITION = 8;

    public SinkEventFigure(int logicalSize, AbstractBorderFigure.PositionType posType) {
        super(logicalSize, posType);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = graphics.getClip(new Rectangle());
        PointList arrowPoly = null;
        switch (side) {
            case 16: {
                graphics.drawLine(rect.getLeft().x, rect.getCenter().y, rect.getCenter().x, rect.getCenter().y);
                arrowPoly = new PointList(5);
                arrowPoly.addPoint(rect.getTop().x, rect.getCenter().y - rect.height / 4);
                arrowPoly.addPoint(rect.getRight().x, rect.getCenter().y - rect.height / 4);
                arrowPoly.addPoint(rect.getCenter().x + rect.width / 4, rect.getCenter().y);
                arrowPoly.addPoint(rect.getRight().x, rect.getCenter().y + rect.height / 4);
                arrowPoly.addPoint(rect.getBottom().x, rect.getCenter().y + rect.height / 4);
                graphics.drawPolygon(arrowPoly);
                break;
            }
            case 8: {
                graphics.drawLine(rect.getRight().x, rect.getCenter().y, rect.getCenter().x, rect.getCenter().y);
                arrowPoly = new PointList(5);
                arrowPoly.addPoint(rect.getTop().x, rect.getCenter().y - rect.height / 4);
                arrowPoly.addPoint(rect.getLeft().x, rect.getCenter().y - rect.height / 4);
                arrowPoly.addPoint(rect.getCenter().x - rect.width / 4, rect.getCenter().y);
                arrowPoly.addPoint(rect.getLeft().x, rect.getCenter().y + rect.height / 4);
                arrowPoly.addPoint(rect.getBottom().x, rect.getCenter().y + rect.height / 4);
                graphics.drawPolygon(arrowPoly);
                break;
            }
            case 1: {
                graphics.drawLine(rect.getCenter().x, rect.getBottom().y, rect.getCenter().x, rect.getCenter().y);
                arrowPoly = new PointList(5);
                arrowPoly.addPoint(rect.getCenter().x - rect.width / 4, rect.getCenter().y);
                arrowPoly.addPoint(rect.getCenter().x - rect.width / 4, rect.getTop().y);
                arrowPoly.addPoint(rect.getCenter().x, rect.getCenter().y - rect.height / 4);
                arrowPoly.addPoint(rect.getCenter().x + rect.width / 4, rect.getTop().y);
                arrowPoly.addPoint(rect.getCenter().x + rect.width / 4, rect.getCenter().y);
                graphics.drawPolygon(arrowPoly);
                break;
            }
            case 4: {
                graphics.drawLine(rect.getCenter().x, rect.getTop().y, rect.getCenter().x, rect.getCenter().y);
                arrowPoly = new PointList(5);
                arrowPoly.addPoint(rect.getCenter().x - rect.width / 4, rect.getCenter().y);
                arrowPoly.addPoint(rect.getCenter().x - rect.width / 4, rect.getBottom().y);
                arrowPoly.addPoint(rect.getCenter().x, rect.getCenter().y + rect.height / 4);
                arrowPoly.addPoint(rect.getCenter().x + rect.width / 4, rect.getBottom().y);
                arrowPoly.addPoint(rect.getCenter().x + rect.width / 4, rect.getCenter().y);
                graphics.drawPolygon(arrowPoly);
            }
        }
    }

    private Point getSocketCenter() {
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = this.getBounds();
        Point result = null;
        switch (side) {
            case 16: {
                result = rect.getRight();
                break;
            }
            case 8: {
                result = rect.getLeft();
                break;
            }
            case 1: {
                result = rect.getTop();
                break;
            }
            case 4: {
                result = rect.getBottom();
            }
        }
        return result;
    }

    @Override
    protected ConnectionAnchor createAnchorExternal() {
        return new AbstractBorderFigure.StemAnchor((IFigure)this);
    }

    @Override
    protected ConnectionAnchor createAnchorInternal() {
        return new SocketAnchor((IFigure)this);
    }

    private class SocketAnchor
    extends AbstractConnectionAnchor {
        public SocketAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = SinkEventFigure.this.getSocketCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

