/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.helpers;

import de.fzi.gast.accesses.impl.accessesPackageImpl;
import de.fzi.gast.annotations.impl.annotationsPackageImpl;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.impl.corePackageImpl;
import de.fzi.gast.expressions.impl.expressionsPackageImpl;
import de.fzi.gast.functions.impl.functionsPackageImpl;
import de.fzi.gast.statements.impl.statementsPackageImpl;
import de.fzi.gast.types.impl.typesPackageImpl;
import de.fzi.gast.variables.impl.variablesPackageImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class GASTReader {
    private Map<Integer, EObject> GASTMap;
    private File file;
    private Resource resourceGAST;
    private ResourceSet resourceSet;
    private Root root;
    private Logger logger = Logger.getLogger((String)GASTReader.class.getName());

    public GASTReader() throws IOException {
        corePackageImpl.eINSTANCE.eClass();
        accessesPackageImpl.eINSTANCE.eClass();
        annotationsPackageImpl.eINSTANCE.eClass();
        functionsPackageImpl.eINSTANCE.eClass();
        statementsPackageImpl.eINSTANCE.eClass();
        typesPackageImpl.eINSTANCE.eClass();
        variablesPackageImpl.eINSTANCE.eClass();
        expressionsPackageImpl.eINSTANCE.eClass();
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("gast", new XMLResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("expressions", new XMLResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
    }

    public void loadFile(String filename) throws IOException {
        try {
            this.file = new File(filename);
        }
        catch (NullPointerException e) {
            this.logger.error((Object)("Error loading file: " + filename + " Exception: " + e));
            System.err.println("Error loading file: " + filename + " Exception: " + e);
            e.printStackTrace();
        }
        URI fileGAST = URI.createFileURI((String)this.file.getAbsolutePath());
        this.loadFile(fileGAST);
    }

    public void loadFile(URI fileURI) throws IOException {
        this.resourceGAST = new XMLResourceImpl(fileURI);
        Map loadOptions = ((XMLResourceImpl)this.resourceGAST).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        ((ResourceImpl)this.resourceGAST).setIntrinsicIDToEObjectMap(new HashMap());
        this.resourceGAST.load(loadOptions);
        this.retrieveRootFromResource(this.resourceGAST);
        this.setupGASTMap(this.root);
    }

    public GASTReader(Root gastRoot) throws IOException {
        this();
        this.root = gastRoot;
        this.setupGASTMap(this.root);
    }

    private void setupGASTMap(Root root) {
        this.GASTMap = new HashMap<Integer, EObject>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof ModelElement)) continue;
            this.GASTMap.put(((ModelElement)eObject).getSissyId(), eObject);
        }
    }

    private void retrieveRootFromResource(Resource res) {
        TreeIterator iter = EcoreUtil.getAllContents((Resource)this.resourceGAST, (boolean)true);
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof ModelElement) || !(eObject instanceof Root)) continue;
            this.root = (Root)eObject;
        }
    }

    public Map<Integer, EObject> getGASTMap() {
        return this.GASTMap;
    }

    public Resource getResourceGAST() {
        return this.resourceGAST;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void save() throws IOException {
        this.getResourceGAST().save(null);
    }

    public void saveAs(String filename) throws IOException {
        this.getResourceGAST().setURI(URI.createFileURI((String)filename));
        this.getResourceGAST().save(null);
    }

    public Root getRoot() {
        return this.root;
    }

    public ModelElement getModelElementWithSissyID(String uniqueID) {
        if (uniqueID != null) {
            return (ModelElement)this.getGASTMap().get(Integer.parseInt(uniqueID));
        }
        return null;
    }

    public void setRoot(Root root) {
        this.root = root;
    }
}

