/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.engine.check.AbstractCheck;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.match.internal.statistic.ResourceSimilarity;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesCheck
extends AbstractCheck {
    public ReferencesCheck(EcoreUtil.CrossReferencer referencer) {
        super(referencer);
    }

    public void checkReferencesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (!this.shouldBeIgnored(next)) {
                this.checkReferenceUpdates(root, mapping, next);
                continue;
            }
            if (!next.isContainment() || !next.isOrdered()) continue;
            this.checkContainmentReferenceOrderChange(root, mapping, next);
        }
    }

    public void checkReferencesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (!this.shouldBeIgnored(next)) {
                this.checkReferenceUpdates(root, mapping, next);
                continue;
            }
            if (!next.isContainment() || !next.isOrdered()) continue;
            this.checkContainmentReferenceOrderChange(root, (Match2Elements)mapping, next);
        }
    }

    protected void checkContainmentReferenceOrderChange(DiffGroup root, Match2Elements mapping, EReference reference) throws FactoryException {
        ArrayList<EObject> leftElementReferences = new ArrayList<EObject>(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)reference.getName()));
        ArrayList<EObject> rightElementReferences = new ArrayList<EObject>(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)reference.getName()));
        ArrayList<Integer> removedIndices = new ArrayList<Integer>();
        for (EObject leftValue : new ArrayList(leftElementReferences)) {
            if (!this.isUnmatched(leftValue)) continue;
            leftElementReferences.remove(leftValue);
        }
        for (EObject rightValue : new ArrayList(rightElementReferences)) {
            if (!this.isUnmatched(rightValue)) continue;
            removedIndices.add(rightElementReferences.indexOf(rightValue));
        }
        int expectedIndex = 0;
        int i = 0;
        while (i < leftElementReferences.size()) {
            EObject matched = this.getMatchedEObject((EObject)leftElementReferences.get(i));
            for (Integer removedIndice : new ArrayList(removedIndices)) {
                if (i != removedIndice) continue;
                ++expectedIndex;
                removedIndices.remove(removedIndice);
            }
            if (rightElementReferences.indexOf(matched) != expectedIndex++) {
                ReferenceOrderChange refChange = DiffFactory.eINSTANCE.createReferenceOrderChange();
                refChange.setReference(reference);
                refChange.setLeftElement(mapping.getLeftElement());
                refChange.setRightElement(mapping.getRightElement());
                int j = removedIndices.size() - 1;
                while (j >= 0) {
                    rightElementReferences.remove((Integer)removedIndices.get(j));
                    --j;
                }
                ArrayList<EObject> leftTarget = new ArrayList<EObject>(this.getMatchedReferences(rightElementReferences));
                ArrayList<EObject> rightTarget = new ArrayList<EObject>(this.getMatchedReferences(leftElementReferences));
                refChange.getLeftTarget().addAll(leftTarget);
                refChange.getRightTarget().addAll(rightTarget);
                root.getSubDiffElements().add((Object)refChange);
                break;
            }
            ++i;
        }
    }

    protected void checkReferenceOrderChange(DiffGroup root, EReference reference, EObject leftElement, EObject rightElement, List<ReferenceChangeLeftTarget> addedReferences, List<ReferenceChangeRightTarget> removedReferences) throws FactoryException {
        ArrayList<EObject> leftElementReferences = new ArrayList<EObject>(EFactory.eGetAsList((EObject)leftElement, (String)reference.getName()));
        ArrayList<EObject> rightElementReferences = new ArrayList<EObject>(EFactory.eGetAsList((EObject)rightElement, (String)reference.getName()));
        ArrayList<Integer> removedIndices = new ArrayList<Integer>(removedReferences.size());
        for (ReferenceChangeLeftTarget added : addedReferences) {
            leftElementReferences.remove(added.getLeftTarget());
        }
        for (ReferenceChangeRightTarget removed : removedReferences) {
            removedIndices.add(rightElementReferences.indexOf(removed.getRightTarget()));
        }
        int expectedIndex = 0;
        int i = 0;
        while (i < leftElementReferences.size()) {
            EObject matched = this.getMatchedEObject((EObject)leftElementReferences.get(i));
            for (Integer removedIndice : new ArrayList(removedIndices)) {
                if (i != removedIndice) continue;
                ++expectedIndex;
                removedIndices.remove(removedIndice);
            }
            if (rightElementReferences.indexOf(matched) != expectedIndex++) {
                ReferenceOrderChange refChange = DiffFactory.eINSTANCE.createReferenceOrderChange();
                refChange.setReference(reference);
                refChange.setLeftElement(leftElement);
                refChange.setRightElement(rightElement);
                int j = removedIndices.size() - 1;
                while (j >= 0) {
                    rightElementReferences.remove((Integer)removedIndices.get(j));
                    --j;
                }
                ArrayList<EObject> leftTarget = new ArrayList<EObject>(this.getMatchedReferences(rightElementReferences));
                ArrayList<EObject> rightTarget = new ArrayList<EObject>(this.getMatchedReferences(leftElementReferences));
                refChange.getLeftTarget().addAll(leftTarget);
                refChange.getRightTarget().addAll(rightTarget);
                root.getSubDiffElements().add((Object)refChange);
                break;
            }
            ++i;
        }
    }

    protected void checkReferenceUpdates(DiffGroup root, Match2Elements mapping, EReference reference) throws FactoryException {
        this.createNonConflictingReferencesUpdate(root, reference, mapping.getLeftElement(), mapping.getRightElement());
    }

    protected void checkReferenceUpdates(DiffGroup root, Match3Elements mapping, EReference reference) throws FactoryException {
        List<Object> ancestorReferences;
        List<Object> rightReferences;
        String referenceName = reference.getName();
        List<Object> leftReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)referenceName));
        if (this.isConflictual(reference, leftReferences, rightReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)referenceName)), ancestorReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)referenceName)))) {
            this.createConflictingReferenceUpdate(root, reference, mapping);
            return;
        }
        ArrayList<EObject> remoteDeletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> remoteAddedReferences = new ArrayList<EObject>();
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        this.populateThreeWayReferencesChanges(mapping, reference, addedReferences, deletedReferences, remoteAddedReferences, remoteDeletedReferences);
        this.createRemoteReferencesUpdate(root, reference, mapping, remoteAddedReferences, remoteDeletedReferences);
        if (!reference.isMany()) {
            EObject addedValue = null;
            EObject deletedValue = null;
            if (addedReferences.size() > 0) {
                addedValue = (EObject)addedReferences.get(0);
            }
            if (deletedReferences.size() > 0) {
                deletedValue = (EObject)deletedReferences.get(0);
            }
            if ((addedValue == null || deletedValue == null) && addedValue != deletedValue) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(mapping.getLeftElement(), mapping.getRightElement(), reference, addedValue, deletedValue));
            } else if (addedValue != null && deletedValue != null && !EcoreUtil.getURI((EObject)addedValue).equals((Object)EcoreUtil.getURI((EObject)deletedValue))) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(mapping.getLeftElement(), mapping.getRightElement(), reference, addedValue, deletedValue));
            }
        } else {
            ArrayList<ReferenceChangeLeftTarget> addedReferencesDiffs = new ArrayList<ReferenceChangeLeftTarget>(addedReferences.size());
            ArrayList<ReferenceChangeRightTarget> removedReferencesDiffs = new ArrayList<ReferenceChangeRightTarget>(deletedReferences.size());
            if (addedReferences.size() > 0) {
                addedReferencesDiffs.addAll(this.createNewReferencesOperation(root, mapping.getLeftElement(), mapping.getRightElement(), reference, addedReferences));
            }
            if (deletedReferences.size() > 0) {
                removedReferencesDiffs.addAll(this.createRemovedReferencesOperation(root, mapping.getLeftElement(), mapping.getRightElement(), reference, deletedReferences));
            }
            if (reference.isOrdered()) {
                this.checkReferenceOrderChange(root, reference, mapping.getLeftElement(), mapping.getRightElement(), addedReferencesDiffs, removedReferencesDiffs);
            }
        }
    }

    protected boolean shouldBeIgnored(EReference reference) {
        boolean ignore = reference.isContainment();
        ignore = ignore || reference.isDerived();
        ignore = ignore || reference.isTransient();
        ignore = ignore || reference.isContainer();
        ignore = ignore || reference.eContainer() == EcorePackage.eINSTANCE.getEGenericType();
        return ignore;
    }

    private List<EObject> computeAddedReferences(List<EObject> leftReferences, List<EObject> rightReferences) {
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        if (leftReferences != null) {
            addedReferences.addAll(leftReferences);
        }
        if (rightReferences != null) {
            deletedReferences.addAll(rightReferences);
        }
        List<EObject> matchedOldReferences = this.getMatchedReferences(deletedReferences);
        addedReferences.removeAll(matchedOldReferences);
        for (EObject added : new ArrayList(addedReferences)) {
            for (EObject deleted : deletedReferences) {
                EObject matched = this.getMatchedEObject(added);
                if (matched != null) {
                    if (matched != deleted) continue;
                    addedReferences.remove(added);
                    continue;
                }
                double uriSimilarity = ResourceSimilarity.computeURISimilarity((URI)EcoreUtil.getURI((EObject)added), (URI)EcoreUtil.getURI((EObject)deleted));
                if (!(uriSimilarity > 0.8)) continue;
                addedReferences.remove(added);
            }
        }
        return addedReferences;
    }

    private List<EObject> computeDeletedReferences(List<EObject> leftReferences, List<EObject> rightReferences) {
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        if (leftReferences != null) {
            addedReferences.addAll(leftReferences);
        }
        if (rightReferences != null) {
            deletedReferences.addAll(rightReferences);
        }
        List<EObject> matchedNewReferences = this.getMatchedReferences(addedReferences);
        deletedReferences.removeAll(matchedNewReferences);
        for (EObject deleted : new ArrayList(deletedReferences)) {
            for (EObject added : addedReferences) {
                EObject matched = this.getMatchedEObject(deleted);
                if (matched != null) {
                    if (matched != added) continue;
                    deletedReferences.remove(deleted);
                    continue;
                }
                double uriSimilarity = ResourceSimilarity.computeURISimilarity((URI)EcoreUtil.getURI((EObject)added), (URI)EcoreUtil.getURI((EObject)deleted));
                if (!(uriSimilarity > 0.8)) continue;
                deletedReferences.remove(deleted);
            }
        }
        return deletedReferences;
    }

    private void createConflictingReferenceUpdate(DiffGroup root, EReference reference, Match3Elements mapping) throws FactoryException {
        DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
        this.createNonConflictingReferencesUpdate(dummyGroup, reference, mapping.getLeftElement(), mapping.getRightElement());
        if (dummyGroup.getSubDiffElements().size() > 0) {
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(mapping.getLeftElement());
            conflictingDiff.setRightParent(mapping.getRightElement());
            conflictingDiff.setOriginElement(mapping.getOriginElement());
            for (DiffElement subDiff : new ArrayList<DiffElement>((Collection<DiffElement>)dummyGroup.getSubDiffElements())) {
                conflictingDiff.getSubDiffElements().add((Object)subDiff);
            }
            root.getSubDiffElements().add((Object)conflictingDiff);
        }
    }

    private List<ReferenceChangeLeftTarget> createNewReferencesOperation(DiffGroup root, EObject left, EObject right, EReference reference, List<EObject> addedReferences) {
        ArrayList<ReferenceChangeLeftTarget> result = new ArrayList<ReferenceChangeLeftTarget>();
        for (EObject eobj : addedReferences) {
            ReferenceChangeLeftTarget addOperation = DiffFactory.eINSTANCE.createReferenceChangeLeftTarget();
            addOperation.setRightElement(right);
            addOperation.setLeftElement(left);
            addOperation.setReference(reference);
            addOperation.setLeftTarget(eobj);
            if (this.getMatchedEObject(eobj) != null) {
                addOperation.setRightTarget(this.getMatchedEObject(eobj));
            }
            root.getSubDiffElements().add((Object)addOperation);
            result.add(addOperation);
        }
        return result;
    }

    private void createNonConflictingReferencesUpdate(DiffGroup root, EReference reference, EObject leftElement, EObject rightElement) throws FactoryException {
        List<Object> leftElementObjReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)leftElement, (String)reference.getName()));
        List<Object> rightElementObjReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)rightElement, (String)reference.getName()));
        ArrayList<EObject> leftElementReferences = new ArrayList<EObject>();
        ArrayList<EObject> rightElementReferences = new ArrayList<EObject>();
        for (Object left : leftElementObjReferences) {
            leftElementReferences.add((EObject)left);
        }
        for (Object right : rightElementObjReferences) {
            rightElementReferences.add((EObject)right);
        }
        List<EObject> deletedReferences = this.computeDeletedReferences(leftElementReferences, rightElementReferences);
        List<EObject> addedReferences = this.computeAddedReferences(leftElementReferences, rightElementReferences);
        if (!reference.isMany()) {
            EObject addedValue = null;
            EObject deletedValue = null;
            if (addedReferences.size() > 0) {
                addedValue = addedReferences.get(0);
            }
            if (deletedReferences.size() > 0) {
                deletedValue = deletedReferences.get(0);
            }
            if ((addedValue == null || deletedValue == null) && addedValue != deletedValue) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(leftElement, rightElement, reference, addedValue, deletedValue));
            } else if (addedValue != null && deletedValue != null) {
                boolean createDiff = false;
                EObject matchAdded = this.getMatchedEObject(addedValue);
                if (matchAdded != null && matchAdded != deletedValue) {
                    createDiff = true;
                } else if (this.getMatchedEObject(deletedValue) != null) {
                    createDiff = true;
                } else {
                    double uriSimilarity = ResourceSimilarity.computeURISimilarity((URI)EcoreUtil.getURI((EObject)addedValue), (URI)EcoreUtil.getURI((EObject)deletedValue));
                    if (uriSimilarity < 0.8) {
                        createDiff = true;
                    }
                }
                if (createDiff) {
                    root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(leftElement, rightElement, reference, addedValue, deletedValue));
                }
            }
        } else {
            ArrayList<ReferenceChangeLeftTarget> addedReferencesDiffs = new ArrayList<ReferenceChangeLeftTarget>(addedReferences.size());
            ArrayList<ReferenceChangeRightTarget> removedReferencesDiffs = new ArrayList<ReferenceChangeRightTarget>(deletedReferences.size());
            if (addedReferences.size() > 0) {
                addedReferencesDiffs.addAll(this.createNewReferencesOperation(root, leftElement, rightElement, reference, addedReferences));
            }
            if (deletedReferences.size() > 0) {
                removedReferencesDiffs.addAll(this.createRemovedReferencesOperation(root, leftElement, rightElement, reference, deletedReferences));
            }
            if (reference.isOrdered()) {
                this.checkReferenceOrderChange(root, reference, leftElement, rightElement, addedReferencesDiffs, removedReferencesDiffs);
            }
        }
    }

    private void createRemoteReferencesUpdate(DiffGroup root, EReference reference, Match3Elements mapping, List<EObject> remotelyAdded, List<EObject> remotelyDeleted) {
        if (!reference.isMany() && remotelyAdded.size() > 0 && remotelyDeleted.size() > 0) {
            UpdateReference operation = DiffFactory.eINSTANCE.createUpdateReference();
            operation.setRemote(true);
            operation.setLeftElement(mapping.getLeftElement());
            operation.setRightElement(mapping.getRightElement());
            operation.setReference(reference);
            EObject rightTarget = this.getMatchedEObject(remotelyAdded.get(0));
            EObject leftTarget = this.getMatchedEObject(remotelyDeleted.get(0));
            if (leftTarget == null) {
                leftTarget = remotelyAdded.get(0);
            }
            if (rightTarget == null) {
                rightTarget = remotelyDeleted.get(0);
            }
            operation.setLeftTarget(leftTarget);
            operation.setRightTarget(rightTarget);
            root.getSubDiffElements().add((Object)operation);
        } else if (reference.isMany()) {
            for (EObject eobj : remotelyAdded) {
                ReferenceChangeRightTarget addOperation = DiffFactory.eINSTANCE.createReferenceChangeRightTarget();
                addOperation.setRemote(true);
                addOperation.setRightElement(mapping.getRightElement());
                addOperation.setLeftElement(mapping.getLeftElement());
                addOperation.setReference(reference);
                addOperation.setRightTarget(eobj);
                if (this.getMatchedEObject(eobj) != null) {
                    addOperation.setLeftTarget(this.getMatchedEObject(eobj));
                }
                root.getSubDiffElements().add((Object)addOperation);
            }
            for (EObject eobj : remotelyDeleted) {
                ReferenceChangeLeftTarget delOperation = DiffFactory.eINSTANCE.createReferenceChangeLeftTarget();
                delOperation.setRemote(true);
                delOperation.setRightElement(mapping.getRightElement());
                delOperation.setLeftElement(mapping.getLeftElement());
                delOperation.setReference(reference);
                delOperation.setLeftTarget(eobj);
                if (this.getMatchedEObject(eobj) != null) {
                    delOperation.setRightTarget(this.getMatchedEObject(eobj));
                }
                root.getSubDiffElements().add((Object)delOperation);
            }
        }
    }

    private List<ReferenceChangeRightTarget> createRemovedReferencesOperation(DiffGroup root, EObject left, EObject right, EReference reference, List<EObject> deletedReferences) {
        ArrayList<ReferenceChangeRightTarget> result = new ArrayList<ReferenceChangeRightTarget>();
        for (EObject eobj : deletedReferences) {
            ReferenceChangeRightTarget delOperation = DiffFactory.eINSTANCE.createReferenceChangeRightTarget();
            delOperation.setRightElement(right);
            delOperation.setLeftElement(left);
            delOperation.setReference(reference);
            delOperation.setRightTarget(eobj);
            if (this.getMatchedEObject(eobj) != null) {
                delOperation.setLeftTarget(this.getMatchedEObject(eobj));
            }
            root.getSubDiffElements().add((Object)delOperation);
            result.add(delOperation);
        }
        return result;
    }

    private UpdateReference createUpdatedReferenceOperation(EObject left, EObject right, EReference reference, EObject addedValue, EObject deletedValue) {
        UpdateReference operation = DiffFactory.eINSTANCE.createUpdateReference();
        operation.setLeftElement(left);
        operation.setRightElement(right);
        operation.setReference(reference);
        EObject rightTarget = this.getMatchedEObject(addedValue);
        EObject leftTarget = this.getMatchedEObject(deletedValue);
        if (leftTarget == null) {
            leftTarget = addedValue;
        }
        if (rightTarget == null) {
            rightTarget = deletedValue;
        }
        operation.setLeftTarget(leftTarget);
        operation.setRightTarget(rightTarget);
        return operation;
    }

    private List<EObject> getMatchedReferences(List<EObject> references) {
        ArrayList<EObject> matchedReferences = new ArrayList<EObject>();
        for (EObject currentReference : references) {
            EObject currentMapped;
            if (currentReference == null || (currentMapped = this.getMatchedEObject(currentReference)) == null) continue;
            matchedReferences.add(currentMapped);
        }
        return matchedReferences;
    }

    private boolean isConflictual(EReference reference, List<?> leftReferences, List<?> rightReferences, List<?> ancestorReferences) {
        boolean isConflictual = false;
        if (!reference.isMany()) {
            if (leftReferences.size() != ancestorReferences.size() && rightReferences.size() != ancestorReferences.size()) {
                if (leftReferences.size() > 0 && !leftReferences.get(0).equals(this.getMatchedEObject((EObject)rightReferences.get(0)))) {
                    isConflictual = true;
                }
            } else if (!(leftReferences.size() <= 0 || rightReferences.size() <= 0 || leftReferences.get(0).equals(this.getMatchedEObject((EObject)ancestorReferences.get(0), 1)) || rightReferences.get(0).equals(this.getMatchedEObject((EObject)ancestorReferences.get(0), 2)) || rightReferences.get(0).equals(this.getMatchedEObject((EObject)leftReferences.get(0))))) {
                isConflictual = true;
            }
        }
        return isConflictual;
    }

    private void populateThreeWayReferencesChanges(Match3Elements mapping, EReference reference, List<EObject> addedReferences, List<EObject> deletedReferences, List<EObject> remoteAddedReferences, List<EObject> remoteDeletedReferences) throws FactoryException {
        String referenceName = reference.getName();
        List<Object> leftReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)referenceName));
        List<Object> rightReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)referenceName));
        List<Object> ancestorReferences = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)referenceName));
        for (Object right : rightReferences) {
            if (!(right instanceof EObject) || ancestorReferences.contains(this.getMatchedEObject((EObject)right, 0)) || leftReferences.contains(this.getMatchedEObject((EObject)right))) continue;
            remoteAddedReferences.add((EObject)right);
        }
        for (Object left : leftReferences) {
            if (!(left instanceof EObject) || ancestorReferences.contains(this.getMatchedEObject((EObject)left, 0)) || rightReferences.contains(this.getMatchedEObject((EObject)left))) continue;
            addedReferences.add((EObject)left);
        }
        for (Object origin : ancestorReferences) {
            if (origin instanceof EObject && !leftReferences.contains(this.getMatchedEObject((EObject)origin, 1)) && rightReferences.contains(this.getMatchedEObject((EObject)origin, 2))) {
                deletedReferences.add((EObject)origin);
                continue;
            }
            if (!(origin instanceof EObject) || rightReferences.contains(this.getMatchedEObject((EObject)origin, 2)) || !leftReferences.contains(this.getMatchedEObject((EObject)origin, 1))) continue;
            remoteDeletedReferences.add((EObject)origin);
        }
    }
}

