/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.gast.expressions.ArrayValueSelection;
import de.fzi.gast.expressions.Assignment;
import de.fzi.gast.expressions.AssignmentOperations;
import de.fzi.gast.expressions.AssignmentOperatorExpression;
import de.fzi.gast.expressions.BoolLiteral;
import de.fzi.gast.expressions.BooleanExpression;
import de.fzi.gast.expressions.BooleanOperations;
import de.fzi.gast.expressions.BooleanOperatorExpression;
import de.fzi.gast.expressions.CastExpression;
import de.fzi.gast.expressions.CharLiteral;
import de.fzi.gast.expressions.CompareExpression;
import de.fzi.gast.expressions.CompareOperations;
import de.fzi.gast.expressions.Conditional;
import de.fzi.gast.expressions.DoubleLiteral;
import de.fzi.gast.expressions.ExpressionAnchor;
import de.fzi.gast.expressions.ExpressionAnchorKind;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.FunctionCallPlaceholder;
import de.fzi.gast.expressions.GASTExpressionProxy;
import de.fzi.gast.expressions.Lvalue;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.MemberExpression;
import de.fzi.gast.expressions.NotExpression;
import de.fzi.gast.expressions.ParenthesisExpression;
import de.fzi.gast.expressions.Product;
import de.fzi.gast.expressions.ProductExpression;
import de.fzi.gast.expressions.ProductOperations;
import de.fzi.gast.expressions.Reference;
import de.fzi.gast.expressions.StringLiteral;
import de.fzi.gast.expressions.Term;
import de.fzi.gast.expressions.TermExpression;
import de.fzi.gast.expressions.TermOperations;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.TypeReferencePlaceholder;
import de.fzi.gast.expressions.UnaryArithmeticExpression;
import de.fzi.gast.expressions.UnaryOperations;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.expressions.VariablePlaceholder;
import de.fzi.gast.expressions.expressionsFactory;
import de.fzi.gast.statements.GASTExpression;
import de.fzi.sissy.extractors.cpp.cdt3.MetamodConverter;
import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.CastTypeAccess;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.RunTimeTypeAccess;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAccess;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.utils.Debug;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCastExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeleteExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class SAMMExpressionConverter {
    private ModelElementRepository repository;
    private MetamodConverter metamodConverter;
    private expressionsFactory factory = expressionsFactory.eINSTANCE;

    public SAMMExpressionConverter(MetamodConverter metamodConverter, ModelElementRepository repository) {
        this.metamodConverter = metamodConverter;
        this.repository = repository;
    }

    public GASTExpression convertExpressionFromAnchor(IASTExpression exp, ModelElement anchorModelElement, ExpressionAnchorKind anchorKind, boolean isWrite) {
        GASTExpression expression = this.convertExpression(exp, isWrite);
        if (anchorModelElement != null) {
            ExpressionAnchor expAnchor = this.factory.createExpressionAnchor();
            expAnchor.setSissyModelElementID(String.valueOf(anchorModelElement.getUniqueId()));
            if (anchorKind != null) {
                expAnchor.setExpressionanchorkind(anchorKind);
            } else {
                expAnchor.setExpressionanchorkind(ExpressionAnchorKind.CONDITION);
            }
            expAnchor.setGastexpressionproxy((GASTExpressionProxy)expression);
            this.repository.addExpressionAnchor(expAnchor);
        }
        return expression;
    }

    private GASTExpression convertExpression(IASTExpression exp, boolean isWrite) {
        if (exp instanceof IASTBinaryExpression) {
            return this.convertBinaryExpression((IASTBinaryExpression)exp);
        }
        if (exp instanceof IASTCastExpression) {
            return this.convertCastExpression((CPPASTCastExpression)exp);
        }
        if (exp instanceof IASTUnaryExpression) {
            return this.convertUnaryExpression((IASTUnaryExpression)exp);
        }
        if (exp instanceof IASTIdExpression) {
            return this.convertIdExpression((IASTIdExpression)exp, isWrite);
        }
        if (exp instanceof IASTFunctionCallExpression) {
            return this.convertFunctionCallExpression((IASTFunctionCallExpression)exp);
        }
        if (exp instanceof ICPPASTNewExpression) {
            return this.convertNewExpression((ICPPASTNewExpression)exp);
        }
        if (exp instanceof CPPASTFieldReference) {
            return this.convertFieldReference((CPPASTFieldReference)exp, isWrite);
        }
        if (exp instanceof IASTLiteralExpression) {
            return this.convertLiteralExpression((IASTLiteralExpression)exp);
        }
        if (exp instanceof IASTArraySubscriptExpression) {
            return this.convertArrayExpression((IASTArraySubscriptExpression)exp);
        }
        if (exp instanceof CPPASTDeleteExpression) {
            return this.convertExpression(((CPPASTDeleteExpression)exp).getOperand(), false);
        }
        if (exp instanceof IASTConditionalExpression) {
            return this.convertConditional((IASTConditionalExpression)exp);
        }
        if (exp instanceof IASTTypeIdExpression) {
            return this.convertTypeId((IASTTypeIdExpression)exp);
        }
        return null;
    }

    private GASTExpression convertArrayExpression(IASTArraySubscriptExpression exp) {
        LinkedList<Term> indexList = new LinkedList<Term>();
        IASTArraySubscriptExpression iastArrayExp = exp;
        while (iastArrayExp instanceof IASTArraySubscriptExpression) {
            Term indexTerm = (Term)this.convertExpression(iastArrayExp.getSubscriptExpression(), false);
            indexList.addFirst(indexTerm);
            iastArrayExp = iastArrayExp.getArrayExpression();
        }
        ArrayValueSelection avs = this.factory.createArrayValueSelection();
        avs.getIndex().addAll(indexList);
        GASTExpression arrayExp = this.convertExpression((IASTExpression)iastArrayExp, false);
        if (arrayExp instanceof FunctionCall) {
            ((FunctionCall)arrayExp).setArrayvalueselection(avs);
        } else if (arrayExp instanceof Variable) {
            ((Variable)arrayExp).setArrayvalueselection(avs);
        }
        return arrayExp;
    }

    private GASTExpression convertTypeId(IASTTypeIdExpression exp) {
        Type type = this.metamodConverter.convertType(CPPVisitor.createType((IASTNode)exp.getTypeId()));
        RunTimeTypeAccess ta = new RunTimeTypeAccess(type);
        TypeReferencePlaceholder trp = this.factory.createTypeReferencePlaceholder();
        trp.setSissyModelElementID(String.valueOf(ta.getUniqueId()));
        int op = exp.getOperator();
        switch (op) {
            case 0: {
                UnaryArithmeticExpression uae = this.factory.createUnaryArithmeticExpression();
                uae.setOperation(UnaryOperations.SIZEOF);
                uae.setInner((Term)trp);
                return uae;
            }
        }
        return null;
    }

    private GASTExpression convertConditional(IASTConditionalExpression conditionalExp) {
        BooleanExpression conditionExp = (BooleanExpression)this.convertExpression(conditionalExp.getLogicalConditionExpression(), false);
        BooleanExpression positiveExp = (BooleanExpression)this.convertExpression(conditionalExp.getPositiveResultExpression(), false);
        BooleanExpression negativeExp = (BooleanExpression)this.convertExpression(conditionalExp.getNegativeResultExpression(), false);
        Conditional conditional = this.factory.createConditional();
        conditional.setCondition(conditionExp);
        conditional.setThen(positiveExp);
        conditional.setElse(negativeExp);
        return conditional;
    }

    private GASTExpression convertFieldReference(CPPASTFieldReference frExp, boolean isWrite) {
        MemberExpression ownerExp = (MemberExpression)this.convertExpression(frExp.getFieldOwner(), false);
        Access access = this.convertFieldReferenceToSissyAccess(frExp, isWrite);
        MemberAccessor ma = this.factory.createMemberAccessor();
        ma.setLeft(ownerExp);
        if (access instanceof VariableAccess) {
            VariablePlaceholder vp = this.factory.createVariablePlaceholder();
            vp.setSissyModelElementID(String.valueOf(access.getUniqueId()));
            ma.setRight((Reference)vp);
        }
        return ma;
    }

    private GASTExpression convertIdExpression(IASTIdExpression idExp, boolean isWrite) {
        ModelElementList list = this.metamodConverter.convertIdExpression(idExp, isWrite);
        Iterator it = list.iterator();
        VariableAccess va = null;
        TypeAccess ta = null;
        while (it.hasNext()) {
            Access access = (Access)it.next();
            if (access instanceof VariableAccess) {
                va = (VariableAccess)access;
                continue;
            }
            if (!(access instanceof TypeAccess)) continue;
            ta = (TypeAccess)access;
        }
        VariablePlaceholder vp = null;
        if (va != null) {
            vp = this.factory.createVariablePlaceholder();
            vp.setSissyModelElementID(String.valueOf(va.getUniqueId()));
            if (ta == null) {
                return vp;
            }
        }
        TypeReferencePlaceholder trp = null;
        if (ta != null) {
            trp = this.factory.createTypeReferencePlaceholder();
            trp.setSissyModelElementID(String.valueOf(ta.getUniqueId()));
        }
        MemberAccessor ma = this.factory.createMemberAccessor();
        ma.setLeft((MemberExpression)trp);
        ma.setRight((Reference)vp);
        return ma;
    }

    private GASTExpression convertLiteralExpression(IASTLiteralExpression litExp) {
        int expKind = litExp.getKind();
        CharLiteral curExp = null;
        switch (expKind) {
            case 2: {
                curExp = this.factory.createCharLiteral();
                curExp.setValue(litExp.toString().codePointAt(1));
                break;
            }
            case 1: {
                curExp = this.factory.createDoubleLiteral();
                ((DoubleLiteral)curExp).setValue(Double.parseDouble(litExp.toString()));
                break;
            }
            case 0: {
                curExp = this.factory.createStringLiteral();
                ((StringLiteral)curExp).setValue(litExp.toString());
                break;
            }
            case 3: {
                curExp = this.factory.createStringLiteral();
                ((StringLiteral)curExp).setValue(litExp.toString());
                break;
            }
            case 6: {
                curExp = this.factory.createBoolLiteral();
                ((BoolLiteral)curExp).setValue(false);
                break;
            }
            case 5: {
                curExp = this.factory.createBoolLiteral();
                ((BoolLiteral)curExp).setValue(true);
                break;
            }
            case 4: {
                if (!(this.metamodConverter.getCurrentFunction() instanceof Member)) break;
                SelfAccess va = new SelfAccess(((Member)this.metamodConverter.getCurrentFunction()).getSurroundingClass());
                VariablePlaceholder vp = this.factory.createVariablePlaceholder();
                vp.setSissyModelElementID(String.valueOf(va.getUniqueId()));
                curExp = vp;
            }
        }
        return curExp;
    }

    private GASTExpression convertNewExpression(ICPPASTNewExpression newExp) {
        IASTDeclSpecifier dspec;
        if (newExp.isNewTypeId() && (dspec = newExp.getTypeId().getDeclSpecifier()) instanceof IASTNamedTypeSpecifier) {
            IBinding bind = ((IASTNamedTypeSpecifier)dspec).getName().resolveBinding();
            if (bind instanceof CPPFunction) {
                FunctionAccess fa = this.convertFunctionBindingToSissyAccess((CPPFunction)bind);
                FunctionCallPlaceholder fp = this.factory.createFunctionCallPlaceholder();
                fp.setSissyModelElementID(String.valueOf(fa.getUniqueId()));
                this.convertParameters(newExp.getNewInitializer(), fp);
                return fp;
            }
            boolean cfr_ignored_0 = bind instanceof IProblemBinding;
        }
        return null;
    }

    private FunctionAccess convertFunctionBindingToSissyAccess(CPPFunction function) {
        FunctionAccess fa = null;
        ModelElementList list = this.metamodConverter.convertFunctionBinding(function, false);
        for (Object el : list) {
            if (!(el instanceof FunctionAccess)) continue;
            fa = (FunctionAccess)el;
            break;
        }
        return fa;
    }

    private Access convertFieldReferenceToSissyAccess(CPPASTFieldReference fieldExp, boolean isWrite) {
        IBinding bind = fieldExp.getFieldName().resolveBinding();
        if (bind instanceof CPPField) {
            CPPField field = (CPPField)bind;
            Field mmFld = (Field)this.metamodConverter.getFieldTable().get(this.metamodConverter.getFullName((ICPPBinding)field));
            VariableAccess va = new VariableAccess((de.fzi.sissy.metamod.Variable)mmFld, isWrite);
            return va;
        }
        if (bind instanceof CPPFunction) {
            return this.convertFunctionBindingToSissyAccess((CPPFunction)bind);
        }
        if (bind instanceof IProblemBinding) {
            System.out.println(((IProblemBinding)bind).getMessage());
        }
        return null;
    }

    private GASTExpression convertFunctionCallExpression(IASTFunctionCallExpression funcExp) {
        IASTExpression funcName = funcExp.getFunctionNameExpression();
        FunctionAccess fa = null;
        TypeAccess ta = null;
        if (funcName instanceof CPPASTFieldReference) {
            fa = (FunctionAccess)this.convertFieldReferenceToSissyAccess((CPPASTFieldReference)funcName, false);
        } else {
            ModelElementList list = this.metamodConverter.convertIdExpression((IASTIdExpression)funcName, false);
            for (Access access : list) {
                if (access instanceof FunctionAccess) {
                    fa = (FunctionAccess)access;
                    continue;
                }
                if (!(access instanceof TypeAccess)) continue;
                ta = (TypeAccess)access;
            }
        }
        FunctionCallPlaceholder curExp = null;
        if (fa != null) {
            curExp = this.factory.createFunctionCallPlaceholder();
            curExp.setSissyModelElementID(String.valueOf(fa.getUniqueId()));
            this.convertParameters(funcExp.getParameterExpression(), curExp);
            if (fa.getAccessedFunction() instanceof Member && funcName instanceof CPPASTFieldReference) {
                IASTExpression fieldOwner = ((CPPASTFieldReference)funcName).getFieldOwner();
                MemberExpression left = (MemberExpression)this.convertExpression(fieldOwner, false);
                MemberAccessor memberAccessor = this.factory.createMemberAccessor();
                memberAccessor.setLeft(left);
                memberAccessor.setRight((Reference)curExp);
                return memberAccessor;
            }
        }
        if (ta == null) {
            return curExp;
        }
        TypeReferencePlaceholder trp = this.factory.createTypeReferencePlaceholder();
        trp.setSissyModelElementID(String.valueOf(ta.getUniqueId()));
        MemberAccessor ma = this.factory.createMemberAccessor();
        ma.setLeft((MemberExpression)trp);
        ma.setRight((Reference)curExp);
        return ma;
    }

    private void convertParameters(IASTExpression parameters, FunctionCallPlaceholder functionCall) {
        if (parameters instanceof IASTExpressionList) {
            IASTExpression[] expList = ((IASTExpressionList)parameters).getExpressions();
            int i = 0;
            while (i < expList.length) {
                BooleanExpression booleanExpression = (BooleanExpression)this.convertExpression(expList[i], false);
                if (booleanExpression != null) {
                    functionCall.getParameterexpression().add((Object)booleanExpression);
                } else {
                    Debug.error((String)("SAMMEx.convertParameters: Expression was null! " + parameters.toString()));
                }
                ++i;
            }
        } else if (parameters != null) {
            BooleanExpression booleanExpression = (BooleanExpression)this.convertExpression(parameters, false);
            if (booleanExpression != null) {
                functionCall.getParameterexpression().add((Object)booleanExpression);
            } else {
                Debug.error((String)("SAMMEx.convertParameters: Expression was null! " + parameters.toString()));
            }
        }
    }

    private UnaryArithmeticExpression convertUnaryArithmeticExpression(IASTUnaryExpression unExp) {
        int op = unExp.getOperator();
        UnaryArithmeticExpression curExp = this.factory.createUnaryArithmeticExpression();
        boolean isWrite = true;
        switch (op) {
            case 0: {
                curExp.setOperation(UnaryOperations.PREINCREMENT);
                break;
            }
            case 1: {
                curExp.setOperation(UnaryOperations.PREDECREMENT);
                break;
            }
            case 9: {
                curExp.setOperation(UnaryOperations.POSTINCREMENT);
                break;
            }
            case 10: {
                curExp.setOperation(UnaryOperations.POSTDECREMENT);
                break;
            }
            case 3: {
                curExp.setOperation(UnaryOperations.UNARYMINUS);
                isWrite = false;
                break;
            }
            case 6: {
                curExp.setOperation(UnaryOperations.NEGATION);
                isWrite = false;
                break;
            }
            case 8: {
                curExp.setOperation(UnaryOperations.SIZEOF);
                isWrite = false;
                break;
            }
            case 4: {
                curExp.setOperation(UnaryOperations.DEREFERENCE);
                isWrite = false;
                break;
            }
            case 5: {
                curExp.setOperation(UnaryOperations.REFERENCE);
                isWrite = false;
            }
        }
        Term operand = (Term)this.convertExpression(unExp.getOperand(), isWrite);
        curExp.setInner(operand);
        return curExp;
    }

    private GASTExpression convertUnaryExpression(IASTUnaryExpression unExp) {
        int op = unExp.getOperator();
        switch (op) {
            case 7: {
                NotExpression curExp = this.factory.createNotExpression();
                curExp.setInner((BooleanExpression)this.convertExpression(unExp.getOperand(), false));
                return curExp;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return this.convertUnaryArithmeticExpression(unExp);
            }
            case 2: 
            case 12: {
                return this.convertExpression(unExp.getOperand(), false);
            }
            case 11: {
                ParenthesisExpression p = this.factory.createParenthesisExpression();
                p.setInner((Assignment)this.convertExpression(unExp.getOperand(), false));
                return p;
            }
        }
        return null;
    }

    private GASTExpression convertCastExpression(CPPASTCastExpression castExp) {
        CPPASTTypeId tid = (CPPASTTypeId)castExp.getTypeId();
        Type type = this.metamodConverter.convertType(CPPVisitor.createType((IASTNode)tid));
        CastTypeAccess ta = new CastTypeAccess(type);
        TypeReferencePlaceholder trp = this.factory.createTypeReferencePlaceholder();
        trp.setSissyModelElementID(String.valueOf(ta.getUniqueId()));
        CastExpression curExp = this.factory.createCastExpression();
        curExp.setExpression((BooleanExpression)this.convertExpression(castExp.getOperand(), false));
        curExp.setType((TypeReference)trp);
        return curExp;
    }

    private TypeAccess getSissyAccessForTypeId(IASTTypeId tid) {
        Type type = this.metamodConverter.convertType(CPPVisitor.createType((IASTNode)tid));
        CastTypeAccess ta = new CastTypeAccess(type);
        return ta;
    }

    private AssignmentOperatorExpression convertAssignmentExpression(IASTBinaryExpression binexp) {
        Lvalue op1 = (Lvalue)this.convertExpression(binexp.getOperand1(), true);
        Assignment op2 = (Assignment)this.convertExpression(binexp.getOperand2(), false);
        AssignmentOperatorExpression curExp = this.factory.createAssignmentOperatorExpression();
        curExp.setLeft(op1);
        curExp.setRight(op2);
        int op = binexp.getOperator();
        switch (op) {
            case 17: {
                curExp.setOperation(AssignmentOperations.ASSIGN);
                break;
            }
            case 19: {
                curExp.setOperation(AssignmentOperations.DIVASSIGN);
                break;
            }
            case 22: {
                curExp.setOperation(AssignmentOperations.SUBASSIGN);
                break;
            }
            case 18: {
                curExp.setOperation(AssignmentOperations.MULASSIGN);
                break;
            }
            case 21: {
                curExp.setOperation(AssignmentOperations.ADDASSIGN);
                break;
            }
            case 25: {
                curExp.setOperation(AssignmentOperations.BITANDASSIGN);
                break;
            }
            case 27: {
                curExp.setOperation(AssignmentOperations.BITORASSIGN);
                break;
            }
            case 26: {
                curExp.setOperation(AssignmentOperations.BITXORASSIGN);
                break;
            }
            case 20: {
                curExp.setOperation(AssignmentOperations.MODASSIGN);
                break;
            }
            case 23: {
                curExp.setOperation(AssignmentOperations.SHIFTLEFTASSIGN);
                break;
            }
            case 24: {
                curExp.setOperation(AssignmentOperations.SHIFTRIGHTASSIGN);
            }
        }
        return curExp;
    }

    private ProductExpression convertProductExpression(IASTBinaryExpression binexp) {
        Product op1 = (Product)this.convertExpression(binexp.getOperand1(), false);
        Product op2 = (Product)this.convertExpression(binexp.getOperand2(), false);
        ProductExpression curExp = this.factory.createProductExpression();
        curExp.setLeft(op1);
        curExp.setRight(op2);
        int op = binexp.getOperator();
        switch (op) {
            case 1: {
                curExp.setOperation(ProductOperations.MULT);
                break;
            }
            case 2: {
                curExp.setOperation(ProductOperations.DIV);
                break;
            }
            case 3: {
                curExp.setOperation(ProductOperations.MOD);
            }
        }
        return curExp;
    }

    private TermExpression convertTermExpression(IASTBinaryExpression binexp) {
        Term op1 = (Term)this.convertExpression(binexp.getOperand1(), false);
        Term op2 = (Term)this.convertExpression(binexp.getOperand2(), false);
        TermExpression curExp = this.factory.createTermExpression();
        curExp.setLeft(op1);
        curExp.setRight(op2);
        int op = binexp.getOperator();
        switch (op) {
            case 4: {
                curExp.setOperation(TermOperations.ADD);
                break;
            }
            case 5: {
                curExp.setOperation(TermOperations.SUB);
            }
        }
        return curExp;
    }

    private CompareExpression convertCompareExpression(IASTBinaryExpression binexp) {
        Term op1 = (Term)this.convertExpression(binexp.getOperand1(), false);
        Term op2 = (Term)this.convertExpression(binexp.getOperand2(), false);
        CompareExpression curExp = this.factory.createCompareExpression();
        curExp.setLeft(op1);
        curExp.setRight(op2);
        int op = binexp.getOperator();
        switch (op) {
            case 8: {
                curExp.setOperation(CompareOperations.LESS);
                break;
            }
            case 9: {
                curExp.setOperation(CompareOperations.GREATER);
                break;
            }
            case 10: {
                curExp.setOperation(CompareOperations.LESSEQUAL);
                break;
            }
            case 11: {
                curExp.setOperation(CompareOperations.GREATEREQUAL);
                break;
            }
            case 28: {
                curExp.setOperation(CompareOperations.EQUAL);
                break;
            }
            case 29: {
                curExp.setOperation(CompareOperations.NOTEQUAL);
            }
        }
        return curExp;
    }

    private BooleanOperatorExpression convertBooleanExpression(IASTBinaryExpression binexp) {
        BooleanExpression op2 = (BooleanExpression)this.convertExpression(binexp.getOperand2(), false);
        BooleanOperatorExpression curExp = this.factory.createBooleanOperatorExpression();
        curExp.setRight(op2);
        boolean isWrite = false;
        int op = binexp.getOperator();
        switch (op) {
            case 15: {
                curExp.setOperation(BooleanOperations.AND);
                break;
            }
            case 16: {
                curExp.setOperation(BooleanOperations.OR);
                break;
            }
            case 12: {
                curExp.setOperation(BooleanOperations.BITAND);
                break;
            }
            case 14: {
                curExp.setOperation(BooleanOperations.BITOR);
                break;
            }
            case 13: {
                curExp.setOperation(BooleanOperations.BITXOR);
                break;
            }
            case 6: {
                curExp.setOperation(BooleanOperations.SHIFTLEFT);
                isWrite = true;
                break;
            }
            case 7: {
                curExp.setOperation(BooleanOperations.SHIFTRIGHT);
                isWrite = true;
            }
        }
        BooleanExpression op1 = (BooleanExpression)this.convertExpression(binexp.getOperand1(), isWrite);
        curExp.setLeft(op1);
        return curExp;
    }

    private GASTExpression convertBinaryExpression(IASTBinaryExpression binexp) {
        int op = binexp.getOperator();
        switch (op) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return this.convertAssignmentExpression(binexp);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.convertProductExpression(binexp);
            }
            case 4: 
            case 5: {
                return this.convertTermExpression(binexp);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 28: 
            case 29: {
                return this.convertCompareExpression(binexp);
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return this.convertBooleanExpression(binexp);
            }
        }
        return null;
    }
}

