/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GlobalFunction;
import de.fzi.sissy.metamod.GlobalVariable;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.metamod.Subsystem;
import de.fzi.sissy.metamod.VariableAccess;
import java.util.Collection;
import java.util.Iterator;

public class MetamodPrinter {
    public static void printModel(Root root) {
        System.out.println("Printing Metamod model...");
        System.out.println("Files:");
        for (File file : root.getFiles()) {
            MetamodPrinter.println(file.getPathName(), 2);
        }
        System.out.println("Packages:");
        for (Package pkg : root.getPackages()) {
            MetamodPrinter.printPackage(pkg, 0);
        }
        System.out.println("Subsystems:");
        for (StructuralAbstraction sa : root.getStructuralAbstractions()) {
            if (!(sa instanceof Subsystem)) continue;
            MetamodPrinter.printSubsystem((Subsystem)sa, 0);
        }
    }

    static void printSubsystem(Subsystem subsys, int level) {
        MetamodPrinter.println("Subsys " + subsys.getSimpleName(), level);
        for (ModelElement element : subsys.getModelElements()) {
            MetamodPrinter.print(element, level + 2);
        }
    }

    static void print(ModelElement el, int level) {
        if (el instanceof Subsystem) {
            MetamodPrinter.println("Subsys " + ((Subsystem)el).getSimpleName(), level);
        } else if (el instanceof File) {
            MetamodPrinter.println("File " + ((File)el).getPathName(), level);
            for (File included : ((File)el).getIncludedFiles()) {
                MetamodPrinter.println("Includes " + included.getPathName(), level + 2);
            }
        }
    }

    static void printPackage(Package pkg, int level) {
        MetamodPrinter.println(pkg.getQualifiedName(), level);
        for (Class cls : pkg.getClasses()) {
            MetamodPrinter.printClass(cls, level + 2);
        }
        for (GlobalVariable globvar : pkg.getGlobalVariables()) {
            MetamodPrinter.println(globvar.getSimpleName(), level + 2);
        }
        for (GlobalFunction globfun : pkg.getGlobalFunctions()) {
            MetamodPrinter.printFunction((Function)globfun, level + 2);
        }
    }

    static void printPosition(Position pos, int level) {
        MetamodPrinter.println("([" + pos.getStartLine() + ", " + pos.getStartColumn() + "], [" + pos.getEndLine() + ", " + pos.getEndColumn() + "])", level + 2);
    }

    static void printClass(Class cls, int level) {
        MetamodPrinter.println(cls.getQualifiedName(), level);
        for (Field fld : cls.getFields()) {
            if (fld.isPublic()) {
                MetamodPrinter.print("public ", level + 2);
            } else if (fld.isPrivate()) {
                MetamodPrinter.print("private ", level + 2);
            } else if (fld.isStrictProtected()) {
                MetamodPrinter.print("protected ", level + 2);
            }
            System.out.println(fld.getSimpleName());
        }
        for (Method m : cls.getMethods()) {
            MetamodPrinter.printFunction((Function)m, level + 2);
        }
    }

    private static ModelElementList getAccesses(Statement stmt) {
        ModelElementList list = new ModelElementList();
        if (stmt instanceof BlockStatement) {
            for (Statement s : ((BlockStatement)stmt).getStatements()) {
                list.addAll((Collection)MetamodPrinter.getAccesses(s));
            }
        } else if (stmt != null) {
            list.addAll((Collection)stmt.getAccesses());
        }
        return list;
    }

    private static void printFunction(Function m, int level) {
        FormalParameter p;
        if (m instanceof Method) {
            if (((Method)m).isPublic()) {
                MetamodPrinter.print("public ", level + 2);
            } else if (((Method)m).isPrivate()) {
                MetamodPrinter.print("private ", level + 2);
            } else if (((Method)m).isStrictProtected()) {
                MetamodPrinter.print("protected ", level + 2);
            }
        }
        try {
            System.out.print(String.valueOf(m.getReturnType().getSimpleName()) + " " + m.getSimpleName());
        }
        catch (NullPointerException nullPointerException) {}
        System.out.print(" ( ");
        Iterator params = m.getFormalParameters().iterator();
        if (params.hasNext()) {
            p = (FormalParameter)params.next();
            System.out.print(String.valueOf(p.getType().getSimpleName()) + " " + p.getSimpleName());
        }
        while (params.hasNext()) {
            p = (FormalParameter)params.next();
            System.out.print(", " + p.getType().getSimpleName() + " " + p.getSimpleName());
        }
        System.out.println(" ) ");
        MetamodPrinter.println("Accesses:", level + 2);
        for (Access a : m.getAccesses()) {
            if (a instanceof VariableAccess) {
                Field field;
                boolean write = ((VariableAccess)a).isWriteAccess();
                MetamodPrinter.println("VarAcc (write=" + write + "): " + a.getAccessedTarget().getSimpleName(), level + 4);
                if (!(a.getAccessedTarget() instanceof Field) || (field = (Field)a.getAccessedTarget()).getSurroundingClass() == null) continue;
                MetamodPrinter.println("Owner: " + field.getSurroundingClass().getSimpleName(), level + 6);
                continue;
            }
            if (!(a instanceof FunctionAccess)) continue;
            MetamodPrinter.println("FunAcc: " + a.getAccessedTarget().getSimpleName(), level + 4);
        }
        MetamodPrinter.println("computed accesses:", level + 2);
        for (Access a : MetamodPrinter.getAccesses((Statement)m.getBody())) {
            MetamodPrinter.println(a.toString(), level + 4);
            if (a instanceof VariableAccess) {
                boolean write = ((VariableAccess)a).isWriteAccess();
                MetamodPrinter.println("VarAcc (write=" + write + "): " + a.getAccessedTarget().getSimpleName(), level + 4);
            } else if (a instanceof FunctionAccess) {
                MetamodPrinter.println("FunAcc: " + a.getAccessedTarget().getSimpleName(), level + 4);
            }
            MetamodPrinter.printPosition(a.getPosition(), level + 6);
        }
    }

    static void print(String s, int level) {
        int i = 0;
        while (i < level) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(s);
    }

    static void println(String s, int level) {
        int i = 0;
        while (i < level) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(s);
    }
}

