/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.gast.expressions.ExpressionAnchorKind;
import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.cpp.cdt3.SAMMExpressionConverter;
import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.BranchStatement;
import de.fzi.sissy.metamod.CastTypeAccess;
import de.fzi.sissy.metamod.CatchBlock;
import de.fzi.sissy.metamod.CatchParameter;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.CompositeAccess;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.DeclarationTypeAccess;
import de.fzi.sissy.metamod.Destructor;
import de.fzi.sissy.metamod.ExceptionHandler;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GlobalFunction;
import de.fzi.sissy.metamod.GlobalVariable;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.JumpStatement;
import de.fzi.sissy.metamod.LocalVariable;
import de.fzi.sissy.metamod.LoopStatement;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Reference;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.RunTimeTypeAccess;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.SimpleStatement;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StaticTypeAccess;
import de.fzi.sissy.metamod.ThrowTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAlias;
import de.fzi.sissy.metamod.TypeDecorator;
import de.fzi.sissy.metamod.Variable;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.utils.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCastExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDefaultStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeleteExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTProblemDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class MetamodConverter {
    private ModelElementRepository repository;
    private SAMMExpressionConverter sammExpressionConverter;
    Root root;
    de.fzi.sissy.metamod.File currentFile = null;
    IASTTranslationUnit translationUnit = null;
    boolean forInitStmtConversion = false;
    private Hashtable typeTable = new Hashtable();
    private Hashtable packageTable = new Hashtable();
    private Hashtable fieldTable = new Hashtable();
    private Hashtable functionTable = new Hashtable();
    private Hashtable globalVariablesTable = new Hashtable();
    private Hashtable globalVariablesMapping = new Hashtable();
    private Hashtable filesTable = new Hashtable();
    private Hashtable fieldInitializers = new Hashtable();
    private HashSet definedEntities = new HashSet();
    private HashSet declaredEntities = new HashSet();
    private Stack functionStack = new Stack();
    private Function currentFunction = null;
    private Set problemList = new LinkedHashSet();
    private List mmClasses = new ArrayList();
    private List cdtClasses = new ArrayList();
    private List mmFunctions = new ArrayList();
    private List cdtFunctions = new ArrayList();
    private String currentFilename = null;
    private boolean fakeDeps = false;
    private Package rootPackage;
    private boolean extractExpressions;
    private boolean createFakesForProblemBindings = false;
    private static final String REFERENCE_MARKER = "&";
    private static final String POINTER_MARKER = "*";

    protected void handleProblem(Object problem) {
        if (this.problemList.contains(problem)) {
            return;
        }
        this.problemList.add(problem);
    }

    public Set getProblems() {
        return this.problemList;
    }

    public MetamodConverter(ModelElementRepository repository, ExtractorConfiguration extractorConfiguration) {
        this.repository = repository;
        this.root = repository.getRoot();
        this.rootPackage = new Package("");
        this.root.addPackage(this.rootPackage);
        this.extractExpressions = extractorConfiguration.isDoExtractExpressions();
        if (this.extractExpressions) {
            Debug.println((String)"Expression-Extraction Activated!");
            this.sammExpressionConverter = new SAMMExpressionConverter(this, repository);
        }
        this.fakeDeps = extractorConfiguration.isCreateFakeDependencies();
        this.createFakesForProblemBindings = extractorConfiguration.isCreateFakesForProblemBindings();
    }

    private de.fzi.sissy.metamod.File mapFile(String filename) {
        if (this.filesTable.containsKey(filename)) {
            return (de.fzi.sissy.metamod.File)this.filesTable.get(filename);
        }
        de.fzi.sissy.metamod.File f = new de.fzi.sissy.metamod.File(filename);
        this.filesTable.put(filename, f);
        return f;
    }

    private void convertIncludes() {
        de.fzi.sissy.metamod.File thisFile = this.getOrCreateFile(this.translationUnit.getFilePath());
        IASTPreprocessorIncludeStatement[] list = this.translationUnit.getIncludeDirectives();
        int i = 0;
        while (i < list.length) {
            String s = list[i].getFileLocation().getFileName();
            if (s.toLowerCase().equalsIgnoreCase(thisFile.getPathName())) {
                thisFile.addIncludedFile(this.getOrCreateFile(list[i].getPath()));
            }
            ++i;
        }
    }

    public void convert(IASTTranslationUnit translationUnit) {
        try {
            this.problemList.clear();
            this.cdtClasses.clear();
            this.mmClasses.clear();
            this.cdtFunctions.clear();
            this.mmFunctions.clear();
            this.currentFilename = translationUnit.getFilePath();
            this.globalVariablesMapping.clear();
            Package currentPackage = this.root.getPackageByName("");
            this.translationUnit = translationUnit;
            IASTProblem[] problems = translationUnit.getPreprocessorProblems();
            int i = 0;
            while (i < problems.length) {
                this.handleProblem(problems[i]);
                ++i;
            }
            this.convertIncludes();
            i = 0;
            while (i < translationUnit.getDeclarations().length) {
                this.convertDeclaration(translationUnit.getDeclarations()[i], currentPackage);
                ++i;
            }
            i = 0;
            while (i < this.mmClasses.size()) {
                this.convertClass((ICPPClassType)this.cdtClasses.get(i), (Class)this.mmClasses.get(i));
                ++i;
            }
            i = 0;
            while (i < this.mmFunctions.size()) {
                this.convertFunctionBody((CPPFunction)this.cdtFunctions.get(i), (Function)this.mmFunctions.get(i));
                ++i;
            }
            Runtime rt = Runtime.getRuntime();
            Debug.println((String)("Used Memory: " + (rt.totalMemory() - rt.freeMemory()) / 0x100000L + "MB"));
        }
        catch (Throwable e) {
            Debug.warning((String)("Internal error. Parse for file " + this.currentFilename + " aborted. Stack trace follows."));
            e.printStackTrace();
        }
    }

    private boolean isInSourcePath(String fileName) {
        return this.repository.getFileList().contains(fileName) || this.repository.getLibFileList().contains(fileName);
    }

    protected ModelElement convertDeclaration(IASTDeclaration decl, Package pkg) {
        if (!this.isInSourcePath(decl.getContainingFilename())) {
            return null;
        }
        if (decl instanceof IASTFunctionDefinition) {
            return this.convertFunctionDefinition((IASTFunctionDefinition)decl, pkg);
        }
        if (decl instanceof IASTSimpleDeclaration) {
            IBinding binding;
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
            if (simpleDecl.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                IASTCompositeTypeSpecifier compositeTypeSpecifier = (IASTCompositeTypeSpecifier)simpleDecl.getDeclSpecifier();
                IBinding binding2 = compositeTypeSpecifier.getName().resolveBinding();
                if (binding2 instanceof ICPPClassType) {
                    ICPPClassType classType = (ICPPClassType)binding2;
                    Class cls = this.mapClass(classType);
                    this.convertClass(classType, cls);
                    pkg.addClass(cls);
                    return cls;
                }
            } else if (simpleDecl.getDeclSpecifier() instanceof CPPASTSimpleDeclSpecifier) {
                ICPPASTFunctionDeclarator funDec;
                if (simpleDecl.getDeclarators().length == 0) {
                    return null;
                }
                IBinding binding3 = simpleDecl.getDeclarators()[0].getName().resolveBinding();
                if (binding3 instanceof CPPVariable && !(binding3 instanceof CPPField)) {
                    this.convertGlobalVariable((CPPVariable)binding3, pkg);
                } else if (binding3 instanceof CPPTypedef) {
                    Type t;
                    CPPTypedef typedef = (CPPTypedef)binding3;
                    if (pkg.getTypeAliases().findByName(typedef.getName()) == null && (t = this.convertType(typedef.getType())) != null) {
                        TypeAlias ta = new TypeAlias(t, typedef.getName());
                        pkg.addTypeAlias(ta);
                    }
                } else if (simpleDecl.getDeclarators()[0] instanceof ICPPASTFunctionDeclarator && (binding3 = (funDec = (ICPPASTFunctionDeclarator)simpleDecl.getDeclarators()[0]).getName().resolveBinding()) instanceof ICPPFunction) {
                    this.convertGlobalFunction((ICPPFunction)binding3, pkg);
                }
            } else if (simpleDecl.getDeclSpecifier() instanceof CPPASTEnumerationSpecifier && (binding = ((CPPASTEnumerationSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding()) instanceof IEnumeration) {
                IEnumeration enu = (IEnumeration)binding;
                this.convertEnum(enu);
            }
        } else if (decl instanceof ICPPASTNamespaceDefinition) {
            ICPPASTNamespaceDefinition nsDef = (ICPPASTNamespaceDefinition)decl;
            IBinding binding = nsDef.getName().resolveBinding();
            try {
                Package pack = this.getOrCreatePackage(pkg.getQualifiedName(), binding.getName());
                pkg.addSubPackage(pack);
                int i = 0;
                while (i < nsDef.getDeclarations().length) {
                    this.convertDeclaration(nsDef.getDeclarations()[i], pack);
                    ++i;
                }
                return pack;
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
        if (decl instanceof CPPASTFunctionDefinition) {
            CPPASTFunctionDefinition fundef = (CPPASTFunctionDefinition)decl;
            fundef.getDeclarator().getName().resolveBinding();
            return null;
        }
        if (decl instanceof CPPASTSimpleDeclaration) {
            return null;
        }
        if (decl instanceof CPPASTProblemDeclaration) {
            return null;
        }
        if (decl instanceof CPPASTTemplateDeclaration) {
            return null;
        }
        return null;
    }

    private ModelElement convertFunctionDefinition(IASTFunctionDefinition funcDef, Package pkg) {
        IBinding binding = funcDef.getDeclarator().getName().resolveBinding();
        if (binding instanceof ProblemBinding) {
            StringBuffer name = new StringBuffer();
            name.append(funcDef.getDeclarator().getName().toString());
            name.append("::(");
            IASTParameterDeclaration[] params = ((CPPASTFunctionDeclarator)funcDef.getDeclarator()).getParameters();
            int j = 0;
            while (j < params.length) {
                String str = ASTTypeUtil.getType((IASTDeclarator)params[j].getDeclarator());
                if (str.length() == 0) {
                    name.append(((CPPASTNamedTypeSpecifier)params[j].getDeclSpecifier()).getName().toString());
                } else {
                    name.append(ASTTypeUtil.getType((IASTDeclarator)params[j].getDeclarator()));
                }
                if (j < params.length - 1) {
                    name.append(", ");
                }
                ++j;
            }
            name.append(")");
            Function func = (Function)this.functionTable.get(name.toString());
            if (func != null) {
                this.convertFunctionBody((IASTCompoundStatement)funcDef.getBody(), func);
            }
        }
        if (binding instanceof CPPMethod) {
            CPPMethod method = (CPPMethod)binding;
            String fullName = this.getFullSignature((ICPPFunction)method);
            IBinding methClassBinding = null;
            Class cls = null;
            try {
                IASTDeclaration decl = method.getPrimaryDeclaration();
                if (decl != null) {
                    methClassBinding = ((ICPPASTCompositeTypeSpecifier)decl.getParent()).getName().resolveBinding();
                }
            }
            catch (Exception e1) {
                Debug.warning((String)("Exception caught: " + e1.getClass().getCanonicalName()));
                e1.printStackTrace();
            }
            if (methClassBinding != null && methClassBinding instanceof ICPPClassType) {
                ICPPClassType methClass = (ICPPClassType)methClassBinding;
                cls = this.mapClass(methClass);
            }
            Function meth = null;
            if (cls != null) {
                meth = this.convertMethod(cls, (ICPPMethod)method);
            }
            if (meth == null) {
                try {
                    String out = fullName.replace("::(", "(");
                    Debug.warning((String)("Method not found: " + out));
                }
                catch (Exception e) {
                    Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
                    e.printStackTrace();
                }
            } else {
                this.setDefined(meth);
                this.mmFunctions.add(meth);
                this.cdtFunctions.add(method);
            }
            return meth;
        }
        if (binding instanceof ICPPFunction) {
            ICPPFunction fun = (ICPPFunction)funcDef.getDeclarator().getName().resolveBinding();
            if (!(fun instanceof CPPMethod) && !(fun instanceof CPPImplicitMethod)) {
                return this.convertGlobalFunction(fun, pkg);
            }
        } else if (binding instanceof ProblemBinding) {
            this.handleProblem(binding);
        }
        return null;
    }

    protected GlobalVariable convertGlobalVariable(CPPVariable cdtVar, Package pkg) {
        GlobalVariable metaVar;
        String fullName = this.getFullName((ICPPBinding)cdtVar);
        if (!this.globalVariablesTable.containsKey(fullName)) {
            metaVar = new GlobalVariable(cdtVar.getName());
            if (cdtVar.getType() instanceof CPPQualifierType) {
                CPPQualifierType qtype = (CPPQualifierType)cdtVar.getType();
                metaVar.setConst(qtype.isConst());
                Type vType = this.convertType(qtype.getType());
                if (vType != null) {
                    metaVar.setTypeDeclaration(new DeclarationTypeAccess(vType));
                }
            } else {
                metaVar.setTypeDeclaration(new DeclarationTypeAccess(this.convertType(cdtVar.getType())));
                if (cdtVar.getType() instanceof CPPPointerType) {
                    metaVar.setConst(((CPPPointerType)cdtVar.getType()).isConst());
                }
            }
            if (cdtVar.getDefinition() != null) {
                metaVar.setPosition(this.convertFileLocation(cdtVar.getDefinition().getFileLocation()));
            }
            pkg.addGlobalVariable(metaVar);
            this.globalVariablesTable.put(fullName, metaVar);
        } else {
            metaVar = (GlobalVariable)this.globalVariablesTable.get(fullName);
        }
        this.globalVariablesMapping.put(cdtVar, metaVar);
        return metaVar;
    }

    protected Class mapClass(ICPPClassType classType) {
        if (classType instanceof IProblemBinding) {
            if (!this.createFakesForProblemBindings) {
                this.handleProblem((IProblemBinding)classType);
                return null;
            }
            ((CPPClassType.CPPClassTypeProblem)classType).getFileName();
            try {
                ((CPPClassType.CPPClassTypeProblem)classType).getFields();
                ((CPPClassType.CPPClassTypeProblem)classType).getMethods();
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
        Class cls = this.getOrCreateClass(classType);
        try {
            IASTFileLocation fileLoc = null;
            if (classType instanceof CPPClassType) {
                fileLoc = ((CPPClassType)classType).getDefinition().getFileLocation();
            }
            if (classType instanceof CPPClassInstance) {
                fileLoc = ((CPPClassInstance)classType).getDefinition().getFileLocation();
            }
            if (fileLoc != null) {
                cls.setPosition(this.convertFileLocation(fileLoc));
            }
        }
        catch (Exception exception) {}
        cls.setPublic();
        this.root.addType((Type)cls);
        if (classType instanceof CPPClassType && ((CPPClassType)classType).getDefinition() != null && this.isInSourcePath(((CPPClassType)classType).getDefinition().getContainingFilename())) {
            this.mmClasses.add(cls);
            this.cdtClasses.add(classType);
        }
        return cls;
    }

    void convertClass(ICPPClassType classType, Class cls) {
        try {
            int i;
            if (this.isDefined(cls)) {
                return;
            }
            if (classType.getFriends() != null) {
                i = 0;
                while (i < classType.getFriends().length) {
                    Function fun;
                    Class me;
                    IBinding friend = classType.getFriends()[i];
                    if (friend instanceof ICPPClassType && (me = this.mapClass((ICPPClassType)friend)) != null) {
                        cls.addFriendClass(me);
                    }
                    if (!(friend instanceof ICPPMethod) && friend instanceof ICPPFunction && (fun = this.convertGlobalFunction((ICPPFunction)friend, null)) != null) {
                        cls.addFriendFunction(fun);
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < classType.getNestedClasses().length) {
                Class me;
                if (!ArrayUtil.contains((Object[])classType.getFriends(), (Object)classType.getNestedClasses()[i]) && (me = this.mapClass(classType.getNestedClasses()[i])) != null) {
                    cls.addInnerClass(me);
                }
                ++i;
            }
            if (classType.getDeclaredFields() != null) {
                i = 0;
                while (i < classType.getDeclaredFields().length) {
                    Field fld = this.convertField(cls, classType.getDeclaredFields()[i]);
                    if (fld != null) {
                        this.convertVisibility((ICPPMember)classType.getDeclaredFields()[i], (Member)fld);
                        cls.addField(fld);
                    }
                    ++i;
                }
            }
            if (classType.getDeclaredMethods() != null) {
                i = 0;
                while (i < classType.getDeclaredMethods().length) {
                    ICPPMethod cdtMeth = classType.getDeclaredMethods()[i];
                    Function meth = null;
                    if (cdtMeth instanceof ICPPConstructor) {
                        this.convertMethod(cls, cdtMeth);
                    } else if (cdtMeth instanceof ICPPMethod && (meth = this.convertMethod(cls, cdtMeth)) != null && meth instanceof Member) {
                        this.convertVisibility((ICPPMember)classType.getDeclaredMethods()[i], (Member)meth);
                    }
                    if (meth == null) {
                        // empty if block
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < classType.getBases().length) {
                Class base = (Class)this.convertType((IType)classType.getBases()[i].getBaseClass());
                if (base != null) {
                    InheritanceTypeAccess ita = new InheritanceTypeAccess(base);
                    cls.addInheritanceTypeAccess(ita);
                }
                ++i;
            }
            if (cls.getPosition() == null) {
                try {
                    cls.setPosition(this.convertFileLocation(((CPPClassType)classType).getDefinition().getParent().getFileLocation()));
                }
                catch (Exception ex) {
                    Debug.warning((String)("Exception caught: " + ex.getClass().getCanonicalName()));
                    ex.printStackTrace();
                }
            }
            this.setDefined(cls);
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
    }

    public Type convertEnum(IEnumeration enu) {
        String fullName = this.getFullName((IType)enu);
        if (this.typeTable.containsKey(fullName)) {
            return (Class)this.typeTable.get(fullName);
        }
        Class cls = new Class(enu.getName(), Class.KindOfClass.ENUMTYPE);
        this.typeTable.put(fullName, cls);
        this.root.addType((Type)cls);
        return cls;
    }

    protected void convertVisibility(ICPPMember member, Member mem) {
        if (member instanceof IProblemBinding) {
            return;
        }
        try {
            if (member.getVisibility() == 1) {
                mem.setPublic();
            } else if (member.getVisibility() == 2) {
                mem.setProtected();
            } else {
                mem.setPrivate();
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
            mem.setPrivate();
        }
    }

    protected Function convertGlobalFunction(ICPPFunction function, Package pkg) {
        GlobalFunction func = null;
        try {
            function.isInline();
        }
        catch (DOMException e1) {
            e1.printStackTrace();
        }
        String fullName = this.getFullSignature(function);
        if (this.functionTable.containsKey(fullName)) {
            Object o = this.functionTable.get(fullName);
            if (!(o instanceof GlobalFunction)) {
                IASTCompoundStatement stmt = (IASTCompoundStatement)((CPPASTFunctionDefinition)((CPPFunction)o).getDefinition().getParent()).getBody();
                Debug.error((String)("GlobalFunction error" + stmt.toString()));
            }
            func = (GlobalFunction)o;
            if (pkg != null) {
                pkg.addGlobalFunction(func);
            }
            return func;
        }
        try {
            func = this.getOrCreateGlobalFunction(function);
            Type retTyp = this.convertType(function.getType().getReturnType());
            if (retTyp != null) {
                func.setReturnTypeDeclaration(new DeclarationTypeAccess(retTyp));
            }
            int i = 0;
            while (i < function.getParameters().length) {
                IParameter cdtParam = function.getParameters()[i];
                Type parType = this.convertType(cdtParam.getType());
                if (parType != null) {
                    Position pos;
                    CPPParameter param;
                    FormalParameter fp = new FormalParameter(cdtParam.getName());
                    DeclarationTypeAccess dta = new DeclarationTypeAccess(parType);
                    if (cdtParam instanceof CPPParameter && (param = (CPPParameter)cdtParam).getDeclarations()[0] != null && (pos = this.convertFileLocation(param.getDeclarations()[0].getFileLocation())) != null) {
                        fp.setPosition(pos);
                        dta.setPosition(pos);
                    }
                    fp.setTypeDeclaration(dta);
                    func.addFormalParameter(fp);
                } else {
                    Debug.error((String)"Converting parameter failed");
                    Debug.error((String)("Parameter: " + cdtParam.getName() + " in function: " + function.getName()));
                }
                ++i;
            }
            if (function instanceof CPPFunction) {
                if (((CPPFunction)function).getDefinition() != null) {
                    func.setPosition(this.convertFileLocation(((CPPFunction)function).getDefinition().getFileLocation()));
                }
                if (func.getPosition() == null && ((CPPFunction)function).getDeclarations() != null) {
                    Position pos = this.convertFileLocation(((CPPFunction)function).getDeclarations()[0].getFileLocation());
                    func.setPosition(pos);
                    if (func.getReturnTypeDeclaration() != null) {
                        func.getReturnTypeDeclaration().setPosition(pos);
                    }
                }
            }
            if (pkg != null) {
                pkg.addGlobalFunction(func);
            }
            if (func.getPosition() != null && this.isInSourcePath(func.getPosition().getSourceFile().getPathName())) {
                this.mmFunctions.add(func);
                this.cdtFunctions.add(function);
            }
        }
        catch (Exception e) {
            Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
            e.printStackTrace();
        }
        return func;
    }

    protected void convertFunctionBody(CPPFunction func, Function mfunc) {
        if (mfunc == null) {
            Debug.error((String)("" + func));
            return;
        }
        this.functionStack.push(mfunc);
        this.currentFunction = mfunc;
        int max = mfunc.getFormalParameters().size();
        if (max > func.getParameters().length) {
            max = func.getParameters().length;
        }
        int i = 0;
        while (i < max) {
            FormalParameter fp = (FormalParameter)mfunc.getFormalParameters().get(i);
            fp.setSimpleName(func.getParameters()[i].getName());
            ++i;
        }
        try {
            if (mfunc instanceof Constructor && ((Constructor)mfunc).isInitializer()) {
                Statement s = (Statement)mfunc.getBody().getStatements().get(0);
                ModelElementList accList = s.getAccesses();
                IASTInitializer init = (IASTInitializer)this.fieldInitializers.get(mfunc);
                if (init instanceof IASTInitializerExpression) {
                    accList.addAll((Collection)this.convertExpressionFromAnchor(((IASTInitializerExpression)init).getExpression(), false, (ModelElement)s, ExpressionAnchorKind.CONDITION));
                }
                s.setAccesses(accList);
            } else {
                IASTNode def = func.getDefinition();
                if (def != null && def.getParent() != null) {
                    IASTFileLocation loc = def.getParent().getFileLocation();
                    mfunc.setPosition(this.convertFileLocation(loc));
                    if (mfunc.getBody() == null) {
                        mfunc.setBody((BlockStatement)this.convertBlockStatement((IASTCompoundStatement)((CPPASTFunctionDefinition)def.getParent()).getBody()));
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
            e.printStackTrace();
        }
        this.functionStack.pop();
        this.currentFunction = null;
    }

    protected void convertFunctionBody(IASTCompoundStatement body, Function mfunc) {
        if (mfunc == null) {
            Debug.error((String)"func");
            return;
        }
        this.functionStack.push(mfunc);
        this.currentFunction = mfunc;
        try {
            if (body != null) {
                mfunc.setBody((BlockStatement)this.convertBlockStatement(body));
            }
        }
        catch (Exception e) {
            Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
            e.printStackTrace();
        }
        this.functionStack.pop();
        this.currentFunction = null;
    }

    protected Statement convertStatement(IASTStatement stmt, BlockStatement parentMetaStmt) {
        if (stmt instanceof IASTDeclarationStatement) {
            IASTDeclarationStatement declstmt = (IASTDeclarationStatement)stmt;
            if (declstmt.getDeclaration() instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)declstmt.getDeclaration()).getDeclarators().length > 0 && ((IASTSimpleDeclaration)declstmt.getDeclaration()).getDeclarators()[0].getName().resolveBinding() instanceof IVariable) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)declstmt.getDeclaration();
                return this.convertSimpleDeclaration(simpleDecl);
            }
        } else {
            if (stmt instanceof IASTIfStatement) {
                return this.convertIfStatement(parentMetaStmt, (IASTIfStatement)stmt);
            }
            if (stmt instanceof IASTForStatement) {
                return this.convertForStatement(parentMetaStmt, (IASTForStatement)stmt);
            }
            if (stmt instanceof IASTDoStatement) {
                return this.convertDoStatement(parentMetaStmt, (IASTDoStatement)stmt);
            }
            if (stmt instanceof IASTWhileStatement) {
                return this.convertWhileStatement(parentMetaStmt, (IASTWhileStatement)stmt);
            }
            if (stmt instanceof IASTCompoundStatement) {
                return this.convertBlockStatement((IASTCompoundStatement)stmt);
            }
            if (stmt instanceof IASTLabelStatement) {
                return this.convertStatement(((IASTLabelStatement)stmt).getNestedStatement(), parentMetaStmt);
            }
            if (stmt instanceof ICPPASTTryBlockStatement) {
                return this.convertTryBlockStatement(parentMetaStmt, (ICPPASTTryBlockStatement)stmt);
            }
            if (stmt instanceof IASTSwitchStatement) {
                return this.convertSwitchStatement(parentMetaStmt, (IASTSwitchStatement)stmt);
            }
            if (stmt instanceof IASTExpressionStatement) {
                return this.convertExpressionStatement((IASTExpressionStatement)stmt);
            }
            if (stmt instanceof IASTReturnStatement) {
                return this.convertReturnStatement((IASTReturnStatement)stmt);
            }
            if (stmt instanceof IASTGotoStatement) {
                return this.convertGotoStatement(stmt);
            }
            if (stmt instanceof IASTProblemStatement) {
                return this.convertProblemStatement((IASTProblemStatement)stmt);
            }
        }
        SimpleStatement metastmt = new SimpleStatement();
        metastmt.setPosition(this.convertFileLocation(stmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertSimpleDeclaration(IASTSimpleDeclaration simpleDecl) {
        SimpleStatement metastmt = new SimpleStatement();
        metastmt.setPosition(this.convertFileLocation(simpleDecl.getFileLocation()));
        ModelElementList accList = new ModelElementList();
        int i = 0;
        while (i < simpleDecl.getDeclarators().length) {
            IASTInitializerExpression init;
            IASTDeclarator declarator = simpleDecl.getDeclarators()[i];
            LocalVariable metaVar = null;
            if (declarator.getName().resolveBinding() instanceof IVariable) {
                IVariable var = (IVariable)declarator.getName().resolveBinding();
                metaVar = new LocalVariable(var.getName());
                Type vType = null;
                try {
                    vType = this.convertType(var.getType());
                }
                catch (DOMException e1) {
                    e1.printStackTrace();
                }
                metaVar.setTypeDeclaration(new DeclarationTypeAccess(vType));
                Position p = null;
                try {
                    p = this.convertFileLocation(var.getScope().getPhysicalNode().getFileLocation());
                }
                catch (DOMException e) {
                    e.printStackTrace();
                }
                metaVar.setPosition(p);
                this.currentFunction.addLocalVariable(metaVar);
                if (declarator.getInitializer() instanceof ICPPASTConstructorInitializer) {
                    ICPPASTConstructorInitializer init2 = (ICPPASTConstructorInitializer)declarator.getInitializer();
                    String className = "";
                    try {
                        className = ASTTypeUtil.getType((IType)var.getType());
                    }
                    catch (DOMException e) {
                        e.printStackTrace();
                    }
                    StringBuffer str = new StringBuffer(String.valueOf(className) + "::" + className + "::(");
                    IASTExpression expr = init2.getExpression();
                    if (expr instanceof IASTExpressionList) {
                        IASTExpression[] exprlist = ((IASTExpressionList)expr).getExpressions();
                        int j = 0;
                        while (j < exprlist.length) {
                            str.append(ASTTypeUtil.getType((IType)CPPVisitor.getExpressionType((IASTExpression)exprlist[j])));
                            str.append(", ");
                            ++j;
                        }
                        str.delete(str.length() - 2, str.length());
                    } else {
                        str.append(ASTTypeUtil.getType((IType)CPPVisitor.getExpressionType((IASTExpression)expr)));
                    }
                    str.append(")");
                    Function func = (Function)this.functionTable.get(str.toString());
                    if (func != null) {
                        accList.add((Object)new FunctionAccess(func));
                        if (expr instanceof IASTExpressionList) {
                            accList.addAll((Collection)this.convertExpressionFromAnchor(expr, false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
                        } else {
                            CompositeAccess compAcc = new CompositeAccess();
                            compAcc.setAccesses(this.convertExpressionFromAnchor(expr, false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
                            accList.add((Object)compAcc);
                        }
                    }
                }
            }
            if (declarator.getInitializer() instanceof IASTInitializerExpression && (init = (IASTInitializerExpression)declarator.getInitializer()) != null) {
                if (metaVar != null) {
                    accList.add((Object)new VariableAccess((Variable)metaVar, true));
                }
                accList.addAll((Collection)this.convertExpressionFromAnchor(init.getExpression(), false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
                metastmt.setAccesses(accList);
            }
            ++i;
        }
        metastmt.setAccesses(accList);
        return metastmt;
    }

    private Statement convertIfStatement(BlockStatement parentMetaStmt, IASTIfStatement ifstmt) {
        BranchStatement metastmt = new BranchStatement();
        metastmt.setAccesses(this.convertExpressionFromAnchor(ifstmt.getConditionExpression(), false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
        metastmt.addBranch(this.convertStatement(ifstmt.getThenClause(), parentMetaStmt));
        if (ifstmt.getElseClause() == null) {
            BlockStatement elseStmt = new BlockStatement();
            Position pos = this.convertFileLocation(ifstmt.getFileLocation());
            if (pos != null) {
                pos.setStartLine(pos.getEndLine());
            }
            elseStmt.setPosition(pos);
            metastmt.addBranch((Statement)elseStmt);
        } else {
            metastmt.addBranch(this.convertStatement(ifstmt.getElseClause(), parentMetaStmt));
        }
        metastmt.setPosition(this.convertFileLocation(ifstmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertForStatement(BlockStatement parentMetaStmt, IASTForStatement forstmt) {
        LoopStatement metastmt = new LoopStatement(LoopStatement.LoopStatementKind.FOR);
        ModelElementList accList = new ModelElementList();
        this.forInitStmtConversion = true;
        Statement initStmt = this.convertStatement(forstmt.getInitializerStatement(), parentMetaStmt);
        this.forInitStmtConversion = false;
        initStmt.setPosition(this.convertFileLocation(forstmt.getInitializerStatement().getFileLocation()));
        parentMetaStmt.addStatement(initStmt);
        accList.addAll((Collection)this.convertExpressionFromAnchor(forstmt.getIterationExpression(), false, (ModelElement)metastmt, ExpressionAnchorKind.INCREMENT));
        accList.addAll((Collection)this.convertExpressionFromAnchor(forstmt.getConditionExpression(), false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
        metastmt.setAccesses(accList);
        metastmt.setBody(this.convertStatement(forstmt.getBody(), parentMetaStmt));
        metastmt.setPosition(this.convertFileLocation(forstmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertDoStatement(BlockStatement parentMetaStmt, IASTDoStatement dostmt) {
        LoopStatement metastmt = new LoopStatement(LoopStatement.LoopStatementKind.DOWHILE);
        metastmt.setAccesses(this.convertExpressionFromAnchor(dostmt.getCondition(), false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
        metastmt.setBody(this.convertStatement(dostmt.getBody(), parentMetaStmt));
        metastmt.setPosition(this.convertFileLocation(dostmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertWhileStatement(BlockStatement parentMetaStmt, IASTWhileStatement whilestmt) {
        LoopStatement metastmt = new LoopStatement(LoopStatement.LoopStatementKind.WHILE);
        metastmt.setAccesses(this.convertExpressionFromAnchor(whilestmt.getCondition(), false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
        metastmt.setBody(this.convertStatement(whilestmt.getBody(), parentMetaStmt));
        metastmt.setPosition(this.convertFileLocation(whilestmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertTryBlockStatement(BlockStatement parentMetaStmt, ICPPASTTryBlockStatement trystmt) {
        ExceptionHandler exHandler = new ExceptionHandler();
        exHandler.setPosition(this.convertFileLocation(trystmt.getFileLocation()));
        exHandler.setGuardedBlock((BlockStatement)this.convertStatement(trystmt.getTryBody(), parentMetaStmt));
        int i = 0;
        while (i < trystmt.getCatchHandlers().length) {
            try {
                ICPPASTCatchHandler handler = trystmt.getCatchHandlers()[i];
                IASTDeclaration tdecl = handler.getDeclaration();
                IBinding binding = null;
                if (tdecl != null) {
                    binding = ((IASTSimpleDeclaration)tdecl).getDeclarators()[0].getName().resolveBinding();
                }
                CatchBlock catchblock = new CatchBlock();
                if (binding != null) {
                    CPPVariable var = (CPPVariable)binding;
                    CatchParameter metaVar = new CatchParameter(var.getName());
                    metaVar.setTypeDeclaration(new DeclarationTypeAccess(this.convertType(var.getType())));
                    metaVar.setPosition(this.convertFileLocation(var.getDefinition().getFileLocation()));
                    catchblock.setCatchParameter(metaVar);
                }
                this.convertBlockStatement((IASTCompoundStatement)handler.getCatchBody(), (BlockStatement)catchblock);
                catchblock.setPosition(this.convertFileLocation(handler.getFileLocation()));
                exHandler.addCatchBlock(catchblock);
            }
            catch (Exception e) {
                Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
                e.printStackTrace();
            }
            ++i;
        }
        return exHandler;
    }

    private Statement convertSwitchStatement(BlockStatement parentMetaStmt, IASTSwitchStatement switchstmt) {
        BranchStatement metastmt = new BranchStatement();
        metastmt.setPosition(this.convertFileLocation(switchstmt.getFileLocation()));
        metastmt.setAccesses(this.convertExpressionFromAnchor(switchstmt.getControllerExpression(), false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION));
        IASTStatement body = switchstmt.getBody();
        LinkedList<BlockStatement> blockList = new LinkedList<BlockStatement>();
        boolean defaultFound = false;
        if (body instanceof CPPASTCompoundStatement) {
            IASTStatement[] stmts = ((CPPASTCompoundStatement)body).getStatements();
            int i = 0;
            while (i < stmts.length) {
                IASTStatement cstmt = stmts[i];
                if (cstmt instanceof CPPASTDefaultStatement) {
                    if (blockList.size() == 0 || ((BlockStatement)blockList.getLast()).getStatements().size() != 0) {
                        blockList.add(new BlockStatement());
                    }
                    defaultFound = true;
                } else if (cstmt instanceof IASTCaseStatement) {
                    BlockStatement newBlock = new BlockStatement();
                    this.convertExpressionFromAnchor(((IASTCaseStatement)cstmt).getExpression(), false, (ModelElement)newBlock, ExpressionAnchorKind.CONDITION);
                    blockList.add(newBlock);
                } else {
                    Statement convertedStatement = this.convertStatement(cstmt, parentMetaStmt);
                    for (BlockStatement block : blockList) {
                        block.addStatement(convertedStatement);
                    }
                    if (cstmt instanceof IASTBreakStatement || cstmt instanceof IASTReturnStatement) {
                        Iterator it = blockList.iterator();
                        while (it.hasNext()) {
                            metastmt.addBranch((Statement)it.next());
                        }
                        blockList.clear();
                    }
                }
                ++i;
            }
            Iterator it = blockList.iterator();
            while (it.hasNext()) {
                metastmt.addBranch((Statement)it.next());
            }
        } else {
            metastmt.addBranch(this.convertStatement(body, parentMetaStmt));
        }
        if (!defaultFound) {
            BlockStatement st = new BlockStatement();
            metastmt.addBranch((Statement)st);
        }
        return metastmt;
    }

    private Statement convertExpressionStatement(IASTExpressionStatement exstmt) {
        IASTExpression expression = exstmt.getExpression();
        Object metastmt = null;
        ModelElementList list = this.convertExpressionRecursive(expression, false);
        metastmt = !list.isEmpty() && list.get(0) instanceof ThrowTypeAccess ? new JumpStatement() : new SimpleStatement();
        if (this.extractExpressions) {
            this.sammExpressionConverter.convertExpressionFromAnchor(expression, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION, false);
        }
        metastmt.setPosition(this.convertFileLocation(exstmt.getFileLocation()));
        metastmt.setAccesses(list);
        return metastmt;
    }

    private Statement convertProblemStatement(IASTProblemStatement stmt) {
        Debug.error((String)stmt.getProblem().getMessage());
        SimpleStatement metastmt = new SimpleStatement();
        metastmt.setPosition(this.convertFileLocation(stmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertGotoStatement(IASTStatement stmt) {
        JumpStatement metastmt = new JumpStatement();
        metastmt.setPosition(this.convertFileLocation(stmt.getFileLocation()));
        return metastmt;
    }

    private Statement convertReturnStatement(IASTReturnStatement stmt) {
        IASTExpression expression = stmt.getReturnValue();
        JumpStatement metastmt = new JumpStatement();
        metastmt.setPosition(this.convertFileLocation(stmt.getFileLocation()));
        ModelElementList list = this.convertExpressionFromAnchor(expression, false, (ModelElement)metastmt, ExpressionAnchorKind.CONDITION);
        metastmt.setAccesses(list);
        return metastmt;
    }

    private ModelElementList convertBinaryExpression(IASTBinaryExpression binexp) {
        ModelElementList list = new ModelElementList();
        int op = binexp.getOperator();
        ModelElementList acc1 = this.convertExpressionRecursive(binexp.getOperand1(), op == 17 || op == 19 || op == 22 || op == 18 || op == 21 || op == 25 || op == 27 || op == 26 || op == 20 || op == 23 || op == 24);
        ModelElementList acc2 = this.convertExpressionRecursive(binexp.getOperand2(), false);
        list.addAll((Collection)acc1);
        list.addAll((Collection)acc2);
        return list;
    }

    private ModelElementList convertCPPCastExpression(CPPASTCastExpression castExp) {
        ModelElementList list = new ModelElementList();
        CPPASTTypeId tid = (CPPASTTypeId)castExp.getTypeId();
        Type type = this.convertType(CPPVisitor.createType((IASTNode)tid));
        list.add((Object)new CastTypeAccess(type));
        if (castExp.getOperator() == 1) {
            list.add((Object)new RunTimeTypeAccess(type));
        }
        list.addAll((Collection)this.convertExpressionRecursive(castExp.getOperand(), false));
        return list;
    }

    private ModelElementList convertUnaryExpression(IASTUnaryExpression unexp, boolean isWrite) {
        ModelElementList list = new ModelElementList();
        int op = unexp.getOperator();
        list.addAll((Collection)this.convertExpressionRecursive(unexp.getOperand(), isWrite || op == 10 || op == 9 || op == 1 || op == 0));
        if (op == 12) {
            IType type = CPPVisitor.getExpressionType((IASTExpression)unexp.getOperand());
            list.add((Object)new ThrowTypeAccess(this.convertType(type)));
        }
        return list;
    }

    public ModelElementList convertIdExpression(IASTIdExpression id, boolean isWrite) {
        ModelElementList list = new ModelElementList();
        IBinding bind = id.getName().resolveBinding();
        if (bind instanceof ICPPVariable) {
            ICPPVariable var = (ICPPVariable)bind;
            ModelElement mmVar = null;
            mmVar = this.currentFunction.getFormalParameters().findByName(var.getName());
            if (mmVar == null) {
                mmVar = this.currentFunction.getLocalVariables().findByName(var.getName());
            }
            if (mmVar == null && this.globalVariablesMapping.containsKey(var)) {
                mmVar = (Variable)this.globalVariablesMapping.get(var);
            }
            if (mmVar == null && var instanceof CPPField) {
                CPPField field = (CPPField)var;
                Field mmFld = (Field)this.fieldTable.get(this.getFullName((ICPPBinding)field));
                if (mmFld == null) {
                    return list;
                }
                mmVar = mmFld;
                if (id.getName() instanceof CPPASTQualifiedName) {
                    if (mmFld.isStatic()) {
                        list.add((Object)new StaticTypeAccess((Type)mmFld.getSurroundingClass()));
                    }
                } else if (this.currentFunction instanceof Member) {
                    SelfAccess selfAccess = new SelfAccess(((Member)this.currentFunction).getSurroundingClass());
                    list.add((Object)selfAccess);
                }
            }
            if (mmVar == null && var instanceof CPPVariable) {
                mmVar = this.convertGlobalVariable((CPPVariable)var, this.rootPackage);
            }
            if (mmVar == null && var instanceof CPPVariable.CPPVariableDelegate && (bind = ((CPPVariable.CPPVariableDelegate)var).getBinding()) instanceof CPPVariable) {
                mmVar = this.convertGlobalVariable((CPPVariable)bind, this.rootPackage);
            }
            if (mmVar != null) {
                list.add((Object)new VariableAccess((Variable)mmVar, isWrite));
                return list;
            }
            try {
                Debug.error((String)("Var Access is null: " + var.getName() + " Type: " + var.getType() + " (" + var.getClass().getName() + "), \n \t Containing function: " + this.currentFunction.signature().toString() + ", \n \t Formal Parameters: " + this.currentFunction.getFormalParameters().toString()));
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            return list;
        }
        if (bind instanceof CPPFunction) {
            CPPFunction function = (CPPFunction)bind;
            return this.convertFunctionBinding(function, id.getName() instanceof CPPASTQualifiedName);
        }
        return list;
    }

    private ModelElementList convertExpressionList(IASTExpressionList expList) {
        ModelElementList list = new ModelElementList();
        int i = 0;
        while (i < expList.getExpressions().length) {
            CompositeAccess acc = new CompositeAccess();
            acc.setAccesses(this.convertExpressionRecursive(expList.getExpressions()[i], false));
            list.add((Object)acc);
            ++i;
        }
        return list;
    }

    private ModelElementList convertFunctionCallExpression(IASTFunctionCallExpression funcall) {
        ModelElementList list = new ModelElementList();
        ModelElementList funcList = this.convertExpressionRecursive(funcall.getFunctionNameExpression(), false);
        if (funcList.size() > 0) {
            if (funcall.getFunctionNameExpression() instanceof IASTIdExpression && ((Access)funcList.get(0)).getAccessedTarget() instanceof Method && this.currentFunction instanceof Member) {
                SelfAccess selfAccess = new SelfAccess(((Member)this.currentFunction).getSurroundingClass());
                list.add((Object)selfAccess);
            }
        } else if (this.fakeDeps) {
            String fullname = funcall.getFunctionNameExpression().getRawSignature();
            if (fullname.length() == 0) {
                return new ModelElementList();
            }
            fullname = fullname.replace("\n", "");
            fullname = fullname.replace("\t", "");
            Function fn = (Function)this.functionTable.get(fullname = fullname.replace(" ", ""));
            if (fn == null) {
                fn = new GlobalFunction(fullname);
                fn.setFailedDependency();
                this.functionTable.put(String.valueOf(fullname) + "::()", fn);
            }
            FunctionAccess fa = new FunctionAccess(fn);
            funcList.add((Object)fa);
            funcList.addAll((Collection)this.convertExpressionRecursive(funcall.getFunctionNameExpression(), false));
            Debug.warning((String)"Access to failed dep global function.");
        }
        list.addAll((Collection)funcList);
        if (funcall.getParameterExpression() instanceof IASTExpressionList) {
            list.addAll((Collection)this.convertExpressionRecursive(funcall.getParameterExpression(), false));
        } else if (funcall.getParameterExpression() != null) {
            CompositeAccess compAcc = new CompositeAccess();
            compAcc.setAccesses(this.convertExpressionRecursive(funcall.getParameterExpression(), false));
            list.add((Object)compAcc);
        }
        return list;
    }

    private ModelElementList convertCPPNewExpression(ICPPASTNewExpression conCall) {
        IASTDeclSpecifier dspec;
        ModelElementList list = new ModelElementList();
        if (conCall.isNewTypeId() && (dspec = conCall.getTypeId().getDeclSpecifier()) instanceof IASTNamedTypeSpecifier) {
            IBinding bind = ((IASTNamedTypeSpecifier)dspec).getName().resolveBinding();
            if (bind instanceof CPPFunction) {
                list.addAll((Collection)this.convertFunctionBinding((CPPFunction)bind, false));
                if (conCall.getNewInitializer() instanceof IASTExpressionList) {
                    list.addAll((Collection)this.convertExpressionRecursive(conCall.getNewInitializer(), false));
                } else if (conCall.getNewInitializer() != null) {
                    CompositeAccess compAcc = new CompositeAccess();
                    compAcc.setAccesses(this.convertExpressionRecursive(conCall.getNewInitializer(), false));
                    list.add((Object)compAcc);
                }
            } else if (this.fakeDeps && bind instanceof IProblemBinding) {
                String fullname = dspec.getRawSignature();
                if (fullname.length() == 0) {
                    return null;
                }
                fullname = fullname.replace("\n", "");
                fullname = fullname.replace("\t", "");
                fullname = fullname.replace(" ", "");
                Class cls = new Class(fullname, Class.KindOfClass.NORMALCLASS);
                cls.setFailedDependency();
                this.typeTable.put(fullname, cls);
                Constructor ctor = new Constructor(fullname);
                ctor.setFailedDependency();
                this.functionTable.put(fullname, ctor);
                bind = ((IASTNamedTypeSpecifier)dspec).getName().resolveBinding();
                list.add((Object)new FunctionAccess((Function)ctor));
                if (conCall.getNewInitializer() instanceof IASTExpressionList) {
                    list.addAll((Collection)this.convertExpressionRecursive(conCall.getNewInitializer(), false));
                } else if (conCall.getNewInitializer() != null) {
                    CompositeAccess compAcc = new CompositeAccess();
                    compAcc.setAccesses(this.convertExpressionRecursive(conCall.getNewInitializer(), false));
                    list.add((Object)compAcc);
                }
                Debug.warning((String)"Access to failed dep constructor.");
            }
        }
        return list;
    }

    private ModelElementList convertCPPFieldReference(CPPASTFieldReference ref, boolean isWrite) {
        ModelElementList list = new ModelElementList();
        list.addAll((Collection)this.convertExpressionRecursive(ref.getFieldOwner(), false));
        IBinding bind = ref.getFieldName().resolveBinding();
        if (bind instanceof CPPField) {
            IASTName[] names;
            CPPField field = (CPPField)bind;
            Field mmFld = (Field)this.fieldTable.get(this.getFullName((ICPPBinding)field));
            if (list.size() > 0 && list.get(0) instanceof SelfAccess && ref.getFieldName() instanceof CPPASTQualifiedName && (names = ((CPPASTQualifiedName)ref.getFieldName()).getNames()).length > 1) {
                Class mmcls = this.getOrCreateClass((ICPPClassType)names[names.length - 2].resolveBinding());
                SelfAccess sa = (SelfAccess)list.get(0);
                if (this.currentFunction instanceof Member && ((Member)this.currentFunction).getSurroundingClass().extendsClass(mmcls)) {
                    sa.setSuperAccess(true);
                }
            }
            list.add((Object)new VariableAccess((Variable)mmFld, isWrite));
            return list;
        }
        if (bind instanceof CPPFunction) {
            IASTName[] names;
            CPPFunction function = (CPPFunction)bind;
            if (list.size() > 0 && list.get(0) instanceof SelfAccess && ref.getFieldName() instanceof CPPASTQualifiedName && (names = ((CPPASTQualifiedName)ref.getFieldName()).getNames()).length > 1) {
                Class mmcls = this.getOrCreateClass((ICPPClassType)names[names.length - 2].resolveBinding());
                SelfAccess sa = (SelfAccess)list.get(0);
                if (this.currentFunction instanceof Member && ((Member)this.currentFunction).getSurroundingClass().extendsClass(mmcls)) {
                    sa.setSuperAccess(true);
                }
            }
            list.addAll((Collection)this.convertFunctionBinding(function, false));
            return list;
        }
        if (bind instanceof IProblemBinding) {
            IProblemBinding problem = (IProblemBinding)bind;
            IType type = CPPVisitor.getExpressionType((IASTExpression)ref.getFieldOwner());
            Type metaType = this.convertType(type);
            if (metaType != null) {
                while (metaType instanceof TypeDecorator) {
                    metaType = ((TypeDecorator)metaType).getDecoratedType();
                }
                String name = problem.getASTNode().getRawSignature();
                if (problem.getASTNode().getParent().getParent() instanceof IASTFunctionCallExpression) {
                    Method met = this.getOrCreateFailedDepMethod((Class)metaType, name);
                    list.add((Object)new FunctionAccess((Function)met));
                } else {
                    Field var = this.getOrCreateFailedDepField((Class)metaType, name);
                    list.add((Object)new VariableAccess((Variable)var, isWrite));
                }
            }
        }
        return list;
    }

    protected ModelElementList convertExpressionFromAnchor(IASTExpression exp, boolean isWrite, ModelElement anchor, ExpressionAnchorKind anchorKind) {
        ModelElementList list = this.convertExpressionRecursive(exp, isWrite);
        if (this.extractExpressions) {
            this.sammExpressionConverter.convertExpressionFromAnchor(exp, anchor, this.forInitStmtConversion ? ExpressionAnchorKind.INIT : anchorKind, isWrite);
        }
        return list;
    }

    protected ModelElementList convertExpressionRecursive(IASTExpression exp, boolean isWrite) {
        ModelElementList list = null;
        if (exp instanceof IASTBinaryExpression) {
            list = this.convertBinaryExpression((IASTBinaryExpression)exp);
        } else if (exp instanceof IASTCastExpression) {
            list = this.convertCPPCastExpression((CPPASTCastExpression)exp);
        } else if (exp instanceof IASTUnaryExpression) {
            list = this.convertUnaryExpression((IASTUnaryExpression)exp, isWrite);
        } else if (exp instanceof IASTIdExpression) {
            list = this.convertIdExpression((IASTIdExpression)exp, isWrite);
        } else if (exp instanceof IASTExpressionList) {
            list = this.convertExpressionList((IASTExpressionList)exp);
        } else if (exp instanceof IASTFunctionCallExpression) {
            list = this.convertFunctionCallExpression((IASTFunctionCallExpression)exp);
        } else if (exp instanceof ICPPASTNewExpression) {
            list = this.convertCPPNewExpression((ICPPASTNewExpression)exp);
        } else if (exp instanceof CPPASTFieldReference) {
            list = this.convertCPPFieldReference((CPPASTFieldReference)exp, isWrite);
        } else if (exp instanceof IASTLiteralExpression || exp == null) {
            if ((exp == null || ((IASTLiteralExpression)exp).getKind() == 4) && this.currentFunction instanceof Member) {
                list = new ModelElementList();
                list.add((Object)new SelfAccess(((Member)this.currentFunction).getSurroundingClass()));
            }
        } else if (exp instanceof IASTArraySubscriptExpression) {
            list = this.convertExpressionRecursive(((IASTArraySubscriptExpression)exp).getArrayExpression(), false);
        } else if (exp instanceof CPPASTDeleteExpression) {
            list = this.convertExpressionRecursive(((CPPASTDeleteExpression)exp).getOperand(), false);
        }
        return list != null ? list : new ModelElementList();
    }

    protected ModelElementList convertFunctionBinding(CPPFunction bind, boolean qualified) {
        ModelElementList list = new ModelElementList();
        String s = this.getFullSignature((ICPPFunction)bind);
        Function func = (Function)this.functionTable.get(s);
        if (func != null) {
            if (func instanceof Method && ((Method)func).isStatic()) {
                Method meth = (Method)func;
                Type cls = (Type)meth.getParent();
                if (qualified) {
                    list.add((Object)new StaticTypeAccess(cls));
                }
            }
            if (func instanceof Constructor) {
                Constructor cfr_ignored_0 = (Constructor)func;
            }
            FunctionAccess fa = new FunctionAccess(func);
            list.add((Object)fa);
        } else {
            func = !(bind instanceof ICPPMethod) ? this.convertGlobalFunction((ICPPFunction)bind, this.rootPackage) : this.convertMethod((ICPPMethod)bind);
            FunctionAccess fa = new FunctionAccess(func);
            list.add((Object)fa);
        }
        return list;
    }

    protected Statement convertBlockStatement(IASTCompoundStatement stmt, BlockStatement metastmt) {
        metastmt.setPosition(this.convertFileLocation(stmt.getFileLocation()));
        int i = 0;
        while (i < stmt.getStatements().length) {
            Statement s = this.convertStatement(stmt.getStatements()[i], metastmt);
            metastmt.addStatement(s);
            ++i;
        }
        return metastmt;
    }

    protected Statement convertBlockStatement(IASTCompoundStatement stmt) {
        BlockStatement metastmt = new BlockStatement();
        return this.convertBlockStatement(stmt, metastmt);
    }

    protected Function convertMethod(ICPPMethod met) {
        if (met instanceof IProblemBinding && !this.createFakesForProblemBindings) {
            this.handleProblem((IProblemBinding)met);
            return null;
        }
        String fullName = this.getFullSignature((ICPPFunction)met);
        if (this.functionTable.containsKey(fullName)) {
            Object o = this.functionTable.get(fullName);
            return (Function)o;
        }
        try {
            IASTDeclaration decl = null;
            if (met instanceof CPPMethod) {
                decl = (IASTDeclaration)((CPPMethod)met).getPrimaryDeclaration().getParent().getParent();
            } else if (met instanceof CPPImplicitMethod) {
                decl = (IASTDeclaration)((CPPImplicitMethod)met).getScope().getPhysicalNode().getParent();
            }
            IASTDeclSpecifier n = ((CPPASTSimpleDeclaration)decl).getDeclSpecifier();
            IType type = CPPVisitor.createType((IASTDeclSpecifier)n);
            if (type instanceof CPPClassType) {
                Class cls = this.mapClass((ICPPClassType)((CPPClassType)type));
                return this.convertMethod(cls, met);
            }
            return null;
        }
        catch (DOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isMethodVirtual(ICPPMethod method) {
        try {
            if (method.isVirtual()) {
                return true;
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected Function convertMethod(Class cls, ICPPMethod method) {
        Function meth;
        block37: {
            meth = null;
            if (method instanceof IProblemBinding && !this.createFakesForProblemBindings) {
                this.handleProblem((IProblemBinding)method);
                return null;
            }
            String fullName = this.getFullSignature((ICPPFunction)method);
            if (this.functionTable.containsKey(fullName)) {
                Object o = this.functionTable.get(fullName);
                meth = (Function)o;
            } else {
                meth = this.getOrCreateMethod(cls, method);
            }
            if (meth == null) {
                return null;
            }
            try {
                if (this.isDeclared(meth)) break block37;
                this.setDeclared(meth);
                ICPPASTFunctionDeclarator declarator = null;
                if (!(method instanceof CPPFunction)) break block37;
                if (((CPPFunction)method).getDeclarations() != null && ((CPPFunction)method).getDeclarations().length > 0) {
                    declarator = (ICPPASTFunctionDeclarator)((CPPFunction)method).getDeclarations()[0];
                    if (((CPPFunction)method).getDeclarations().length > 0 && meth.getPosition() != null) {
                        meth.setPosition(this.convertFileLocation(((CPPFunction)method).getDeclarations()[0].getFileLocation()));
                    }
                } else {
                    declarator = (ICPPASTFunctionDeclarator)((CPPFunction)method).getDefinition();
                }
                if (declarator != null) {
                    Type retType;
                    if (meth instanceof Method) {
                        try {
                            ((Method)meth).setOperator(declarator.getName() instanceof ICPPASTOperatorName);
                            ((Method)meth).setAbstract(declarator.isPureVirtual());
                            ((Method)meth).setVirtual(method.isVirtual());
                            ((Method)meth).setStatic(method.isStatic());
                        }
                        catch (Exception ex) {
                            Debug.warning((String)("Exception caught: " + ex.getClass().getCanonicalName()));
                            ex.printStackTrace();
                        }
                    } else if (meth instanceof Destructor) {
                        boolean isVirtual = method.isVirtual();
                        try {
                            isVirtual = ((CPPASTSimpleDeclSpecifier)((CPPASTSimpleDeclaration)declarator.getParent()).getDeclSpecifier()).isVirtual();
                        }
                        catch (Exception exception) {}
                        ((Destructor)meth).setVirtual(isVirtual);
                    }
                    if ((retType = this.convertType(method.getType().getReturnType())) != null) {
                        meth.setReturnTypeDeclaration(new DeclarationTypeAccess(retType));
                    }
                }
                int i = 0;
                while (i < method.getParameters().length) {
                    IParameter cdtParam = method.getParameters()[i];
                    Type parType = this.convertType(cdtParam.getType());
                    if (!(parType == null || parType != null && parType.getSimpleName().equals("void"))) {
                        Position pos;
                        CPPParameter param;
                        FormalParameter fp = new FormalParameter(cdtParam.getName());
                        DeclarationTypeAccess dta = new DeclarationTypeAccess(parType);
                        if (cdtParam instanceof CPPParameter && (param = (CPPParameter)cdtParam).getDeclarations() != null && param.getDeclarations().length > 0 && param.getDeclarations()[0] != null && (pos = this.convertFileLocation(param.getDeclarations()[0].getFileLocation())) != null) {
                            fp.setPosition(pos);
                            dta.setPosition(pos);
                        }
                        fp.setTypeDeclaration(dta);
                        meth.addFormalParameter(fp);
                    }
                    ++i;
                }
                if (declarator != null) {
                    ICPPASTConstructorChainInitializer[] chain = declarator.getConstructorChain();
                    int i2 = 0;
                    while (i2 < chain.length) {
                        IBinding bind = chain[i2].getMemberInitializerId().resolveBinding();
                        ModelElementList list = new ModelElementList();
                        if (bind instanceof CPPFunction) {
                            list = this.convertFunctionBinding((CPPFunction)bind, false);
                            Function oldFunc = this.currentFunction;
                            this.currentFunction = meth;
                            if (chain[i2].getInitializerValue() instanceof IASTExpressionList) {
                                list.addAll((Collection)this.convertExpressionFromAnchor(chain[i2].getInitializerValue(), false, (ModelElement)meth, ExpressionAnchorKind.CONDITION));
                            } else if (chain[i2].getInitializerValue() != null) {
                                CompositeAccess compAcc = new CompositeAccess();
                                compAcc.setAccesses(this.convertExpressionFromAnchor(chain[i2].getInitializerValue(), false, (ModelElement)meth, ExpressionAnchorKind.CONDITION));
                                list.add((Object)compAcc);
                            }
                            this.currentFunction = oldFunc;
                        } else if (bind instanceof CPPField) {
                            CPPField cdtfld = (CPPField)bind;
                            Field mmfld = this.convertField(cls, (ICPPField)cdtfld);
                            list.add((Object)new VariableAccess((Variable)mmfld, true));
                            Function oldFunc = this.currentFunction;
                            this.currentFunction = meth;
                            list.addAll((Collection)this.convertExpressionFromAnchor(chain[i2].getInitializerValue(), false, (ModelElement)meth, ExpressionAnchorKind.CONDITION));
                            this.currentFunction = oldFunc;
                        }
                        if (!list.isEmpty()) {
                            meth.setAccesses(list);
                        }
                        ++i2;
                    }
                }
                if (((CPPFunction)method).getDefinition() != null) {
                    meth.setPosition(this.convertFileLocation(((CPPFunction)method).getDefinition().getFileLocation()));
                    Position pos = this.convertFileLocation(((CPPFunction)method).getDefinition().getFileLocation());
                    meth.setPosition(pos);
                    if (meth.getReturnTypeDeclaration() != null) {
                        meth.getReturnTypeDeclaration().setPosition(pos);
                    }
                }
            }
            catch (Exception e) {
                Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
                e.printStackTrace();
            }
        }
        if (method instanceof CPPFunction && !this.isDefined(meth)) {
            CPPFunction cppmethod = (CPPFunction)method;
            if (cppmethod.getDefinition() != null) {
                meth.setPosition(this.convertFileLocation(cppmethod.getDefinition().getParent().getFileLocation()));
                this.setDefined(meth);
                this.mmFunctions.add(meth);
                this.cdtFunctions.add(method);
            } else if (cppmethod.getDeclarations() != null && cppmethod.getDeclarations()[0] != null) {
                meth.setPosition(this.convertFileLocation(cppmethod.getDeclarations()[0].getFileLocation()));
            }
        }
        if (method instanceof CPPConstructor) {
            CPPConstructor cfr_ignored_0 = (CPPConstructor)method;
        }
        return meth;
    }

    protected Field convertField(Class cls, ICPPField field) {
        if (field instanceof IProblemBinding && !this.createFakesForProblemBindings) {
            this.handleProblem((IProblemBinding)field);
            return null;
        }
        String fullName = this.getFullName((ICPPBinding)field);
        if (this.fieldTable.containsKey(fullName)) {
            return (Field)this.fieldTable.get(fullName);
        }
        Field fld = null;
        try {
            IType type;
            Type typ;
            CPPASTDeclarator d;
            IASTNode def;
            fld = this.getOrCreateField(cls, field);
            if (field instanceof CPPField && (def = ((CPPField)field).getDefinition()) != null && def.getParent() instanceof CPPASTDeclarator && (d = (CPPASTDeclarator)def.getParent()).getInitializer() != null) {
                Constructor init = new Constructor(fld.getSimpleName());
                init.setInitializer();
                init.setPosition(this.convertFileLocation(d.getInitializer().getFileLocation()));
                BlockStatement blk = new BlockStatement();
                blk.setPosition(this.convertFileLocation(d.getInitializer().getFileLocation()));
                SimpleStatement initializationStatement = new SimpleStatement();
                initializationStatement.setPosition(this.convertFileLocation(d.getInitializer().getFileLocation()));
                blk.addStatement((Statement)initializationStatement);
                init.setBody(blk);
                ModelElementList accList = new ModelElementList();
                accList.add((Object)new VariableAccess((Variable)fld, true));
                initializationStatement.setAccesses(accList);
                cls.addConstructor(init);
                this.setDefined(init);
                this.fieldInitializers.put(init, d.getInitializer());
                this.mmFunctions.add(init);
                this.cdtFunctions.add(null);
            }
            if (field instanceof IProblemBinding) {
                return fld;
            }
            if (field instanceof CPPField && !this.isDefined(fld)) {
                CPPField cppfield = (CPPField)field;
                if (cppfield.getDefinition() != null) {
                    fld.setPosition(this.convertFileLocation(cppfield.getDefinition().getFileLocation()));
                    this.setDefined(fld);
                } else if (cppfield.getDeclarations()[0] != null) {
                    fld.setPosition(this.convertFileLocation(cppfield.getDeclarations()[0].getFileLocation()));
                }
            }
            if ((typ = this.convertType(type = field.getType())) != null) {
                fld.setTypeDeclaration(new DeclarationTypeAccess(typ));
            }
            fld.setStatic(field.isStatic());
            if (type instanceof IQualifierType) {
                fld.setConst(((IQualifierType)type).isConst());
            }
            if (type instanceof IPointerType) {
                fld.setConst(((IPointerType)type).isConst());
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        return fld;
    }

    public Type convertType(IType type) {
        if (type instanceof CPPQualifierType) {
            return this.convertType(((CPPQualifierType)type).getType());
        }
        if (type instanceof CPPTypedef) {
            return this.convertType(((CPPTypedef)type).getType());
        }
        String fullname = this.getFullName(type);
        if (fullname.length() == 0) {
            return null;
        }
        fullname = fullname.replace("\n", "");
        fullname = fullname.replace("\t", "");
        if (this.typeTable.containsKey(fullname = fullname.replace(" ", ""))) {
            return (Type)this.typeTable.get(fullname);
        }
        if (type instanceof ICPPClassType) {
            return this.mapClass((ICPPClassType)type);
        }
        if (type instanceof IProblemBinding) {
            this.handleProblem((IProblemBinding)type);
            Debug.info((String)("Create Fake Class for type: " + fullname));
            Class cls = new Class(fullname, Class.KindOfClass.NORMALCLASS);
            cls.setFailedDependency();
            this.typeTable.put(fullname, cls);
            this.root.addType((Type)cls);
            return cls;
        }
        if (type instanceof ICPPBasicType) {
            ICPPBasicType basicType = (ICPPBasicType)type;
            Class cls = new Class(this.getFullName((IType)basicType), Class.KindOfClass.NORMALCLASS);
            cls.setPrimitive();
            cls.setImplicit();
            this.typeTable.put(fullname, cls);
            this.root.addType((Type)cls);
            return cls;
        }
        if (type instanceof IEnumeration) {
            return this.convertEnum((IEnumeration)type);
        }
        if (type instanceof IArrayType) {
            Type contentType;
            block19: {
                IArrayType arrayType = (IArrayType)type;
                contentType = this.convertType(arrayType.getType());
                if (contentType != null) break block19;
                return null;
            }
            try {
                Array a = new Array(contentType);
                this.typeTable.put(fullname, a);
                this.root.addType((Type)a);
                return a;
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        } else {
            if (type instanceof CPPTypedef) {
                Type contentType = this.convertType(((CPPTypedef)type).getType());
                if (contentType == null) {
                    return null;
                }
                TypeAlias aliasType = new TypeAlias(contentType, ((CPPTypedef)type).getName());
                aliasType.setPosition(this.convertFileLocation(((CPPTypedef)type).getDefinition().getFileLocation()));
                this.typeTable.put(fullname, aliasType);
                this.root.addType((Type)aliasType);
                return aliasType;
            }
            if (type instanceof CPPReferenceType) {
                Type contentType = this.convertType(((CPPReferenceType)type).getType());
                if (contentType == null) {
                    return null;
                }
                Reference refType = new Reference(contentType, String.valueOf(contentType.getSimpleName()) + REFERENCE_MARKER);
                refType.setImplicit();
                this.typeTable.put(fullname, refType);
                this.root.addType((Type)refType);
                return refType;
            }
            if (type instanceof CPPPointerType) {
                Type contentType = this.convertType(((CPPPointerType)type).getType());
                if (contentType == null) {
                    return null;
                }
                Reference refType = new Reference(contentType, String.valueOf(contentType.getSimpleName()) + POINTER_MARKER);
                refType.setExplicit();
                this.typeTable.put(fullname, refType);
                this.root.addType((Type)refType);
                return refType;
            }
        }
        return null;
    }

    public Field getOrCreateField(Class cls, ICPPField field) {
        String fullName = this.getFullName((ICPPBinding)field);
        if (this.fieldTable.containsKey(fullName)) {
            return (Field)this.fieldTable.get(fullName);
        }
        Field fld = new Field(field.getName());
        this.fieldTable.put(fullName, fld);
        cls.addField(fld);
        return fld;
    }

    public Field getOrCreateFailedDepField(Class cls, String name) {
        ModelElementList list = cls.getFields();
        Field field = (Field)list.findByName(name);
        if (field != null) {
            return field;
        }
        Field fld = new Field(name);
        cls.addField(fld);
        return fld;
    }

    public Method getOrCreateFailedDepMethod(Class cls, String name) {
        ModelElementList list = cls.getMethods();
        Method meth = (Method)list.findByName(name);
        if (meth != null) {
            return meth;
        }
        meth = new Method(name);
        cls.addMethod(meth);
        return meth;
    }

    public Function getOrCreateMethod(Class cls, ICPPMethod method) {
        String fullName = null;
        fullName = this.getFullSignature((ICPPFunction)method);
        if (this.functionTable.containsKey(fullName)) {
            return (Function)this.functionTable.get(fullName);
        }
        Constructor meth = null;
        boolean isDestructor = false;
        try {
            isDestructor = method.isDestructor();
        }
        catch (DOMException dOMException) {}
        if (method instanceof ICPPConstructor) {
            meth = new Constructor(method.getName());
            cls.addConstructor(meth);
        } else if (isDestructor) {
            meth = new Destructor(method.getName());
            cls.addDestructor((Destructor)meth);
        } else {
            meth = new Method(method.getName());
            cls.addMethod((Method)meth);
        }
        this.functionTable.put(fullName, meth);
        return meth;
    }

    public GlobalFunction getOrCreateGlobalFunction(ICPPFunction function) {
        String fullName = null;
        fullName = this.getFullSignature(function);
        if (this.functionTable.containsKey(fullName)) {
            return (GlobalFunction)this.functionTable.get(fullName);
        }
        GlobalFunction func = new GlobalFunction(function.getName());
        this.functionTable.put(fullName, func);
        return func;
    }

    public Class getOrCreateClass(ICPPClassType binding) {
        String fullName = this.getFullName((IType)binding);
        if (this.typeTable.containsKey(fullName)) {
            return (Class)this.typeTable.get(fullName);
        }
        String name = "";
        name = binding instanceof IProblemBinding ? ((IProblemBinding)binding).getASTNode().getRawSignature() : binding.getName();
        Class cls = null;
        try {
            switch (binding.getKey()) {
                case 1: {
                    cls = new Class(name, Class.KindOfClass.STRUCT);
                    break;
                }
                case 2: {
                    cls = new Class(name, Class.KindOfClass.UNION);
                    break;
                }
                default: {
                    cls = new Class(name, Class.KindOfClass.NORMALCLASS);
                    break;
                }
            }
        }
        catch (DOMException dOMException) {
            cls = new Class(name, Class.KindOfClass.NORMALCLASS);
        }
        if (cls != null) {
            try {
                if (binding instanceof IProblemBinding) {
                    cls.setFailedDependency();
                    IASTFileLocation location = ((IProblemBinding)binding).getASTNode().getFileLocation();
                    cls.setPosition(this.convertFileLocation(location));
                } else {
                    IASTNode def = null;
                    if (binding instanceof ICPPInternalBinding) {
                        def = ((ICPPInternalBinding)binding).getDefinition();
                    }
                    if (def != null) {
                        cls.setPosition(this.convertFileLocation(def.getParent().getFileLocation()));
                    }
                }
            }
            catch (Exception ex) {
                Debug.warning((String)("Exception caught: " + ex.getClass().getCanonicalName()));
                ex.printStackTrace();
            }
            this.typeTable.put(fullName, cls);
            this.root.addType((Type)cls);
        }
        return cls;
    }

    protected String getFullName(IType type) {
        Stack<String> stack = new Stack<String>();
        StringBuffer buffer = new StringBuffer();
        try {
            if (type instanceof IProblemBinding) {
                return ((ProblemBinding)type).getASTNode().getRawSignature();
            }
            if (type instanceof ICompositeType) {
                IScope scope = ((ICompositeType)type).getScope();
                while (scope != null && scope.getScopeName() != null) {
                    stack.push(scope.getScopeName().toString());
                    scope = scope.getParent();
                }
                while (!stack.empty()) {
                    buffer.append(stack.pop());
                    buffer.append("::");
                }
            }
            buffer.append(ASTTypeUtil.getType((IType)type));
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    protected String getFullName(ICPPBinding binding) {
        if (binding instanceof ProblemBinding) {
            return ((ProblemBinding)binding).getMessage();
        }
        try {
            return MetamodConverter.joinName(binding.getQualifiedName());
        }
        catch (DOMException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected String getFullSignature(ICPPFunction function) {
        String str = this.getFullName((ICPPBinding)function);
        try {
            str = String.valueOf(str) + MetamodConverter.getParameterTypeString(function.getType());
            str = str.replaceAll("\\(void\\)", "()");
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        return str;
    }

    public Package getOrCreatePackage(String prefixName, String name) throws DOMException {
        String fullName = name;
        if (!prefixName.equals("")) {
            fullName = String.valueOf(prefixName) + "." + name;
        }
        if (this.packageTable.containsKey(fullName)) {
            return (Package)this.packageTable.get(fullName);
        }
        Package pkg = new Package(name);
        this.packageTable.put(fullName, pkg);
        return pkg;
    }

    protected static String joinName(String[] name) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < name.length) {
            buffer.append(name[i]);
            buffer.append("::");
            ++i;
        }
        return buffer.toString();
    }

    public Position convertFileLocation(IASTFileLocation location) {
        if (location == null) {
            return null;
        }
        return new Position(this.getOrCreateFile(location.getFileName()), location.getStartingLineNumber(), 0, location.getEndingLineNumber(), 0);
    }

    private de.fzi.sissy.metamod.File getOrCreateFile(String str) {
        String filename = new File(str).getAbsolutePath();
        de.fzi.sissy.metamod.File existentFile = null;
        for (de.fzi.sissy.metamod.File f : this.root.getFiles()) {
            if (!f.getPathName().toLowerCase().equals(filename.toLowerCase())) continue;
            existentFile = f;
        }
        if (existentFile == null) {
            existentFile = new de.fzi.sissy.metamod.File(filename);
            this.root.addFile(existentFile);
        }
        return existentFile;
    }

    private void setDefined(Object o) {
        this.definedEntities.add(o);
    }

    private boolean isDefined(Object o) {
        return this.definedEntities.contains(o);
    }

    private void setDeclared(Object o) {
        this.declaredEntities.add(o);
    }

    private boolean isDeclared(Object o) {
        return this.declaredEntities.contains(o);
    }

    public static String[] getParameterTypeStringArray(IType[] parms) {
        String[] result = new String[parms.length];
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result[i] = parms[i] instanceof ProblemBinding ? ((ProblemBinding)parms[i]).getPhysicalNode().toString() : ASTTypeUtil.getType((IType)parms[i]);
            }
            ++i;
        }
        return result;
    }

    public static String getParameterTypeString(IFunctionType type) {
        IType[] parms = null;
        try {
            parms = type.getParameterTypes();
        }
        catch (DOMException dOMException) {
            return "";
        }
        return MetamodConverter.getParameterTypeString(parms);
    }

    public static String getParameterTypeString(IType[] tparms) {
        StringBuffer result = new StringBuffer();
        String[] parms = MetamodConverter.getParameterTypeStringArray(tparms);
        result.append(Keywords.cpLPAREN);
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result.append(parms[i]);
                if (i < parms.length - 1) {
                    result.append(", ");
                }
            }
            ++i;
        }
        result.append(Keywords.cpRPAREN);
        return result.toString();
    }

    public Hashtable getFieldTable() {
        return this.fieldTable;
    }

    public Function getCurrentFunction() {
        return this.currentFunction;
    }
}

