/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.cpp.cdt3.RefCollector;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTScopedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;

public class CompilationUnitPrinter {
    private HashMap fmap;
    private HashMap cmap;

    public CompilationUnitPrinter(HashMap fmap, HashMap cmap) {
        this.fmap = fmap;
        this.cmap = cmap;
    }

    public void print(IASTCompilationUnit cu) {
        try {
            Iterator iter = cu.getDeclarations();
            while (iter.hasNext()) {
                IASTDeclaration decl = (IASTDeclaration)iter.next();
                this.printFull(decl, 0);
            }
        }
        catch (ASTNotImplementedException e) {
            e.printStackTrace();
        }
    }

    private void printFull(IASTDeclaration decl, int off) throws ASTNotImplementedException {
        if (decl instanceof IASTAbstractTypeSpecifierDeclaration) {
            this.printFull((IASTAbstractTypeSpecifierDeclaration)decl, off);
        } else if (decl instanceof IASTFunction) {
            this.printFull((IASTFunction)decl, off);
        } else if (decl instanceof IASTField) {
            this.print((IASTField)decl, off);
        } else if (decl instanceof IASTVariable) {
            this.print((IASTVariable)decl, off);
        }
    }

    private void print(IASTDeclaration decl, int off) throws ASTNotImplementedException {
        if (decl instanceof IASTAbstractTypeSpecifierDeclaration) {
            this.print((IASTAbstractTypeSpecifierDeclaration)decl, off);
        } else if (decl instanceof IASTFunction) {
            this.print((IASTFunction)decl, off);
        } else if (decl instanceof IASTField) {
            this.print((IASTField)decl, off);
        } else if (decl instanceof IASTVariable) {
            this.print((IASTVariable)decl, off);
        }
    }

    private void printFull(IASTAbstractTypeSpecifierDeclaration typeDecl, int off) throws ASTNotImplementedException {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        System.out.println("IASTAbstractTypeSpecifierDeclaration");
        IASTTypeSpecifier typeSpec = typeDecl.getTypeSpecifier();
        this.printFull(typeSpec, off + 2);
    }

    private void print(IASTAbstractTypeSpecifierDeclaration typeDecl, int off) throws ASTNotImplementedException {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        System.out.println("IASTAbstractTypeSpecifierDeclaration");
        IASTTypeSpecifier typeSpec = typeDecl.getTypeSpecifier();
        this.print(typeSpec, off + 2);
    }

    private void printFull(IASTTypeSpecifier typeSpec, int off) throws ASTNotImplementedException {
        if (typeSpec instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpec = (IASTClassSpecifier)typeSpec;
            this.printFull(classSpec, off);
        } else if (typeSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)typeSpec;
            int i = 0;
            while (i < off) {
                System.out.print(" ");
                ++i;
            }
            System.out.println("IASTElaboratedTypeSpecifier " + elabTypeSpec.getName());
        } else if (typeSpec instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleTypeSpec = (IASTSimpleTypeSpecifier)typeSpec;
            int i = 0;
            while (i < off) {
                System.out.print(" ");
                ++i;
            }
            System.out.println("IASTSimpleTypeSpecifier " + simpleTypeSpec.getTypename());
        }
    }

    private void print(IASTTypeSpecifier typeSpec, int off) throws ASTNotImplementedException {
        if (typeSpec instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpec = (IASTClassSpecifier)typeSpec;
            this.print(classSpec, off);
        } else if (typeSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)typeSpec;
            int i = 0;
            while (i < off) {
                System.out.print(" ");
                ++i;
            }
            System.out.println("IASTElaboratedTypeSpecifier " + elabTypeSpec.getName());
        } else if (typeSpec instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleTypeSpec = (IASTSimpleTypeSpecifier)typeSpec;
            int i = 0;
            while (i < off) {
                System.out.print(" ");
                ++i;
            }
            System.out.println("IASTSimpleTypeSpecifier " + simpleTypeSpec.getTypename());
        }
    }

    private void printFull(IASTClassSpecifier classSpec, int off) throws ASTNotImplementedException {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        System.out.println("IASTClassSpecifier " + classSpec.getName());
        Iterator iter = classSpec.getDeclarations();
        while (iter.hasNext()) {
            IASTDeclaration decl = (IASTDeclaration)iter.next();
            this.printFull(decl, off + 2);
        }
        int i2 = 0;
        while (i2 < off + 2) {
            System.out.print(" ");
            ++i2;
        }
        System.out.println("references:");
        RefCollector collector = (RefCollector)this.cmap.get(classSpec);
        for (ISourceElementCallbackDelegate elem : collector.getRefs()) {
            this.print(elem, off + 4);
        }
    }

    private void print(IASTClassSpecifier classSpec, int off) throws ASTNotImplementedException {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        System.out.println("IASTClassSpecifier " + classSpec.getName());
    }

    private void printFull(IASTFunction fun, int off) throws ASTNotImplementedException {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        IASTAbstractDeclaration decl = fun.getReturnType();
        IASTTypeSpecifier typeSpec = decl.getTypeSpecifier();
        System.out.println("Function " + this.getTypename(typeSpec) + " " + fun.getName());
        int i2 = 0;
        while (i2 < off + 2) {
            System.out.print(" ");
            ++i2;
        }
        System.out.println("references:");
        RefCollector collector = (RefCollector)this.fmap.get(fun);
        for (ISourceElementCallbackDelegate elem : collector.getRefs()) {
            this.print(elem, off + 4);
        }
    }

    private void print(IASTFunction fun, int off) {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        IASTAbstractDeclaration decl = fun.getReturnType();
        IASTTypeSpecifier typeSpec = decl.getTypeSpecifier();
        System.out.println("Function " + this.getTypename(typeSpec) + " " + fun.getName());
    }

    private void print(ISourceElementCallbackDelegate elem, int off) throws ASTNotImplementedException {
        if (elem instanceof IASTField) {
            this.print((IASTField)elem, off);
        } else if (elem instanceof IASTVariable) {
            this.print((IASTVariable)elem, off);
        } else if (elem instanceof IASTFunction) {
            this.print((IASTFunction)elem, off);
        } else if (elem instanceof IASTClassSpecifier) {
            this.print((IASTClassSpecifier)elem, off);
        }
    }

    private void print(IASTField fld, int off) {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        IASTAbstractDeclaration decl = fld.getAbstractDeclaration();
        IASTTypeSpecifier typeSpec = decl.getTypeSpecifier();
        System.out.println("Field " + this.getTypename(typeSpec) + " " + fld.getName());
    }

    private void print(IASTVariable var, int off) throws ASTNotImplementedException {
        int i = 0;
        while (i < off) {
            System.out.print(" ");
            ++i;
        }
        IASTAbstractDeclaration decl = var.getAbstractDeclaration();
        IASTTypeSpecifier typeSpec = decl.getTypeSpecifier();
        System.out.println("Variable " + this.getTypename(typeSpec) + " " + var.getName());
    }

    private String getTypename(IASTTypeSpecifier typeSpec) {
        if (typeSpec instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpec = (IASTClassSpecifier)typeSpec;
            return classSpec.getName();
        }
        if (typeSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)typeSpec;
            return elabTypeSpec.getName();
        }
        if (typeSpec instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumSpec = (IASTEnumerationSpecifier)typeSpec;
            return enumSpec.getName();
        }
        if (typeSpec instanceof IASTScopedTypeSpecifier) {
            IASTScopedTypeSpecifier scTypeSpec = (IASTScopedTypeSpecifier)typeSpec;
            return scTypeSpec.toString();
        }
        if (typeSpec instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleTypeSpec = (IASTSimpleTypeSpecifier)typeSpec;
            return simpleTypeSpec.getTypename();
        }
        if (typeSpec instanceof IASTTemplateParameter) {
            IASTTemplateParameter templParam = (IASTTemplateParameter)typeSpec;
            return templParam.getIdentifier();
        }
        if (typeSpec instanceof IASTTypedefDeclaration) {
            IASTTypedefDeclaration typedef = (IASTTypedefDeclaration)typeSpec;
            return typedef.getName();
        }
        return "";
    }
}

