/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.cpp.cdt3.ASTMapper;
import de.fzi.sissy.extractors.cpp.cdt3.RefCollector;
import de.fzi.sissy.extractors.cpp.cdt3.StatementTracker;
import de.fzi.sissy.extractors.cpp.cdt3.Util;
import de.fzi.sissy.extractors.cpp.cdt3.ast.ExtendedReference;
import de.fzi.sissy.utils.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBinaryExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTConditionalExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEmptyExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTLinkageSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTLiteralExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNewExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUnaryExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUnaryIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUnaryTypeIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTVariableReference;

public class Callback2
implements ISourceElementRequestor,
ASTMapper {
    protected IASTCompilationUnit compUnit = null;
    protected List inclusions = new ArrayList();
    protected List macros = new ArrayList();
    protected List importedGlobalFunctions = new ArrayList();
    protected List importedGlobalVariables = new ArrayList();
    protected StatementTracker tracker = StatementTracker.getInstance();
    protected LinkedList scopeStack = new LinkedList();
    protected IASTScope currentScope = null;
    protected int inclusionLevel = 0;
    private HashMap classSpecifierMap = new HashMap();
    private HashMap functionMap = new HashMap();
    private boolean extendedReferences = false;
    Stack inclStack = new Stack();
    HashMap referenceInfo = new HashMap();

    public Iterator getInclusions() {
        return this.inclusions.iterator();
    }

    public Iterator getMacros() {
        return this.macros.iterator();
    }

    public Iterator getDeclarations() {
        try {
            return this.compUnit.getDeclarations();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {
            return null;
        }
    }

    public IASTCompilationUnit getCompilationUnit() {
        return this.compUnit;
    }

    public int getInclusionLevel() {
        return this.inclusionLevel;
    }

    private void addElement(IASTDeclaration element) {
        if (this.inclusionLevel == 0) {
            if (this.currentScope instanceof ASTScope) {
                Debug.cbinfo((Object)("adding declaration: " + element + " to " + this.currentScope));
                ((ASTScope)this.currentScope).addDeclaration(element);
            } else if (this.currentScope instanceof ASTLinkageSpecification) {
                ((ASTLinkageSpecification)this.currentScope).addDeclaration(element);
            }
        }
    }

    public IASTScope getCurrentScope() {
        return this.currentScope;
    }

    private void enterScope(IASTNode node) {
        if (node instanceof IASTScope) {
            if (node instanceof ASTScope) {
                ((ASTScope)node).initDeclarations();
            }
            this.pushScope((IASTScope)node);
        }
    }

    private void exitScope(IASTNode node) {
        if (node instanceof IASTScope) {
            this.popScope();
        }
    }

    private void pushScope(IASTScope scope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = scope;
    }

    private IASTScope popScope() {
        IASTScope oldScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return oldScope;
    }

    @Override
    public HashMap getClassSpecifierMap() {
        return this.classSpecifierMap;
    }

    @Override
    public HashMap getFunctionMap() {
        return this.functionMap;
    }

    private void addRef(ISourceElementCallbackDelegate ref) {
        if (this.inclusionLevel == 0) {
            if (this.currentScope instanceof IASTFunction) {
                RefCollector collector = (RefCollector)this.functionMap.get(this.currentScope);
                collector.addRef(ref);
            } else if (this.currentScope instanceof IASTClassSpecifier) {
                RefCollector collector = (RefCollector)this.classSpecifierMap.get(this.currentScope);
                collector.addRef(ref);
            }
        }
    }

    public void setExtendedReferences(boolean use) {
        this.extendedReferences = use;
    }

    private void extractReferences(ASTExpression expr, boolean write) {
        for (IASTReference ref : expr.getReferences()) {
            ExtendedReference extRef = new ExtendedReference(ref, write);
            if (!this.extendedReferences) continue;
            this.addReferenceToCurrentStatement(extRef);
        }
    }

    public void processExpression(ASTEmptyExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
    }

    public void processExpression(ASTIdExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
    }

    public void processExpression(ASTUnaryIdExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
        this.processExpression(expr.getLHSExpression(), write);
    }

    public void processExpression(ASTLiteralExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
    }

    public void processExpression(ASTNewExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
    }

    public void processExpression(ASTTypeIdExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
    }

    public void processExpression(ASTUnaryExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
        if (expr.getExpressionKind() == IASTExpression.Kind.UNARY_DECREMENT || expr.getExpressionKind() == IASTExpression.Kind.UNARY_INCREMENT) {
            this.processExpression(expr.getLHSExpression(), true);
        } else {
            this.processExpression(expr.getLHSExpression(), write);
        }
    }

    public void processExpression(ASTBinaryExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
        Debug.cbinfo((Object)("expr: " + expr.getReferences().size()));
        Debug.cbinfo((Object)("lhs: " + ((ASTExpression)expr.getLHSExpression()).getReferences().size()));
        Debug.cbinfo((Object)("rhs: " + ((ASTExpression)expr.getRHSExpression()).getReferences().size()));
        if (expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT || expr.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR || expr.getExpressionKind() == IASTExpression.Kind.POSTFIX_DECREMENT || expr.getExpressionKind() == IASTExpression.Kind.POSTFIX_INCREMENT) {
            IASTExpression left = expr.getLHSExpression();
            IASTExpression right = expr.getRHSExpression();
            this.processExpression(left, true);
            this.processExpression(right, write);
        } else {
            IASTExpression left = expr.getLHSExpression();
            IASTExpression right = expr.getRHSExpression();
            this.processExpression(left, write);
            this.processExpression(right, write);
        }
    }

    public void processExpression(ASTConditionalExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
        this.processExpression(expr.getLHSExpression(), write);
        this.processExpression(expr.getRHSExpression(), write);
        this.processExpression(expr.getThirdExpression(), write);
    }

    public void processExpression(ASTUnaryTypeIdExpression expr, boolean write) {
        this.extractReferences((ASTExpression)expr, write);
        this.processExpression(expr.getLHSExpression(), write);
    }

    public void processExpression(IASTExpression expr, boolean write) {
        Debug.cbinfo((Object)("processing expression: " + expr));
        if (expr instanceof ASTEmptyExpression) {
            this.processExpression((ASTEmptyExpression)expr, write);
        } else if (expr instanceof ASTIdExpression) {
            this.processExpression((ASTIdExpression)expr, write);
        } else if (expr instanceof ASTUnaryIdExpression) {
            this.processExpression((ASTUnaryIdExpression)expr, write);
        } else if (expr instanceof ASTLiteralExpression) {
            this.processExpression((ASTLiteralExpression)expr, write);
        } else if (expr instanceof ASTNewExpression) {
            this.processExpression((ASTNewExpression)expr, write);
        } else if (expr instanceof ASTTypeIdExpression) {
            this.processExpression((ASTTypeIdExpression)expr, write);
        } else if (expr instanceof ASTUnaryExpression) {
            this.processExpression((ASTUnaryExpression)expr, write);
        } else if (expr instanceof ASTBinaryExpression) {
            this.processExpression((ASTBinaryExpression)expr, write);
        } else if (expr instanceof ASTConditionalExpression) {
            this.processExpression((ASTConditionalExpression)expr, write);
        } else if (expr instanceof ASTUnaryTypeIdExpression) {
            this.processExpression((ASTUnaryTypeIdExpression)expr, write);
        }
    }

    public boolean acceptProblem(IProblem problem) {
        return true;
    }

    public void acceptMacro(IASTMacro macro) {
        if (this.inclusionLevel == 0) {
            this.macros.add(macro);
        }
    }

    public void acceptVariable(IASTVariable variable) {
        Debug.cbinfo((Object)("accept variable: " + variable.getName()));
        this.addElement((IASTDeclaration)variable);
        this.addRef((ISourceElementCallbackDelegate)variable);
        ASTVariableReference ref = new ASTVariableReference(variable.getStartingOffset(), variable);
        this.addReferenceToCurrentStatement((IASTReference)ref);
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        IASTAbstractDeclaration decl = function.getReturnType();
        Debug.cbinfo((Object)decl);
        Debug.cbinfo((Object)decl.getParameters());
        Iterator params = decl.getParameters();
        while (params.hasNext()) {
            Object p = params.next();
            Debug.cbinfo(p.getClass());
            Debug.cbinfo(p);
        }
        if (function.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)function);
        } else if (function.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)function.getOwnerTemplateDeclaration()));
        }
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition asmDefinition) {
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        Debug.cbinfo((Object)("adding typedef decl: " + typedef.getName()));
        this.addElement((IASTDeclaration)typedef);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.enterScope((IASTNode)enumeration);
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        Debug.cbinfo((Object)elaboratedType);
        this.enterScope((IASTNode)elaboratedType);
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
        Debug.cbinfo((Object)abstractDeclaration);
        if (abstractDeclaration.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)abstractDeclaration);
        } else if (abstractDeclaration.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)abstractDeclaration.getOwnerTemplateDeclaration()));
        }
    }

    public void acceptExpression(IASTExpression expression) {
        this.processExpression(expression, false);
    }

    public void enterFunctionBody(IASTFunction function) {
        if (function.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)function);
        } else if (function.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)function.getOwnerTemplateDeclaration()));
        }
        if (this.functionMap.get(function) == null) {
            RefCollector collector = new RefCollector();
            this.functionMap.put(function, collector);
        }
        this.enterScope((IASTNode)function);
    }

    public void exitFunctionBody(IASTFunction function) {
        function.setHasFunctionBody(true);
        this.exitScope((IASTNode)function);
    }

    public void enterCodeBlock(IASTCodeScope scope) {
    }

    public void exitCodeBlock(IASTCodeScope scope) {
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.enterScope((IASTNode)compilationUnit);
    }

    public void enterInclusion(IASTInclusion inclusion) {
        this.inclStack.push(inclusion.getFullFileName());
        if (this.inclusionLevel == 0) {
            this.inclusions.add(inclusion);
        }
        ++this.inclusionLevel;
        Debug.cbinfo((Object)("new inclusion level: " + this.inclusionLevel));
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.addElement((IASTDeclaration)namespaceDefinition);
        this.enterScope((IASTNode)namespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        Debug.cbinfo((Object)("enter class: " + classSpecification.getName()));
        if (this.classSpecifierMap.get(classSpecification) == null) {
            RefCollector collector = new RefCollector();
            this.classSpecifierMap.put(classSpecification, collector);
        }
        this.enterScope((IASTNode)classSpecification);
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.addElement((IASTDeclaration)linkageSpec);
        this.enterScope((IASTNode)linkageSpec);
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        if (method.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)method);
        } else if (method.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)method.getOwnerTemplateDeclaration()));
        }
    }

    public void enterMethodBody(IASTMethod method) {
        Debug.cbinfo((Object)("enter method (" + this.inclusionLevel + "): " + Util.reduce(method.getFullyQualifiedName()) + " (" + method + ")"));
        if (method.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)method);
        } else if (method.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)method.getOwnerTemplateDeclaration()));
        }
        if (this.functionMap.get(method) == null) {
            RefCollector collector = new RefCollector();
            this.functionMap.put(method, collector);
        }
        this.enterScope((IASTNode)method);
    }

    public void exitMethodBody(IASTMethod method) {
        method.setHasFunctionBody(true);
        this.exitScope((IASTNode)method);
    }

    public void acceptField(IASTField field) {
        this.addElement((IASTDeclaration)field);
    }

    public void acceptClassReference(IASTClassReference reference) {
        IASTClassSpecifier classSpec = (IASTClassSpecifier)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)classSpec);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    public void acceptTypedefReference(IASTTypedefReference reference) {
        IASTTypedefDeclaration typeDefDecl = (IASTTypedefDeclaration)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)typeDefDecl);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    public void acceptNamespaceReference(IASTNamespaceReference reference) {
    }

    public void acceptEnumerationReference(IASTEnumerationReference reference) {
    }

    public void acceptVariableReference(IASTVariableReference reference) {
        IASTVariable var = (IASTVariable)reference.getReferencedElement();
        Debug.cbinfo((Object)("referenced variable: " + var.getName()));
        this.addRef((ISourceElementCallbackDelegate)var);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
        IASTFunction fun = (IASTFunction)reference.getReferencedElement();
        Debug.cbinfo((Object)("referenced function: " + fun.getName()));
        this.addRef((ISourceElementCallbackDelegate)fun);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    public void acceptFieldReference(IASTFieldReference reference) {
        IASTField fld = (IASTField)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)fld);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    public void acceptMethodReference(IASTMethodReference reference) {
        IASTMethod method = (IASTMethod)reference.getReferencedElement();
        Debug.cbinfo((Object)("referenced method: " + method.getName()));
        this.addRef((ISourceElementCallbackDelegate)method);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference reference) {
    }

    public void acceptParameterReference(IASTParameterReference reference) {
        IASTParameterDeclaration paramDecl = (IASTParameterDeclaration)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)paramDecl);
        if (!this.extendedReferences) {
            this.addReferenceToCurrentStatement((IASTReference)reference);
        }
    }

    private void addReferenceToCurrentStatement(IASTReference ref) {
        if (this.tracker.getCurrentStatement() != null && this.inclusionLevel == 0) {
            this.tracker.getCurrentStatement().addReference(ref);
        }
    }

    public void acceptTemplateParameterReference(IASTTemplateParameterReference reference) {
    }

    public void acceptFriendDeclaration(IASTDeclaration declaration) {
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.exitScope((IASTNode)linkageSpec);
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.exitScope((IASTNode)classSpecification);
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.exitScope((IASTNode)namespaceDefinition);
    }

    public void exitInclusion(IASTInclusion inclusion) {
        if (((String)this.inclStack.peek()).equals(inclusion.getFullFileName())) {
            this.inclStack.pop();
            --this.inclusionLevel;
            Debug.cbinfo((Object)("new inclusion level: " + this.inclusionLevel));
        }
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.compUnit = compilationUnit;
    }

    public CodeReader createReader(String finalPath, Iterator workingCopies) {
        return InternalParserUtil.createFileReader((String)finalPath);
    }

    public boolean parserTimeout() {
        return false;
    }

    @Override
    public HashMap getReferenceMap() {
        return this.referenceInfo;
    }

    public void setIsWriteAccess(IASTReference ref) {
        this.referenceInfo.put(ref, new Boolean(true));
    }
}

