/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.cpp.cdt3.Callback2;
import de.fzi.sissy.extractors.cpp.cdt3.ExtractorLogService;
import de.fzi.sissy.extractors.cpp.cdt3.IExtractorASTFactory;
import de.fzi.sissy.extractors.cpp.cdt3.IExtractorParser;
import de.fzi.sissy.extractors.cpp.cdt3.MetamodConverter;
import de.fzi.sissy.extractors.cpp.cdt3.StatementTracker;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.ParsingErrorHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.IParserData;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.Scanner2;

public class CDT3Extractor {
    private ModelElementRepository modelElementRepository;
    private MetamodConverter converter;
    private ParserMode mode = ParserMode.COMPLETE_PARSE;
    private ParserLanguage lang = ParserLanguage.CPP;
    private ExtractorLogService log = new ExtractorLogService();
    private ExtendedScannerInfo scannerInfo;
    private boolean debugMetamod = false;
    private Hashtable<Object, Object> overwrittendefs = new Hashtable();

    public CDT3Extractor(ModelElementRepository modelElementRepository, ExtractorConfiguration extractorConfiguration, Map definitions, List<String> includePaths) {
        this.modelElementRepository = modelElementRepository;
        this.converter = new MetamodConverter(modelElementRepository, extractorConfiguration);
        this.scannerInfo = new ExtendedScannerInfo(definitions, includePaths.toArray(new String[includePaths.size()]));
    }

    public de.fzi.sissy.metamod.File extractFileToMetamod(File f) {
        ParsingErrorHelper.getInstance().setCurrentFile(f.getAbsolutePath());
        Callback2 callback = new Callback2();
        callback.setExtendedReferences(true);
        StatementTracker.getInstance().clearStack();
        this.extractCDT(f, callback);
        de.fzi.sissy.metamod.File file = null;
        file = this.getOrCreateFile(f);
        return file;
    }

    private de.fzi.sissy.metamod.File getOrCreateFile(File file) {
        de.fzi.sissy.metamod.File existentFile = null;
        for (de.fzi.sissy.metamod.File f : this.modelElementRepository.getRoot().getFiles()) {
            if (!f.getPathName().toLowerCase().equals(file.getAbsolutePath().toLowerCase())) continue;
            existentFile = f;
        }
        if (existentFile == null) {
            existentFile = new de.fzi.sissy.metamod.File(file.getAbsolutePath());
            this.modelElementRepository.getRoot().addFile(existentFile);
        }
        return existentFile;
    }

    private void buildIncludes(de.fzi.sissy.metamod.File file, Callback2 callback) {
        Iterator iter = callback.getInclusions();
        while (iter.hasNext()) {
            de.fzi.sissy.metamod.File f2;
            IASTInclusion incl = (IASTInclusion)iter.next();
            boolean present = false;
            for (de.fzi.sissy.metamod.File f2 : this.modelElementRepository.getRoot().getFiles()) {
                if (!f2.getPathName().equals(incl.getFullFileName())) continue;
                present = true;
            }
            if (present) continue;
            f2 = new de.fzi.sissy.metamod.File(incl.getFullFileName());
            this.modelElementRepository.getRoot().addFile(f2);
            file.addIncludedFile(f2);
        }
    }

    private IExtractorASTFactory extractCDT(File file, ISourceElementRequestor callback) {
        try {
            CodeReader codeReader = new CodeReader(file.getAbsolutePath());
            DOMScanner scanner = new DOMScanner(codeReader, (IScannerInfo)this.scannerInfo, this.mode, this.lang, (IParserLogService)this.log, (IScannerExtensionConfiguration)new GPPScannerExtensionConfiguration(), (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
            if (scanner instanceof Scanner2) {
                for (String string : this.overwrittendefs.keySet()) {
                    String cfr_ignored_0 = (String)this.overwrittendefs.get(string);
                }
            }
            GPPParserExtensionConfiguration config = new GPPParserExtensionConfiguration();
            GNUCPPSourceParser gNUCPPSourceParser = new GNUCPPSourceParser((IScanner)scanner, this.mode, (IParserLogService)this.log, (ICPPParserExtensionConfiguration)config);
            IASTTranslationUnit trUnit = gNUCPPSourceParser.parse();
            Debug.println((String)"Done");
            this.converter.convert(trUnit);
            int nProblems = this.converter.getProblems().size();
            if (nProblems == 0) {
                Debug.println((String)"Parsing successful");
            } else {
                Debug.warning((String)("Parsing problematic: " + nProblems + " problems found"));
                for (Object o : this.converter.getProblems()) {
                    if (o instanceof IASTProblem) {
                        if (((IASTProblem)o).isError()) {
                            Debug.error((String)("CDT-Error: " + ((IASTProblem)o).getMessage()));
                            continue;
                        }
                        if (!((IASTProblem)o).isWarning()) continue;
                        Debug.warning((String)("CDT-Warning: " + ((IASTProblem)o).getMessage()));
                        continue;
                    }
                    if (o instanceof ProblemBinding) {
                        Debug.warning((String)("ProblemBinding: " + ((ProblemBinding)o).getClass().getSimpleName() + " " + ((ProblemBinding)o).getMessage() + " File: " + ((ProblemBinding)o).getFileName() + " Line: " + ((ProblemBinding)o).getLineNumber()));
                        continue;
                    }
                    Debug.error((String)"Unknown problem found");
                }
            }
            if (gNUCPPSourceParser instanceof IExtractorParser) {
                return (IExtractorASTFactory)((IParserData)gNUCPPSourceParser).getAstFactory();
            }
        }
        catch (ParserFactoryError pfe) {
            pfe.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (Exception e) {
            Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
            e.printStackTrace();
        }
        return null;
    }
}

