/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.cpp.cdt3.ASTVisitor;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMember;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;

public class ASTWalker {
    private ASTVisitor v;

    public ASTWalker(ASTVisitor visitor) {
        this.v = visitor;
    }

    public int walk(IASTCompilationUnit cu) {
        try {
            int loc = 0;
            Iterator iter = cu.getDeclarations();
            while (iter.hasNext()) {
                int lines;
                IASTDeclaration decl = (IASTDeclaration)iter.next();
                if (decl instanceof IASTOffsetableElement && (lines = ((IASTOffsetableElement)decl).getEndingLine() - ((IASTOffsetableElement)decl).getStartingLine() + 1) > 0) {
                    loc += lines;
                }
                this.walkIASTDeclaration(decl);
            }
            return loc;
        }
        catch (ASTNotImplementedException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void walkIASTDeclaration(IASTDeclaration decl) throws ASTNotImplementedException {
        if (decl instanceof IASTAbstractTypeSpecifierDeclaration) {
            IASTAbstractTypeSpecifierDeclaration absTypeSpec = (IASTAbstractTypeSpecifierDeclaration)decl;
            IASTTypeSpecifier typeSpec = absTypeSpec.getTypeSpecifier();
            if (typeSpec instanceof IASTClassSpecifier) {
                this.walkIASTClassSpecifier((IASTClassSpecifier)typeSpec);
            }
        } else if (decl instanceof IASTTypedefDeclaration) {
            this.v.visitIASTTypedefDeclaration((IASTTypedefDeclaration)decl);
        } else if (decl instanceof IASTFunction) {
            IASTFunction fun = (IASTFunction)decl;
            if (fun instanceof IASTMethod) {
                this.walkIASTMethod((IASTMethod)fun);
            } else {
                this.walkIASTFunction(fun);
            }
        } else if (decl instanceof IASTVariable) {
            IASTVariable var = (IASTVariable)decl;
            if (var instanceof IASTField) {
                this.walkIASTField((IASTField)var);
            } else {
                this.walkIASTVariable(var);
            }
        } else if (decl instanceof IASTNamespaceDefinition) {
            this.walkIASTNamespaceDefinition((IASTNamespaceDefinition)decl);
        }
    }

    private void walkIASTNamespaceDefinition(IASTNamespaceDefinition definition) throws ASTNotImplementedException {
        this.v.enterNamespaceDefinition(definition);
        Iterator iter = definition.getDeclarations();
        while (iter.hasNext()) {
            IASTDeclaration decl = (IASTDeclaration)iter.next();
            this.walkIASTDeclaration(decl);
        }
        this.v.exitNamespaceDefinition(definition);
    }

    private void walkIASTClassSpecifier(IASTClassSpecifier specifier) throws ASTNotImplementedException {
        this.v.visitIASTClassSpecifier(specifier);
        Iterator iter = specifier.getDeclarations();
        while (iter.hasNext()) {
            IASTDeclaration decl = (IASTDeclaration)iter.next();
            this.walkIASTDeclaration(decl);
        }
    }

    private void walkIASTMember(IASTMember member) throws ASTNotImplementedException {
        if (member instanceof IASTMethod) {
            this.walkIASTMethod((IASTMethod)member);
        } else if (member instanceof IASTField) {
            this.walkIASTField((IASTField)member);
        }
    }

    private void walkIASTMethod(IASTMethod method) throws ASTNotImplementedException {
        this.v.visitIASTMethod(method);
        Iterator iter = method.getDeclarations();
        while (iter.hasNext()) {
            IASTDeclaration decl = (IASTDeclaration)iter.next();
            this.walkIASTDeclaration(decl);
        }
    }

    private void walkIASTField(IASTField field) {
        this.v.visitIASTField(field);
    }

    private void walkIASTFunction(IASTFunction function) throws ASTNotImplementedException {
        this.v.visitIASTFunction(function);
        Iterator iter = function.getDeclarations();
        while (iter.hasNext()) {
            IASTDeclaration decl = (IASTDeclaration)iter.next();
            this.walkIASTDeclaration(decl);
        }
    }

    private void walkIASTVariable(IASTVariable variable) {
        this.v.visitIASTVariable(variable);
    }
}

