/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.mat;

import eu.qimpress.ide.analysis.reliability.rmc.mat.RmcEquation;
import eu.qimpress.ide.analysis.reliability.rmc.mat.RmcVariables;
import eu.qimpress.ide.analysis.reliability.rmc.mat.Solver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.TargetVariableNotFoundException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RmcSolver
implements Solver {
    private final List<RmcEquation> rmcEquations;
    private final RmcVariables inputVariables;
    private final List<BigDecimal> resultVariables;
    private long currentIterations = 0L;
    private double currentMSV = Double.MAX_VALUE;

    public RmcSolver(RmcVariables inputVariables, List<RmcEquation> equations) {
        this.inputVariables = inputVariables;
        this.rmcEquations = equations;
        this.resultVariables = new ArrayList<BigDecimal>(equations.size());
        int i = 0;
        while (i < equations.size()) {
            this.resultVariables.add(null);
            ++i;
        }
    }

    @Override
    public long getNumIterations() {
        return this.currentIterations;
    }

    @Override
    public void printCurrentAssign() {
        for (RmcEquation equation : this.rmcEquations) {
            System.out.println(String.valueOf(equation.variableName) + "=" + this.resultVariables.get(this.inputVariables.getVariableIdFromName(equation.variableName)));
        }
    }

    @Override
    public HashMap<String, Double> getCurrentAssignment() {
        HashMap<String, Double> assignmentOfVariables = new HashMap<String, Double>();
        for (RmcEquation equation : this.rmcEquations) {
            assignmentOfVariables.put(equation.variableName, this.inputVariables.getVariableValueFromName(equation.variableName).doubleValue());
        }
        return assignmentOfVariables;
    }

    @Override
    public void setCurrentAssignment(HashMap<String, Double> assigns) throws Exception {
        for (String key : assigns.keySet()) {
            this.inputVariables.setVariableValue(key, new BigDecimal(assigns.get(key).toString()));
        }
    }

    @Override
    public void iterateUntilMSVlessThan(double maxMSV, long maxIterations) throws Exception {
        while (this.currentMSV > maxMSV && this.currentIterations < maxIterations) {
            this.currentMSV = 0.0;
            ++this.currentIterations;
            for (RmcEquation rmcEquation : this.rmcEquations) {
                this.resultVariables.set(rmcEquation.variableId, rmcEquation.calculate());
            }
            for (RmcEquation rmcEquation : this.rmcEquations) {
                this.currentMSV = Math.max(this.currentMSV, this.resultVariables.get(rmcEquation.variableId).subtract(this.inputVariables.getVariableValueFromId(rmcEquation.variableId)).abs().doubleValue());
                this.inputVariables.setVariableValue(rmcEquation.variableName, this.resultVariables.get(rmcEquation.variableId));
            }
        }
    }

    @Override
    public double getValue(String variableName) throws TargetVariableNotFoundException {
        return this.resultVariables.get(this.inputVariables.getVariableIdFromName(variableName)).doubleValue();
    }

    @Override
    public void iterateUntilTargetDeltalessThan(String var, double maxVariation, long maxIterations) throws Exception {
        throw new Exception("Not implemented");
    }

    @Override
    public void iterateUntilTargetAVG10DeltalessThan(String var, double maxVariation, long maxIterations) throws Exception {
        throw new Exception("Not implemented");
    }

    @Override
    public void doNIterations(long num) throws Exception {
        throw new Exception("Not implemented");
    }

    @Override
    public double getMSV() {
        return this.currentMSV;
    }
}

