/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.mat;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Calculator {
    public static String doubleNumberRegex = "[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?";

    public double result(String expression) {
        if (expression.length() < 1) {
            throw new NumberFormatException("Empty expression");
        }
        Pattern p = Pattern.compile("\\(?(" + doubleNumberRegex + ")([-\\*])(" + doubleNumberRegex + ")\\)?");
        Matcher m = p.matcher(expression);
        while (m.find()) {
            expression = m.replaceFirst(this.operation(m.group(3)).calculate(new BigDecimal(m.group(1)), new BigDecimal(m.group(4))).toString());
            m = p.matcher(expression);
        }
        return new BigDecimal(expression).doubleValue();
    }

    private Operation operation(String operator) {
        Operation[] operations;
        Operation[] operationArray = operations = new Operation[]{new Multiplication(), new Subtraction()};
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            Operation operation = operationArray[n2];
            if (operation.operatorMatch(operator)) {
                return operation;
            }
            ++n2;
        }
        return null;
    }

    class Multiplication
    implements Operation {
        Multiplication() {
        }

        @Override
        public BigDecimal calculate(BigDecimal preOperator, BigDecimal postOperator) {
            return preOperator.multiply(postOperator);
        }

        @Override
        public boolean operatorMatch(String operator) {
            return "*".equals(operator);
        }
    }

    static interface Operation {
        public boolean operatorMatch(String var1);

        public BigDecimal calculate(BigDecimal var1, BigDecimal var2);
    }

    class Subtraction
    implements Operation {
        Subtraction() {
        }

        @Override
        public BigDecimal calculate(BigDecimal preOperator, BigDecimal postOperator) {
            return preOperator.subtract(postOperator);
        }

        @Override
        public boolean operatorMatch(String operator) {
            return "-".equals(operator);
        }
    }
}

