/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.core;

import eu.qimpress.ide.analysis.reliability.rmc.core.Module;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeNotFoundException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeType;
import eu.qimpress.ide.analysis.reliability.rmc.core.ProbabilityException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public class Node
implements Comparable {
    public static final int EXPECTED_NUM_OF_SUCCS = 5;
    private final NodeType type;
    private String name;
    private Module invok;
    private HashMap<Node, Double> successors;
    private BigDecimal outGoingProb = new BigDecimal(0);

    public Node(String name, NodeType type, Module m) throws NodeInstantiationException {
        this.name = name;
        this.type = type;
        if (type == NodeType.CALL && m == null) {
            throw new NodeInstantiationException("A CALL node must have a not null module argument");
        }
        this.invok = m;
        this.successors = type == NodeType.END || type == NodeType.FAILURE ? new HashMap(0) : new HashMap(5);
    }

    public HashMap<Node, Double> getSuccessorSet() {
        return this.successors;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Module getModule() {
        return this.invok;
    }

    public void addSuccessor(Node node, double prob) throws ProbabilityException, NodeInstantiationException {
        if (this.type == NodeType.END || this.type == NodeType.FAILURE) {
            throw new NodeInstantiationException("Cannot add a successor to a final node.");
        }
        BigDecimal bigDecimal = new BigDecimal(prob);
        if (this.outGoingProb.add(bigDecimal).doubleValue() > 1.0) {
            throw new ProbabilityException("Outgoing probability cannot exceed 1. (name: " + node.getName() + " probability: " + prob + ")");
        }
        this.successors.put(node, prob);
        this.outGoingProb = this.outGoingProb.add(new BigDecimal(prob));
    }

    public Iterator<Node> getSuccessors() {
        return this.successors.keySet().iterator();
    }

    public double getProbSuccessor(Node n) throws NodeNotFoundException {
        if (!this.successors.containsKey(n)) {
            throw new NodeNotFoundException("Requested node is not in the successors set.");
        }
        return this.successors.get(n);
    }

    public boolean validate() {
        if (this.type != NodeType.END && this.type != NodeType.FAILURE) {
            if (this.outGoingProb.doubleValue() != 1.0) {
                System.out.println("The outgoing probability of node " + this.name + " is not 1");
                return false;
            }
        } else if (this.outGoingProb.doubleValue() != 0.0) {
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o.getClass() != Node.class) {
            return -10;
        }
        if (o == this) {
            return 0;
        }
        return -1;
    }
}

