/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import eu.qimpress.ide.analysis.reliability.rmc.core.RMC;
import eu.qimpress.ide.analysis.reliability.rmc.mat.Solver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.TargetVariableNotFoundException;
import java.util.HashMap;
import java.util.Set;

public class ReliabilityAnalysisResult {
    private final RMC rmc;
    private final Solver solver;

    public ReliabilityAnalysisResult(RMC rmc, Solver solver) {
        this.rmc = rmc;
        this.solver = solver;
    }

    public Set<String> getEquations() {
        return this.rmc.getEquations();
    }

    public HashMap<String, Double> getAssignment() {
        return this.solver.getCurrentAssignment();
    }

    public double getReliability() {
        try {
            return this.solver.getValue(String.valueOf(this.rmc.getInitialModule().getName()) + this.rmc.getInitialModule().getStart().getName());
        }
        catch (TargetVariableNotFoundException targetVariableNotFoundException) {
            return 0.0;
        }
    }

    public double getMSV() {
        return this.solver.getMSV();
    }

    public long getIterations() {
        return this.solver.getNumIterations();
    }
}

